//
//  PPURLController+iOS.m
//

#import "PPURLController+iOS.h"
#import "PPNavigationController.h"
#import "PPMailComposeViewController.h"
#import "PPMessageComposeViewController.h"
#import "SafariServices/SFSafariViewController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation PPURLController (iOS)


//==============================================================================
//
//==============================================================================
+ (BOOL)canOpenURLFromViewControllerWithType:(PPURLControllerType)type
{
    // TSMC_Feature
#if defined (FOR_TSMC_VERSION)
    if([self isTSMCMode]==YES&&type==PPURLControllerType_Email)
    {
        return [[self class] tsmc_canOpenURLFromViewControllerWithType:type];
    }
#endif
    
    BOOL result = NO;
    
    //////////////////////////////////////////////////
    
    switch (type)
    {
        case PPURLControllerType_Email:
            result = [PPMailComposeViewController canSendMail];
            break;
            
        case PPURLControllerType_SMS:
            result = [PPMessageComposeViewController canSendText];
            break;
            
        default:
            result = [self canOpenURLWithType:type];
            break;
    }
   
    return result;
}


//===============================================================================
//
//===============================================================================
+ (BOOL)showFromViewController:(UIViewController *)superViewController withURLType:(PPURLControllerType)type parameter:(NSString *)parameter
{
    
    // TSMC_Feature
#if defined (FOR_TSMC_VERSION)
    if([self isTSMCMode]==YES&&type==PPURLControllerType_Email)
    {
        return [[self class] tsmc_showFromViewController:superViewController withURLType:type parameter:parameter];
    }
#endif
    BOOL result = NO;
    NSString *urlParam = nil;
    
    do
    {
        //////////////////////////////////////////////////
        
        UIApplication *application = [UIApplication sharedApplication];
        if(application==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        // remove scpace characters in prefix
        
        if([parameter length] == 0)
        {
            break;
        }
        
        urlParam = [NSString stringWithString:parameter];
        
        while ([urlParam hasPrefix:@" "] == YES)
        {
            urlParam = [urlParam substringFromIndex:1];
        }
        
        if(![urlParam length])
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *string = nil;
        NSString *nonOpenURLString = nil;
        BOOL choiceContentError = NO;
        
        switch(type)
        {
            case PPURLControllerType_Email:
            {
                //////////////////////////////////////////////////
                
                if((superViewController==nil && [self canOpenURLWithType:type]==NO)||
                   (superViewController!=nil && [PPMailComposeViewController canSendMail]==NO))
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                string = @"mailto:";
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                nonOpenURLString = urlParam;
                break;
            }
            case PPURLControllerType_EmailCC:
            {
                if((superViewController==nil && [self canOpenURLWithType:type]==NO)||
                   (superViewController!=nil && [PPMailComposeViewController canSendMail]==NO))
                {
                    choiceContentError = YES;
                    break;
                }
                
                if(urlParam==nil)
                {
                    urlParam = @"null";
                }
                
                string = @"mailto:?cc=";
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                break;
            }
            case PPURLControllerType_EmailBCC:
            {
                if((superViewController==nil && [self canOpenURLWithType:type]==NO)||
                   (superViewController!=nil && [PPMailComposeViewController canSendMail]==NO))
                {
                    choiceContentError = YES;
                    break;
                }
                if(urlParam==nil)
                {
                    urlParam = @"null";
                }
                
                string = @"mailto:?bcc=";
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                break;
            }
            case PPURLControllerType_Facebook:
            {
//                string = @"https://m.facebook.com/findfriends/search/?q=";
                // see mantis http://mantis.penpower.com.tw/view.php?id=35515
//                string = @"https://www.facebook.com/search/people/?epa=SEE_MORE&q=";
                string = @"https://m.facebook.com/search/top/?q=";
            
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
            case PPURLControllerType_Facebook_Profile:
            {
                // Profile example
                // 1. https://www.facebook.com/profile.php?id=100000724817500
                // 2. facebook.com/chuncheng.chiu1027
                // 3. www.facebook.com/chuncheng.chiu1027
                
                if([urlParam rangeOfString:@"//"].length==0)
                {
                    NSString *account = [urlParam lastPathComponent];
                    string = [NSString stringWithFormat:@"https://www.facebook.com/%@", [account stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                }
                else
                {
                    string = urlParam;
                }
                
                break;
            }
            case PPURLControllerType_FaceTime:
            {
                string = @"facetime://";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByReplacingOccurrencesOfString:@" " withString:@""]];
                
                break;
            }
            case PPURLControllerType_GoogleMap:
            {
                string = @"https://maps.google.com/maps?ie=utf8&q=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                // !! 使用核心提供的地址字串後，不需要呼叫googleMapStringFromAddress !!
                //    parameter = [UIApplication googleMapStringFromAddress:parameter];
                
                if(urlParam==nil)
                {
                    urlParam = @"";
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
            case PPURLControllerType_BaiduMap:
            {
                string = @"https://map.baidu.com/mobile/webapp/search/search/qt=s&wd=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                // !! 使用核心提供的地址字串後，不需要呼叫googleMapStringFromAddress !!
                //    parameter = [UIApplication googleMapStringFromAddress:parameter];
                if(urlParam==nil)
                {
                    urlParam = @"";
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
            case PPURLControllerType_LinkedIn:
            {
//                string = @"https://www.linkedin.com/pub/dir/?";
                string = @"https://www.linkedin.com/search/results/all?";
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
            case PPURLControllerType_LinkedIn_Profile:
            {
                if([urlParam rangeOfString:@"//"].length==0)
                {
                    NSString *account = [urlParam lastPathComponent];
                    string = [NSString stringWithFormat :@"https://www.linkedin.com/in/%@", [account stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                }
                else
                {
                    string = urlParam;
                }
                
                break;
            }
            case PPURLControllerType_NaviCon:
            {
                string = @"navicon://navicon.denso.co.jp/setPOI?ver=1.2&addr=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
            case PPURLControllerType_SMS:
            {
                //////////////////////////////////////////////////
                
                if((superViewController==nil && [self canOpenURLWithType:type]==NO)||
                   (superViewController!=nil && [PPMessageComposeViewController canSendText]==NO))
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                // !!部份語系號碼數小於3時無法撥號，但會回傳YES，再撥號就會當掉，所以要先濾掉。
                
                if([urlParam length]<3)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                //////////////////////////////////////////////////
                string = @"sms:";
                string = [string stringByAppendingString:[[self class] dialStringFromPhoneNumber:urlParam]];
                
                nonOpenURLString = [[self class] dialStringFromPhoneNumber:urlParam];
                
                break;
            }
            case PPURLControllerType_Tel:
            {
                string = @"tel:";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                // !!部份語系號碼數小於3時無法撥號，但會回傳YES，再撥號就會當掉，所以要先濾掉。
                
                if([urlParam length]<3)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[[self class] dialStringFromPhoneNumber:urlParam]];
                
                break;
            }
            case PPURLControllerType_Twitter:
            {
                string = @"https://mobile.twitter.com/search?q=";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
            case PPURLControllerType_Twitter_Profile:
            {
                if([urlParam rangeOfString:@"//"].length==0)
                {
                    NSString *account = [urlParam lastPathComponent];
                    string = [NSString stringWithFormat :@"https://twitter.com/%@", [account stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                }
                else
                {
                    string = urlParam;
                }
                
                break;
            }
            case PPURLControllerType_Web:
            {
                string = @"http://";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                if([urlParam rangeOfString:@"//"].length==0)
                {
                    string = [string stringByAppendingString:urlParam];
                }
                else
                {
                    string = urlParam;
                }
                
                break;
            }
            case PPURLControllerType_Skype:
            {
                if([application canOpenURL:[NSURL URLWithString:@"skype:"]]==YES)
                {
                    string = [NSString stringWithFormat:@"skype:%@?call",parameter];
                }
                
                break;
            }
            case PPURLControllerType_SinaWebo:
            {
                
                string = @"https://s.weibo.com/user/";
                
                //////////////////////////////////////////////////
                
                if([application canOpenURL:[NSURL URLWithString:string]]==NO)
                {
                    choiceContentError = YES;
                    break;
                }
                
                //////////////////////////////////////////////////
                
                string = [string stringByAppendingString:[urlParam stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                
                break;
            }
            case PPURLControllerType_SinaWebo_Profile:
            {
                if([urlParam rangeOfString:@"//"].length==0)
                {
                    NSString *account = [urlParam lastPathComponent];
                    string = [NSString stringWithFormat :@"https://www.weibo.com/%@", [account stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
                }
                else
                {
                    string = urlParam;
                }
                
                break;
            }
            case PPURLControllerType_None:
            default:
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(string!=nil && [string length]>0 && choiceContentError==NO)
        {
            if (superViewController==nil || type==PPURLControllerType_Skype || type==PPURLControllerType_Tel ||
                type==PPURLControllerType_NaviCon || type==PPURLControllerType_FaceTime)
            {
                if (@available(iOS 10.0, *))
                {
                    [[UIApplication sharedApplication] openURL:[NSURL URLWithString:string] options:@{} completionHandler:nil];
                    result = YES;
                }
                else
                {
                    result = [[UIApplication sharedApplication] openURL:[NSURL URLWithString:string]];
                }
            }
            else if ([nonOpenURLString length]>0 && type==PPURLControllerType_Email)
            {
                PPMailComposeViewController *mailViewController = [[PPMailComposeViewController alloc] init];
                if (mailViewController)
                {
                    [mailViewController setToRecipients:@[nonOpenURLString]];
                    [superViewController presentViewController:mailViewController animated:YES completion:^{}];
                    [mailViewController release];
                    
                    result = YES;
                }
            }
            else if ([nonOpenURLString length]>0 && type==PPURLControllerType_SMS)
            {
                PPMessageComposeViewController *smsViewController = [[PPMessageComposeViewController alloc] init];
                if (smsViewController)
                {
                    [smsViewController setRecipients:@[nonOpenURLString]];
                    [superViewController presentViewController:smsViewController animated:YES completion:^{}];
                    [smsViewController release];
                    result = YES;
                }
            }
            else
            {
                SFSafariViewController *safariViewController = [[SFSafariViewController alloc] initWithURL:[NSURL URLWithString:string] ];
                [superViewController presentViewController:safariViewController animated:YES completion:^{}];
                [safariViewController release];
                result = YES;
            }
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    return result;
}

@end
