//
//  PPURLController.m
//

#import "PPURLController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPURLController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//===============================================================================
//
//===============================================================================
+ (NSString *)dialStringFromPhoneNumber:(NSString *)phoneNumber
{
    //轉換分機號碼
    NSString *extSymbol = @",";
    phoneNumber = [phoneNumber stringByReplacingOccurrencesOfString:@"#" withString:extSymbol];
    phoneNumber = [phoneNumber stringByReplacingOccurrencesOfString:@"*" withString:extSymbol];

    //////////////////////////////////////////////////

    return [[phoneNumber componentsSeparatedByCharactersInSet:[NSCharacterSet whitespaceCharacterSet]] componentsJoinedByString:@""];
}


//===============================================================================
//
//===============================================================================
+ (NSString *)googleMapStringFromAddress:(NSString *)address
{
    NSString *googleMapString = @"";
    
    //////////////////////////////////////////////////
    
    do
    {
        if(address==nil || [address length]==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        //移除 newline
        
        googleMapString = [[address componentsSeparatedByCharactersInSet:[NSCharacterSet newlineCharacterSet]] componentsJoinedByString:@" "];
        
        //////////////////////////////////////////////////
        //檢查是否有 '巷' (從後面找)

        NSRange range = [googleMapString rangeOfCharacterFromSet:[NSCharacterSet characterSetWithCharactersInString:@"巷"] options:NSBackwardsSearch];
        if(range.length>0)
        {
            //移除 '巷' 後面的地址
            googleMapString = [googleMapString substringToIndex:range.location+1];
        }
        else
        {
            //檢查是否有 '號' (從後面找)
            range = [googleMapString rangeOfCharacterFromSet:[NSCharacterSet characterSetWithCharactersInString:@"號号"] options:NSBackwardsSearch];
            if(range.length>0)
            {
                // 移除 '號' 後面的地址
                googleMapString = [googleMapString substringToIndex:range.location+1];
            }
        }

        //////////////////////////////////////////////////
        // !!日本地址特殊處理(從後面開始找'-'，如果'-'的前後都是數字，就把'-'之後最後一個數字以外的字去掉，如西新宿6-8-13住友不動產 => 西新宿6-8-13。)
    
        range = [googleMapString rangeOfCharacterFromSet:[NSCharacterSet characterSetWithCharactersInString:@"-"] options:NSBackwardsSearch];
        if(range.length>0)
        {
            NSCharacterSet  *numberCharacterSet = [NSCharacterSet characterSetWithCharactersInString:@"0123456789"];
            unichar         prevCharacter       = [googleMapString characterAtIndex:range.location-1];
            unichar         nextCharacter       = [googleMapString characterAtIndex:range.location+1];
            unichar         zipCharacter        = [@"〒" characterAtIndex:0];
            
            // 需要進行處理的條件
            if([googleMapString length]>5                                           &&
               range.location>[googleMapString length]/2                            &&  // '-'的位置超過地址長度的一半
               [googleMapString characterAtIndex:range.location-4]!=zipCharacter    &&  // '-'往前第4個字元不是'〒'
               [googleMapString characterAtIndex:range.location-5]!=zipCharacter    &&  // '-'往前第5個字元不是'〒'
               [numberCharacterSet characterIsMember:prevCharacter]                 &&  // '-'前一個字元是數字
               [numberCharacterSet characterIsMember:nextCharacter]                 )   // '-'後一個字元是數字
            {
                NSUInteger lastCharacterIndex = range.location+1;
                
                for(lastCharacterIndex++; lastCharacterIndex<[googleMapString length]; lastCharacterIndex++)
                {
                    if([numberCharacterSet characterIsMember:[googleMapString characterAtIndex:lastCharacterIndex]]==NO)
                    {
                        break;
                    }
                }
                
                //把'-'之後最後一個數字以外的字去掉
                googleMapString = [googleMapString substringToIndex:lastCharacterIndex];
            }
        }
        
        //////////////////////////////////////////////////
        // 檢查最後是否是空格加逗號
        
        if([googleMapString hasSuffix:@" ,"]==YES)
        {
            googleMapString = [googleMapString substringToIndex:[googleMapString length]-1];
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    return googleMapString;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//===============================================================================
//
//===============================================================================
+ (NSString *)parameterForNaviConWithAddress:(NSString *)address appName:(NSString *)appName title:(NSString *)title text:(NSString *)text
{
    NSString *parameter = @"";
    
    //////////////////////////////////////////////////
    
    do
    {
        if(address==nil || [address length]==0)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        parameter = [[self class] googleMapStringFromAddress:address];
        if(parameter==nil)
        {
            parameter = @"";
        }
        
        //////////////////////////////////////////////////
        
        if(appName!=nil && [appName length]>0)
        {
            parameter = [parameter stringByAppendingFormat:@"&appName=%@", appName];
        }
        
        if(title!=nil && [title length]>0)
        {
            parameter = [parameter stringByAppendingFormat:@"&title=%@", title];
        }
        
        if(text!=nil && [text length]>0)
        {
            parameter = [parameter stringByAppendingFormat:@"&text=%@", text];
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    return parameter;
}


//===============================================================================
//
//===============================================================================
+ (NSString *)parameterForLinkedInWithFirstName:(NSString *)firstName lastName:(NSString *)lastName
{
    if(![firstName length] && ![lastName length])
    {
        return nil;
    }
    
    return [NSString stringWithFormat:@"firstName=%@&lastName=%@", (firstName==nil?@"":firstName), (lastName==nil?@"":lastName)];
}


//===============================================================================
//
//===============================================================================
+ (BOOL)canOpenURLWithType:(PPURLControllerType)type
{
#if TARGET_OS_IPHONE
    
    BOOL result = NO;
    
    //////////////////////////////////////////////////
    
    do
    {
        UIApplication *application = [UIApplication sharedApplication];
        NSString *string = nil;
        
        switch(type)
        {
            case PPURLControllerType_Email:
            {
                string = @"mailto:";
                break;
            }
            case PPURLControllerType_Facebook:
            {
                string = @"https://m.facebook.com/findfriends/search/?q=";
                break;
            }
            case PPURLControllerType_Facebook_Profile:
            {
                string = @"https://m.facebook.com/";
                break;
            }
            case PPURLControllerType_FaceTime:
            {
                string = @"facetime://";
                break;
            }
            case PPURLControllerType_GoogleMap:
            {
                string = @"https://maps.google.com/maps?ie=utf8&q=";
                break;
            }
            case PPURLControllerType_BaiduMap:
            {
                string = @"https://api.map.baidu.com/geocoder?output=html&address=";
                break;
            }
            case PPURLControllerType_LinkedIn:
            {
                string = @"https://www.linkedin.com/pub/dir/?";
                break;
            }
            case PPURLControllerType_NaviCon:
            {
                string = @"navicon://navicon.denso.co.jp/setPOI?ver=1.2&addr=";
                break;
            }
            case PPURLControllerType_SMS:
            {
                string = @"sms:";
                break;
            }
            case PPURLControllerType_Tel:
            {
                string = @"tel:";
                break;
            }
            case PPURLControllerType_Twitter:
            {
                string = @"https://mobile.twitter.com/search?q=";
                break;
            }
            case PPURLControllerType_Web:
            {
                string = @"https://";
                break;
            }
            case PPURLControllerType_Skype:
            {
                string = @"skype:";
                break;
            }
            case PPURLControllerType_SinaWebo:
            {
                string = @"https://s.weibo.com/user/";
                break;
            }
            case PPURLControllerType_None:
            default:
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(string!=nil && [string length]>0)
        {
            result = [application canOpenURL:[NSURL URLWithString:string]];
        }
        
    }while(0);
    
    //////////////////////////////////////////////////
    
    return result;

    
    
#elif TARGET_OS_MAC
    
    BOOL result = YES;
    
    switch (type)
    {
        case PPURLControllerType_NaviCon:
            result = NO;
            break;
            
        default:
            break;
    }
    
    return result;
    
#endif
}

@end
