//
//  PPTopButtonsActionSheet.m
//  WCMContactInfoViewController
//
//  Created by Andrew on 2015/6/8.
//  Copyright (c) 2015年 Andrew.Lai. All rights reserved.
//

#import "PPTopButtonsActionSheet.h"

#import "PPLogController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static CGFloat const PPTopButtonsActionSheet_MinimumWidthOfButton  = 105.0;
static CGFloat const PPTopButtonsActionSheet_ButtonListViewAlpha   = 1.0f;
static CGFloat const PPTopButtonsActionSheet_ContentClickViewAlpha = 0.5f;
static CGFloat const PPTopButtonsActionSheet_ButtonListViewAnimateDuration = 0.5f;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTopButtonsActionSheet Extension

@interface PPTopButtonsActionSheet () <PPButtonDelegate>
@property (nonatomic, assign) BOOL      isAnimate;

@property (nonatomic, retain) PPButton *contentClickView;
@property (nonatomic, retain) UIView   *buttonListView;
@property (nonatomic, retain) UIView   *presentView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTopButtonsActionSheet Implementation

@implementation PPTopButtonsActionSheet

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        _isAnimate = NO;
        _isTopStyle = YES;
        _buttonListViewAlpha  = PPTopButtonsActionSheet_ButtonListViewAlpha;
        _minimumWidthOfButton = PPTopButtonsActionSheet_MinimumWidthOfButton;
        
        //////////////////////////////////////////////////
        
        _contentClickView = [[PPButton alloc] initWithFrame:CGRectZero];
        if (self.contentClickView!=nil)
        {
            self.contentClickView.alpha           = PPTopButtonsActionSheet_ContentClickViewAlpha;
            self.contentClickView.backgroundColor = [UIColor blackColor];
            self.contentClickView.delegate        = self;
            self.contentClickView.tag             = INT_MAX;
            
            [self.contentClickView addControlEvents:UIControlEventTouchUpInside];
            [self addSubview:self.contentClickView];
        }
        
        //////////////////////////////////////////////////

        _buttonListView = [[UIView alloc] initWithFrame:CGRectZero];
        if (self.buttonListView!=nil)
        {
            [self addSubview:self.buttonListView];
        }

    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [self.buttonListView removeFromSuperview];
    for (PPCommentButton *listButton in self.capabilityButtonArray)
    {
        [listButton removeFromSuperview];
        listButton.delegate = nil;
    }
    self.buttonListView = nil;
    self.presentView    = nil;
    
    [self.contentClickView removeFromSuperview];
    self.contentClickView.delegate = nil;
    self.contentClickView = nil;
    
    self.capabilityButtonArray = nil;
    
    //////////////////////////////////////////////////

    [_buttonListViewBackgroundColor release];
    _buttonListViewBackgroundColor = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    // 重新Layout contentClickView
    
    self.contentClickView.frame = self.bounds;
    
    //////////////////////////////////////////////////
    // 重新Layout buttonListView
    
    CGRect listViewFrame       = self.bounds;
    listViewFrame.size.height  = listViewFrame.size.height/3;
    
    if (self.isTopStyle==NO)
    {
        listViewFrame.origin.y = self.bounds.size.height-listViewFrame.size.height;
    }
    
    self.buttonListView.frame  = listViewFrame;
    
    //////////////////////////////////////////////////
    // 初始化頁面的參數
    
    NSInteger maximumButtonCountPerRow = self.bounds.size.width/self.minimumWidthOfButton;
    NSInteger buttonCount    = [self.capabilityButtonArray count];
    NSInteger modButtonCount = buttonCount%maximumButtonCountPerRow;
    NSInteger numberOfRow    = buttonCount/maximumButtonCountPerRow;
    
    CGSize buttonSize = CGSizeMake(self.bounds.size.width/maximumButtonCountPerRow, self.bounds.size.width/maximumButtonCountPerRow);
    
    if (modButtonCount!=0)
    {
        numberOfRow = numberOfRow + 1;
    }
    
    listViewFrame             = self.bounds;
    listViewFrame.size.height = numberOfRow*buttonSize.height;
    
    if (self.isTopStyle==NO)
    {
        listViewFrame.origin.y = self.bounds.size.height-listViewFrame.size.height;
    }
    
    self.buttonListView.frame = listViewFrame;
    
    //////////////////////////////////////////////////
    
    for (NSInteger rowIndex=0; rowIndex<numberOfRow; rowIndex++)
    {
        if (modButtonCount!=0 && rowIndex==numberOfRow-1)
        {
            for (NSInteger columnIndex=0; columnIndex<modButtonCount; columnIndex++)
            {
                PPCommentButton *listButton = [self.capabilityButtonArray objectAtIndex:maximumButtonCountPerRow*rowIndex+columnIndex];
                
                if (self.isTopStyle==YES)
                {
                    listButton.frame  = CGRectMake(columnIndex*buttonSize.width, rowIndex*buttonSize.height, buttonSize.width, buttonSize.height);
                }
                else
                {
                    listButton.frame = CGRectMake(columnIndex*buttonSize.width, (numberOfRow-rowIndex-1)*buttonSize.height, buttonSize.width, buttonSize.height);
                }
                
                listButton.delegate = self;
                [self.buttonListView addSubview:listButton];
            }
        }
        else
        {
            for (NSInteger columnIndex=0; columnIndex<maximumButtonCountPerRow; columnIndex++)
            {
                PPCommentButton *listButton = [self.capabilityButtonArray objectAtIndex:maximumButtonCountPerRow*rowIndex+columnIndex];
                
                if (self.isTopStyle==YES)
                {
                    listButton.frame  = CGRectMake(columnIndex*buttonSize.width, rowIndex*buttonSize.height, buttonSize.width, buttonSize.height);
                }
                else
                {
                    listButton.frame = CGRectMake(columnIndex*buttonSize.width, (numberOfRow-rowIndex-1)*buttonSize.height, buttonSize.width, buttonSize.height);
                }
                
                listButton.delegate = self;
                [self.buttonListView addSubview:listButton];
            }
        }
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setButtonListViewBackgroundColor:(UIColor *)buttonListViewBackgroundColor
{
    [buttonListViewBackgroundColor retain];
    
    [_buttonListViewBackgroundColor release];
    
    _buttonListViewBackgroundColor = buttonListViewBackgroundColor;
    
    //////////////////////////////////////////////////

    if(self.buttonListView!=nil)
    {
        self.buttonListView.backgroundColor = self.buttonListViewBackgroundColor;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showFromSuperView:(UIView *)superView animated:(BOOL)animated
{
    self.presentView = superView;
    self.isAnimate   = animated;
    
    //////////////////////////////////////////////////
    
    [self removeFromSuperview];
    [superView addSubview:self];

    self.buttonListView.alpha   = self.buttonListViewAlpha;
    self.contentClickView.alpha = PPTopButtonsActionSheet_ContentClickViewAlpha;
    
    //////////////////////////////////////////////////
    
    [self setNeedsLayout];
    
    //////////////////////////////////////////////////
    // 判斷是否進行動畫
    
    if (animated)
    {
        if (self.isTopStyle==YES)
        {
            self.buttonListView.frame = CGRectMake(self.buttonListView.frame.origin.x, self.buttonListView.frame.origin.y-self.buttonListView.frame.size.height, self.buttonListView.frame.size.width, self.buttonListView.frame.size.height);
        }
        else
        {
            self.buttonListView.frame = CGRectMake(self.buttonListView.frame.origin.x, self.buttonListView.frame.origin.y+self.buttonListView.frame.size.height, self.buttonListView.frame.size.width, self.buttonListView.frame.size.height);
        }
        
        self.buttonListView.alpha   = 0.0f;
        self.contentClickView.alpha = 0.0f;
        
        __block PPTopButtonsActionSheet *blockSelf = self;
        
        [UIView animateWithDuration:PPTopButtonsActionSheet_ButtonListViewAnimateDuration
                              delay:0.0f
                            options:UIViewAnimationOptionCurveEaseInOut
                         animations:^{
                             if (blockSelf.isTopStyle==YES)
                             {
                                 blockSelf.buttonListView.frame = CGRectMake(blockSelf.buttonListView.frame.origin.x, blockSelf.buttonListView.frame.origin.y+blockSelf.buttonListView.frame.size.height, blockSelf.buttonListView.frame.size.width, blockSelf.buttonListView.frame.size.height);
                             }
                             else
                             {
                                 blockSelf.buttonListView.frame = CGRectMake(blockSelf.buttonListView.frame.origin.x, blockSelf.buttonListView.frame.origin.y-blockSelf.buttonListView.frame.size.height, blockSelf.buttonListView.frame.size.width, blockSelf.buttonListView.frame.size.height);
                             }
                             
                             blockSelf.buttonListView.alpha = self.buttonListViewAlpha;
                             blockSelf.contentClickView.alpha = PPTopButtonsActionSheet_ContentClickViewAlpha;
                         }
                         completion:^(BOOL finish){
                             
                         }];
    }
}


//================================================================================
// 此函式主要用途為切頁面時，直接消失，若在當前頁面，會進行內部監控
//================================================================================
- (void)hideWithAnimated:(BOOL)animated
{
    if (animated)
    {
        __block PPTopButtonsActionSheet *blockSelf = self;
        
        [UIView animateWithDuration:PPTopButtonsActionSheet_ButtonListViewAnimateDuration
                              delay:0.0f
                            options:UIViewAnimationOptionCurveEaseInOut
                         animations:^{
                             if (blockSelf.isTopStyle==YES)
                             {
                                 blockSelf.buttonListView.frame = CGRectMake(blockSelf.buttonListView.frame.origin.x, blockSelf.buttonListView.frame.origin.y-blockSelf.buttonListView.frame.size.height, blockSelf.buttonListView.frame.size.width, blockSelf.buttonListView.frame.size.height);
                             }
                             else
                             {
                                 blockSelf.buttonListView.frame = CGRectMake(blockSelf.buttonListView.frame.origin.x, blockSelf.buttonListView.frame.origin.y+blockSelf.buttonListView.frame.size.height, blockSelf.buttonListView.frame.size.width, blockSelf.buttonListView.frame.size.height);
                             }
                             
                             blockSelf.buttonListView.alpha   = 0.0f;
                             blockSelf.contentClickView.alpha = 0.0f;
                         }
                         completion:^(BOOL finished) {
                             if (finished)
                             {
                                 [blockSelf removeFromSuperview];
                                 
                                 //!! 點選任意地方關閉事件通知
                                 if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppTopButtonsActionSheetDidDismiss:)]==YES)
                                 {
                                     [blockSelf.delegate ppTopButtonsActionSheetDidDismiss:self];
                                 }
                             }
                         }];

    }
    else
    {
        if (self.isTopStyle==YES)
        {
            self.buttonListView.frame = CGRectMake(self.buttonListView.frame.origin.x, self.buttonListView.frame.origin.y-self.buttonListView.frame.size.height, self.buttonListView.frame.size.width, self.buttonListView.frame.size.height);
        }
        else
        {
            self.buttonListView.frame = CGRectMake(self.buttonListView.frame.origin.x, self.buttonListView.frame.origin.y+self.buttonListView.frame.size.height, self.buttonListView.frame.size.width, self.buttonListView.frame.size.height);
        }
        
        self.buttonListView.alpha   = 0.0f;
        self.contentClickView.alpha = 0.0f;
        
        //////////////////////////////////////////////////
        
        [self removeFromSuperview];
        
        //////////////////////////////////////////////////
        
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTopButtonsActionSheetDidDismiss:)]==YES)
        {
            [self.delegate ppTopButtonsActionSheetDidDismiss:self];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)reLayoutSubViews
{
    self.frame = self.presentView.bounds;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if (self.isAnimate)
    {
        __block PPTopButtonsActionSheet *blockSelf = self;
        
        [UIView animateWithDuration:PPTopButtonsActionSheet_ButtonListViewAnimateDuration
                              delay:0.0f
                            options:UIViewAnimationOptionCurveEaseInOut
                         animations:^{
                             if (blockSelf.isTopStyle==YES)
                             {
                                 blockSelf.buttonListView.frame = CGRectMake(blockSelf.buttonListView.frame.origin.x, blockSelf.buttonListView.frame.origin.y-blockSelf.buttonListView.frame.size.height, blockSelf.buttonListView.frame.size.width, blockSelf.buttonListView.frame.size.height);
                             }
                             else
                             {
                                 blockSelf.buttonListView.frame = CGRectMake(blockSelf.buttonListView.frame.origin.x, blockSelf.buttonListView.frame.origin.y+blockSelf.buttonListView.frame.size.height, blockSelf.buttonListView.frame.size.width, blockSelf.buttonListView.frame.size.height);
                             }
                             
                             blockSelf.buttonListView.alpha   = 0.0f;
                             blockSelf.contentClickView.alpha = 0.0f;
                         }
                         completion:^(BOOL finished) {
                             if (finished)
                             {
                                 [blockSelf removeFromSuperview];
                                 
                                 if (ppButton.tag==INT_MAX)
                                 {
                                     //!! 點選任意地方關閉事件通知
                                     if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppTopButtonsActionSheetDidDismiss:)]==YES)
                                     {
                                         [blockSelf.delegate ppTopButtonsActionSheetDidDismiss:self];
                                     }
                                 }
                                 else
                                 {
                                     //!! 因為button的tag記錄的是該按鈕
                                     if (blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppTopButtonsActionSheet:capabilityButtonSelectedTag:)]==YES)
                                     {
                                         [blockSelf.delegate ppTopButtonsActionSheet:blockSelf capabilityButtonSelectedTag:ppButton.tag];
                                     }
                                 }
                             }
                         }];
    }
    else
    {
        if (self.isTopStyle==YES)
        {
            self.buttonListView.frame = CGRectMake(self.buttonListView.frame.origin.x, self.buttonListView.frame.origin.y-self.buttonListView.frame.size.height, self.buttonListView.frame.size.width, self.buttonListView.frame.size.height);
        }
        else
        {
            self.buttonListView.frame = CGRectMake(self.buttonListView.frame.origin.x, self.buttonListView.frame.origin.y+self.buttonListView.frame.size.height, self.buttonListView.frame.size.width, self.buttonListView.frame.size.height);
        }
        
        self.buttonListView.alpha   = 0.0f;
        self.contentClickView.alpha = 0.0f;
        
        //////////////////////////////////////////////////
        
        [self removeFromSuperview];
        
        //////////////////////////////////////////////////
        
        if (ppButton.tag==INT_MAX)
        {
            //!! 點選任意地方關閉事件通知
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTopButtonsActionSheetDidDismiss:)]==YES)
            {
                [self.delegate ppTopButtonsActionSheetDidDismiss:self];
            }
        }
        else
        {
            //!! 因為button的tag記錄的是該按鈕
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTopButtonsActionSheet:capabilityButtonSelectedTag:)]==YES)
            {
                [self.delegate ppTopButtonsActionSheet:self capabilityButtonSelectedTag:ppButton.tag];
            }
        }
    }
}

@end
