//
//  PPCommentButton.m
//  Pods
//
//  Created by Duke on 2015/6/30.
//
//

#import "PPCommentButton.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPCommentButton_ImageViewRect CGRectMake(0, 0, 44, 44)

static NSUInteger const PPCommentButton_CommentFontSize = 12;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCommentButton Extension

@interface PPCommentButton ()
@property (nonatomic, retain) UIImageView *buttonImageView;
@property (nonatomic, retain) UILabel     *buttonComment;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma PPCommentButton Implementation

@implementation PPCommentButton

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Objects

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame buttonImageName:(NSString *)imageName buttonComment:(NSString *)commentString
{
    if(self=[super initWithFrame:frame])
    {
        [self addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////
        
        _buttonImageView = [[UIImageView alloc] initWithFrame:PPCommentButton_ImageViewRect];
        if(self.buttonImageView!=nil)
        {
            self.buttonImageView.image = [UIImage imageWithName:imageName forState:UIControlStateNormal];
            self.buttonImageView.highlightedImage = [UIImage imageWithName:imageName forState:UIControlStateHighlighted];
            
            [self addSubview:self.buttonImageView];
        }
        
        //////////////////////////////////////////////////
        
        _buttonComment = [[UILabel alloc] init];
        if (self.buttonComment!=nil)
        {
            self.buttonComment.text = commentString;
            self.buttonComment.textColor = [UIColor blackColor];
            self.buttonComment.highlightedTextColor = [UIColor whiteColor];
            
            self.buttonComment.numberOfLines = 2;
            self.buttonComment.textAlignment = NSTextAlignmentCenter;
            self.buttonComment.font = [UIFont systemFontOfSize:PPCommentButton_CommentFontSize];
            
            [self addSubview:self. buttonComment];
        }
        
        //////////////////////////////////////////////////
        
        //	button events
        [self addTarget:self action:@selector(OnButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        [self addTarget:self action:@selector(OnButtonTouchDown:) forControlEvents:UIControlEventTouchDown];
        [self addTarget:self action:@selector(OnButtonTouchDragEnter:) forControlEvents:UIControlEventTouchDragEnter];
        [self addTarget:self action:@selector(OnButtonTouchDragExit:) forControlEvents:UIControlEventTouchDragExit];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_buttonImageView removeFromSuperview];
    [_buttonImageView release];
    _buttonImageView = nil;
    
    [_buttonComment removeFromSuperview];
    [_buttonComment release];
    _buttonComment = nil;
    
    [_commentTextColorNormal release];
    _commentTextColorNormal = nil;
    
    [_commentTextColorHighlighted release];
    _commentTextColorHighlighted = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}


//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect region = self.bounds;
    self.buttonImageView.center = CGPointMake(region.size.width/2, region.size.height/2);
    
    CGRect buttonFrame = self.buttonImageView.frame;
    self.buttonComment.frame = CGRectMake(0, buttonFrame.origin.y+buttonFrame.size.height, region.size.width, region.size.height-buttonFrame.origin.y-buttonFrame.size.height);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overrid Method

//================================================================================
//
//================================================================================
- (void)setCommentTextColorNormal:(UIColor *)commentTextColorNormal
{
    [_commentTextColorNormal release];
    _commentTextColorNormal = [commentTextColorNormal retain];
    
    //////////////////////////////////////////////////
    
    self.buttonComment.textColor = commentTextColorNormal;
}


//================================================================================
//
//================================================================================
- (void)setCommentTextColorHighlighted:(UIColor *)commentTextColorHighlighted
{
    [_commentTextColorHighlighted release];
    _commentTextColorHighlighted = [commentTextColorHighlighted retain];
    
    //////////////////////////////////////////////////
    
    self.buttonComment.highlightedTextColor = commentTextColorHighlighted;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Button Event

//================================================================================
//
//================================================================================
- (void)OnButtonClick:(id)sender
{
    self.buttonComment.highlighted = NO;
    self.buttonImageView.highlighted = NO;
}


//================================================================================
//
//================================================================================
- (void)OnButtonTouchDown:(id)sender
{
    self.buttonComment.highlighted = YES;
    self.buttonImageView.highlighted = YES;
}


//================================================================================
//
//================================================================================
- (void)OnButtonTouchDragEnter:(id)sender
{
    self.buttonComment.highlighted = YES;
    self.buttonImageView.highlighted = YES;
}


//================================================================================
// 
//================================================================================
- (void)OnButtonTouchDragExit:(id)sender
{
    self.buttonComment.highlighted = NO;
    self.buttonImageView.highlighted = NO;
}

@end
