//
//  PPToastController.h
//  WorldCam
//
//  Created by AndrewLai on 2018/10/04.
//  Copyright © 2018年 AndrewLai. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPAppearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSUInteger, PPToastPosition)
{
    PPToastPositionTop = 0,
    PPToastPositionCenter,
    PPToastPositionBottom
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPToastController Interface

@interface PPToastController : NSObject <PPAppearance>

/// 字體大小，預設16
@property (nonatomic, assign) CGFloat textFontSize PP_APPEARANCE_SELECTOR;
/// 訊息文字顏色，預設白色
@property (nonatomic, retain) UIColor *textColor PP_APPEARANCE_SELECTOR;
/// 訊息背景色，預設lightGrayColor with alpha 0.5
@property (nonatomic, retain) UIColor *backgroundColor PP_APPEARANCE_SELECTOR;
/// 訊息靠齊，預設置中
@property (nonatomic, assign) NSTextAlignment textAlignment PP_APPEARANCE_SELECTOR;
/// 訊息顯示時間，預設0，表示依長度計算
@property (nonatomic, assign) NSTimeInterval duration PP_APPEARANCE_SELECTOR;


//////////////////////////////////////////////////
/**
 * 使用客制化的view顯示
 * @param superView superView
 * @param customView 要顯示的view 
 * @param duration 訊息顯示時間
 * @param position toast顯示的位置
 */

+ (void)showToastFromSuperView:(UIView *)superView
                withCustomView:(UIView *)customView
                      duration:(NSTimeInterval)duration
                      position:(PPToastPosition)position;


/**
 * 使用自訂的style顯示toast訊息
 * @param superView superView
 * @param message 要顯示的訊息
 * @param fontSize 字體大小
 * @param textColor 訊息文字顏色
 * @param backgroundColor 訊息背景色
 * @param textAlignment 訊息靠齊
 * @param duration 訊息顯示時間
 * @param position toast顯示的位置
 */
+ (void)showMessageToastFromSuperView:(UIView *)superView
                          withMessage:(NSString*)message
                             fontSize:(CGFloat)fontSize
                            textColor:(UIColor *)textColor
                      backgroundColor:(UIColor *)backgroundColor
                        textAlignment:(NSTextAlignment)textAlignment
                             duration:(NSTimeInterval)duration
                             position:(PPToastPosition)position;


/**
 * 使用預設的style顯示toast訊息
 * @param superView superView
 * @param message 要顯示的訊息
 * @param position toast顯示的位置
 */
+ (void)showMessageToastFromSuperView:(UIView *)superView
                          withMessage:(NSString*)message
                             position:(PPToastPosition)position;
+ (void)hideMessageToast;

@end
