//
//  PPTextViewTableViewCell.m
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTextViewTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPTextViewTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
delegate    = delegate_,
ppTextView  = ppTextView_,
maxLength   = maxLength_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;

        //////////////////////////////////////////////////
        
        //預設輸入上限最高
        maxLength_ = NSUIntegerMax;
        
        //////////////////////////////////////////////////
        
        ppTextView_ = [[PPTextView alloc] init];
        if(self.ppTextView!=nil) 
        {
            self.ppTextView.autocapitalizationType      = UITextAutocapitalizationTypeWords;
            self.ppTextView.autocorrectionType          = UITextAutocorrectionTypeNo;
            self.ppTextView.backgroundColor             = [UIColor clearColor];
            self.ppTextView.delegate                    = self;
            self.ppTextView.returnKeyType               = UIReturnKeyDefault;
            
            [self.contentView addSubview:self.ppTextView];
        }
        
        //////////////////////////////////////////////////
        
        [self layoutSubviews];
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{	
    [ppTextView_ removeFromSuperview];
    [ppTextView_ release];
	ppTextView_ = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.ppTextView!=nil)
    {
        CGRect textViewFrame = self.contentView.bounds;
        
        switch(self.style)
        {
            case UITableViewCellStyleValue1:
            case UITableViewCellStyleValue2:
            {
                CGRect textLabelFrame = self.contentView.bounds;
                textViewFrame.origin.x     = self.contentInsets.left;
                textViewFrame.origin.y     = self.contentInsets.top;
                textLabelFrame.size.width   = (self.contentView.bounds.size.width-(PPTableViewCellDefaultHorizontalGap+self.contentInsets.left+self.contentInsets.right))/2;
                textViewFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                self.textLabel.frame = textLabelFrame;
                
                textViewFrame.origin.x     = textLabelFrame.origin.x+textLabelFrame.size.width+PPTableViewCellDefaultHorizontalGap;
                textViewFrame.origin.y     = textLabelFrame.origin.y;
                textViewFrame.size.width   = textLabelFrame.size.width;
                textViewFrame.size.height  = textLabelFrame.size.height;
                
                break;
            }
            case UITableViewCellStyleSubtitle:
            {
                CGRect textLabelFrame = self.contentView.bounds;
                textViewFrame.origin.x     = self.contentInsets.left;
                textViewFrame.origin.y     = self.contentInsets.top;
                textViewFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                textLabelFrame.size.height  = (self.contentView.bounds.size.height-(PPTableViewCellDefaultVerticalGap+self.contentInsets.top+self.contentInsets.bottom))/2;
                self.textLabel.frame = textLabelFrame;
                
                textViewFrame.origin.x     = textLabelFrame.origin.x;
                textViewFrame.origin.y     = textLabelFrame.origin.y+textLabelFrame.size.height+PPTableViewCellDefaultVerticalGap;
                textViewFrame.size.width   = textLabelFrame.size.width;
                textViewFrame.size.height  = textLabelFrame.size.height;
                
                break;
            }
            case UITableViewCellStyleDefault:
            default:
            {
                textViewFrame.origin.x     = self.contentInsets.left;
                textViewFrame.origin.y     = self.contentInsets.top;
                textViewFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                textViewFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                
                break;
            }
        }
        
        self.ppTextView.frame = textViewFrame;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method

//================================================================================
//
//================================================================================
- (void)textViewDidBeginEditing
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextViewTableViewCellDidBeginEditing:)]==YES)
    {
        [self.delegate ppTextViewTableViewCellDidBeginEditing:self];
    }
}

//================================================================================
//
//================================================================================
- (void)textViewDidChange
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextViewTableViewCellDidChange:)]==YES)
    {
        [self.delegate ppTextViewTableViewCellDidChange:self];
    }
}

//================================================================================
//
//================================================================================
- (void)textViewDidChangeSelection
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextViewTableViewCellDidChangeSelection:)]==YES)
    {
        [self.delegate ppTextViewTableViewCellDidChangeSelection:self];
    }
}

//================================================================================
//
//================================================================================
- (void)textViewDidEndEditing;
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextViewTableViewCellDidEndEditing:)]==YES)
    {
        [self.delegate ppTextViewTableViewCellDidEndEditing:self];
    }
}

//================================================================================
//
//================================================================================
- (BOOL)textViewShouldBeginEditing
{
    BOOL shouldBeginEditing = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextViewTableViewCellShouldBeginEditing:)]==YES)
    {
        shouldBeginEditing = [self.delegate ppTextViewTableViewCellShouldBeginEditing:self];
    }
    
    return shouldBeginEditing;
}

//================================================================================
//
//================================================================================
- (BOOL)textViewShouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL shouldChange = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextViewTableViewCell:shouldChangeCharactersInRange:replacementString:)]==YES)
    {
        shouldChange = [self.delegate ppTextViewTableViewCell:self shouldChangeCharactersInRange:range replacementString:string];
    }
    else if(self.ppTextView.text.length+string.length>self.maxLength)
    {
        // 新增文字，或取代文字
        if(range.length<=string.length &&
           [string length]>0)
        {
            shouldChange = NO;
        }
    }
    
    return shouldChange;
}

//================================================================================
//
//================================================================================
- (BOOL)textViewShouldEndEditing
{
    BOOL shouldEndEditing = YES;
    
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppTextViewTableViewCellShouldEndEditing:)]==YES)
    {
        shouldEndEditing = [self.delegate ppTextViewTableViewCellShouldEndEditing:self];
    }
    
    return shouldEndEditing;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITextViewDelegate

//================================================================================
//
//================================================================================
- (BOOL)textViewShouldBeginEditing:(UITextView *)textView
{
    return [self textViewShouldBeginEditing];
}

//================================================================================
//
//================================================================================
- (BOOL)textViewShouldEndEditing:(UITextView *)textView
{
    return [self textViewShouldEndEditing];
}

//================================================================================
//
//================================================================================
- (void)textViewDidBeginEditing:(UITextView *)textView
{
    return [self textViewDidBeginEditing];
}

//================================================================================
//
//================================================================================
- (void)textViewDidEndEditing:(UITextView *)textView
{
    return [self textViewDidEndEditing];
}

//================================================================================
//
//================================================================================
- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)text
{
    return [self textViewShouldChangeCharactersInRange:range replacementString:text];
}

//================================================================================
//
//================================================================================
- (void)textViewDidChange:(UITextView *)textView
{
    if(self.ppTextView==textView && textView.text.length<=self.maxLength)
    {
        [self textViewDidChange];
    }
}

//================================================================================
//
//================================================================================
- (void)textViewDidChangeSelection:(UITextView *)textView
{
    [self textViewDidChangeSelection];
}







////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - subclass


//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    self.ppTextView.userInteractionEnabled = enable;
    self.ppTextView.editable = enable;
}
@end
