//
//  PPTableViewCellLineView.m
//
//  Created by Howard.Lin on 13/10/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewCellLineView.h"

@interface PPTableViewCellLineView ()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPTableViewCellLineView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object


//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
         // Initialization code
        self.backgroundColor        = [UIColor clearColor];
        self.userInteractionEnabled = NO;

        //////////////////////////////////////////////////

        _drawHorizontalLine = NO;
        _leftMargin         = PPTableViewCellLineView_LeftMargin;
        _bottomMargin       = PPTableViewCellLineView_BottomMargin;
        _drawVerticalLine   = YES;
        
        //////////////////////////////////////////////////

        _lineColor          = [[UIColor colorWithRed:PPTableViewCellLineView_LineRGBColor_Red
                                              green:PPTableViewCellLineView_LineRGBColor_Green
                                               blue:PPTableViewCellLineView_LineRGBColor_Blue
                                              alpha:PPTableViewCellLineView_LineRGBColor_Alpha] retain];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_lineColor release];
    _lineColor = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Drawing and Updating the View

//================================================================================
//
//================================================================================
- (void)drawRect:(CGRect)rect 
{
    [super drawRect:rect];
    
    //////////////////////////////////////////////////
    
    CGContextRef ctx = UIGraphicsGetCurrentContext();
    
    CGContextSetShouldAntialias(ctx,NO);
    CGContextSaveGState(ctx);
    
    //////////////////////////////////////////////////
    
    CGFloat red  = 0;
    CGFloat green = 0;
    CGFloat blue  = 0;
    CGFloat alpha = 0;
    
    [self.lineColor getRed:&red green:&green blue:&blue alpha:&alpha];
    
    //////////////////////////////////////////////////
    
    CGContextSetRGBStrokeColor(ctx, red, green, blue, alpha);
    
    CGContextSetLineWidth(ctx, PPTableViewCellLineView_LineWidth);
    
    //!畫直線
    if(self.drawVerticalLine==YES)
    {
        CGContextMoveToPoint(ctx, self.leftMargin, 0);
        CGContextAddLineToPoint(ctx, self.leftMargin, self.bounds.size.height);
    }
    
    if(self.drawHorizontalLine==YES)
    {
        //!畫橫線
        CGFloat bottomMargin = self.bottomMargin;
        while (bottomMargin<self.bounds.size.height)
        {
            CGContextMoveToPoint(ctx, self.leftMargin, bottomMargin);
            CGContextAddLineToPoint(ctx, self.bounds.size.width, bottomMargin);
            
            bottomMargin += self.bottomMargin;
        }
    }
    
    CGContextStrokePath(ctx);
}

@end
