//
//  PPTableViewCell.m
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
backgroundImageView = backgroundImageView_,
style               = style_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        style_ = style;
        _contentInsets = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (id)initCustomStyleWithReuseIdentifier:(NSString *)reuseIdentifier;
{
	if((self = [self initWithStyle:UITableViewCellStyleDefault reuseIdentifier:reuseIdentifier]))
	{
        _contentInsets = UIEdgeInsetsMake(PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap, PPTableViewCellDefaultVerticalGap, PPTableViewCellDefaultHorizontalGap);

        //////////////////////////////////////////////////
		backgroundImageView_ = [[UIImageView alloc] init];
        if(self.backgroundImageView!=nil) 
        {
            self.backgroundImageView.backgroundColor = [UIColor clearColor];
            [self insertSubview:self.backgroundImageView atIndex:0];
        }
        
        //////////////////////////////////////////////////
        
        [self layoutSubviews];
	}
	
	return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{	
	if(backgroundImageView_!=nil)
    {
        [backgroundImageView_ removeFromSuperview];
        [backgroundImageView_ release];
        backgroundImageView_ = nil;
	}
    
    //////////////////////////////////////////////////

	[super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - override property


//==============================================================================
//
//==============================================================================
- (void)setContentInsets:(UIEdgeInsets)contentInsets
{
    _contentInsets = contentInsets;
    [super setNeedsLayout];
}


//================================================================================
//
//================================================================================
- (void)setIgnoreCustomLabelFrame:(BOOL)ignoreCustomLabelFrame
{
    _ignoreCustomLabelFrame = ignoreCustomLabelFrame;
}

//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    self.userInteractionEnabled = enable;
    self.textLabel.enabled = enable;
    self.detailTextLabel.enabled = enable;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];

    //////////////////////////////////////////////////
    
    if(self.ignoreCustomLabelFrame==YES)
    {
        
    }
    else
    {
        CGRect textLabelFrame = self.contentView.bounds;
        
        switch(self.style)
        {
            case UITableViewCellStyleValue1:
            case UITableViewCellStyleValue2:
            {
                textLabelFrame.origin.x     = self.contentInsets.left;
                textLabelFrame.origin.y     = self.contentInsets.top;
                textLabelFrame.size.width   = (self.contentView.bounds.size.width-(PPTableViewCellDefaultHorizontalGap+self.contentInsets.left+self.contentInsets.right))/2;
                textLabelFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                
                CGRect detailTextLabelFrame;
                detailTextLabelFrame.origin.x     = textLabelFrame.origin.x+textLabelFrame.size.width+PPTableViewCellDefaultHorizontalGap;
                detailTextLabelFrame.origin.y     = textLabelFrame.origin.y;
                detailTextLabelFrame.size.width   = textLabelFrame.size.width;
                detailTextLabelFrame.size.height  = textLabelFrame.size.height;
                self.detailTextLabel.frame = detailTextLabelFrame;
                
                break;
            }
            case UITableViewCellStyleSubtitle:
            {
                textLabelFrame.origin.x     = self.contentInsets.left;
                textLabelFrame.origin.y     = self.contentInsets.top;
                textLabelFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                textLabelFrame.size.height  = (self.contentView.bounds.size.height-(PPTableViewCellDefaultVerticalGap+self.contentInsets.top+self.contentInsets.bottom))/2;
                
                CGRect detailTextLabelFrame;
                detailTextLabelFrame.origin.x     = textLabelFrame.origin.x;
                detailTextLabelFrame.origin.y     = textLabelFrame.origin.y+textLabelFrame.size.height+PPTableViewCellDefaultVerticalGap;
                detailTextLabelFrame.size.width   = textLabelFrame.size.width;
                detailTextLabelFrame.size.height  = textLabelFrame.size.height;
                self.detailTextLabel.frame = detailTextLabelFrame;
                
                break;
            }
            case UITableViewCellStyleDefault:
            default:
            {
                textLabelFrame.origin.x     = self.contentInsets.left;
                textLabelFrame.origin.y     = self.contentInsets.top;
                textLabelFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                textLabelFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                
                break;
            }
        }
        
        self.textLabel.frame = textLabelFrame;
    }
    
    //////////////////////////////////////////////////

    if(self.backgroundImageView!=nil)
    {
        //要將contentView背景整個佔滿
        self.backgroundImageView.frame = self.bounds;
    }
}

@end
