//
//  PPSliderTableViewCell.m
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPSliderTableViewCell.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPSliderTableViewCell()

@interface PPSliderTableViewCell ()
- (void)sliderControlValueChanged:(id)sender;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSliderTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
delegate        = delegate_,
sliderControl   = sliderControl_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
        
        sliderControl_ = [[UISlider alloc] init];
        if(self.sliderControl!=nil) 
        {
            [self.sliderControl addTarget:self
                                   action:@selector(sliderControlValueChanged:)
                         forControlEvents:UIControlEventValueChanged];
            
            [self.contentView addSubview:self.sliderControl];
        }
        
        //////////////////////////////////////////////////
        
        [self layoutSubviews];
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{	
    [sliderControl_ removeFromSuperview];
    [sliderControl_ release];
	sliderControl_ = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    if(self.sliderControl!=nil)
    {
        CGRect sliderControlFrame = self.contentView.bounds;
        
        switch(self.style)
        {
            case UITableViewCellStyleValue1:
            case UITableViewCellStyleValue2:
            {
                CGRect textLabelFrame = self.contentView.bounds;
                textLabelFrame.origin.x     = self.contentInsets.left;
                textLabelFrame.origin.y     = self.contentInsets.top;
                textLabelFrame.size.width   = (self.contentView.bounds.size.width-(PPTableViewCellDefaultHorizontalGap+self.contentInsets.left+self.contentInsets.right))/2;
                textLabelFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                self.textLabel.frame = textLabelFrame;
                
                sliderControlFrame.origin.x     = textLabelFrame.origin.x+textLabelFrame.size.width+PPTableViewCellDefaultHorizontalGap;
                sliderControlFrame.origin.y     = textLabelFrame.origin.y;
                sliderControlFrame.size.width   = textLabelFrame.size.width;
                sliderControlFrame.size.height  = textLabelFrame.size.height;
                
                break;
            }
            case UITableViewCellStyleSubtitle:
            {
                CGRect textLabelFrame = self.contentView.bounds;
                textLabelFrame.origin.x     = self.contentInsets.left;
                textLabelFrame.origin.y     = self.contentInsets.top;
                textLabelFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                textLabelFrame.size.height  = (self.contentView.bounds.size.height-(PPTableViewCellDefaultVerticalGap+self.contentInsets.top+self.contentInsets.bottom))/2;
                self.textLabel.frame = textLabelFrame;
                
                sliderControlFrame.origin.x     = textLabelFrame.origin.x;
                sliderControlFrame.origin.y     = textLabelFrame.origin.y+textLabelFrame.size.height+PPTableViewCellDefaultVerticalGap;
                sliderControlFrame.size.width   = textLabelFrame.size.width;
                sliderControlFrame.size.height  = textLabelFrame.size.height;
                
                break;
            }
            case UITableViewCellStyleDefault:
            default:
            {
                sliderControlFrame.origin.x     = self.contentInsets.left;
                sliderControlFrame.origin.y     = self.contentInsets.top;
                sliderControlFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                sliderControlFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);

                break;
            }
        }
        
        self.sliderControl.frame = sliderControlFrame;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
//
//================================================================================
- (void)sliderControlValueChanged:(id)sender
{
    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppSliderTableViewCellValueChanged:)]==YES)
    {
        [self.delegate ppSliderTableViewCellValueChanged:self];
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - subclass


//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];

    self.sliderControl.userInteractionEnabled = enable;
    self.sliderControl.enabled = enable;
}

@end
