//
//  PPMultipleTextFieldButtonTableViewCell.m
//
//  Created by Howard.Lin on 13/9/30.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPMultipleTextFieldButtonTableViewCell.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPMultipleTextFieldButtonTableViewCell(Notification)

@interface PPMultipleTextFieldButtonTableViewCell(Notification)
- (void)textFieldTextDidChangeNotification:(NSNotification *)notification;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPMultipleTextFieldButtonTableViewCell

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if((self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]))
    {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //////////////////////////////////////////////////
        
        //預設輸入上限最高
        _maxLength = NSUIntegerMax;
        
        //////////////////////////////////////////////////
        
        _textFieldButtonViews = [[NSMutableArray alloc] init];
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    //////////////////////////////////////////////////
    
    for (PPTextFieldButtonView *textView in _textFieldButtonViews)
    {
        [textView removeFromSuperview];
    }
    
    [_textFieldButtonViews removeAllObjects];
    [_textFieldButtonViews release];
	_textFieldButtonViews = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    NSUInteger totalTextFieldsCount = self.textFieldButtonViews.count;
    
    if(totalTextFieldsCount > 0)
    {
        for(NSUInteger textFieldIndex = 0 ; textFieldIndex < totalTextFieldsCount ; textFieldIndex++)
        {
            PPTextFieldButtonView *ppTextFieldButtonView = [self.textFieldButtonViews objectAtIndex:textFieldIndex];
            
            if(ppTextFieldButtonView!=nil)
            {
                CGRect textFieldFrame = self.contentView.bounds;
                
                switch(self.style)
                {
                    case UITableViewCellStyleValue1:
                    case UITableViewCellStyleValue2:
                    {
                        CGRect textLabelFrame = self.contentView.bounds;
                        
                        textLabelFrame.origin.x     = self.contentInsets.left;
                        textLabelFrame.origin.y     = self.contentInsets.top;
                        textLabelFrame.size.width   = (self.contentView.bounds.size.width-(PPTableViewCellDefaultHorizontalGap+self.contentInsets.left+self.contentInsets.right))/2;
                        textLabelFrame.size.height  -= (self.contentInsets.top+self.contentInsets.bottom);
                        self.textLabel.frame = textLabelFrame;
                        
                        
                        textFieldFrame.size.width   = textFieldFrame.size.width-self.contentInsets.right;
                        textFieldFrame.size.height  = (textFieldFrame.size.height-(PPTableViewCellDefaultVerticalGap*(self.textFieldButtonViews.count-1))-(self.contentInsets.top+self.contentInsets.bottom))/self.textFieldButtonViews.count;
                        textFieldFrame.origin.x     = textFieldFrame.origin.x+textFieldFrame.size.width+PPTableViewCellDefaultHorizontalGap;
                        textFieldFrame.origin.y     = self.contentInsets.top + (PPTableViewCellDefaultVerticalGap + textFieldFrame.size.height)*textFieldIndex;
                        
                        break;
                    }
                    case UITableViewCellStyleSubtitle:
                    {
                        CGRect textLabelFrame = self.contentView.bounds;
                        
                        
                        textLabelFrame.origin.x     = self.contentInsets.left;
                        textLabelFrame.origin.y     = self.contentInsets.top;
                        textLabelFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                        textLabelFrame.size.height  = (self.contentView.bounds.size.height-(PPTableViewCellDefaultVerticalGap+self.contentInsets.top+self.contentInsets.bottom))/2;
                        self.textLabel.frame = textLabelFrame;
                        
                        
                        textFieldFrame.origin.x     = textLabelFrame.origin.x+textFieldFrame.size.width/self.textFieldButtonViews.count * textFieldIndex;
                        textFieldFrame.origin.y     = textLabelFrame.origin.y+textLabelFrame.size.height+PPTableViewCellDefaultVerticalGap;
                        textFieldFrame.size.width   = textLabelFrame.size.width/self.textFieldButtonViews.count;
                        textFieldFrame.size.height  = textLabelFrame.size.height;
                        
                        break;
                    }
                    case UITableViewCellStyleDefault:
                    default:
                    {
                        textFieldFrame.origin.x     = self.contentInsets.left;
                        textFieldFrame.origin.y     = self.contentInsets.top + textFieldFrame.size.height/self.textFieldButtonViews.count * textFieldIndex;
                        
                        textFieldFrame.size.width   -= (self.contentInsets.left+self.contentInsets.right);
                        textFieldFrame.size.height  = textFieldFrame.size.height/self.textFieldButtonViews.count;
                        
                        break;
                    }
                }
                
                ppTextFieldButtonView.frame = textFieldFrame;
            }
            
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPTextFieldButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppTextFieldButtonViewDidBeginEditing:(PPTextFieldButtonView *)textFieldButtonView
{
    do
    {
        if([self.delegate respondsToSelector:@selector(ppMultipleTextFieldButtonTableViewCellDidBeginEditing:textFieldTag:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate ppMultipleTextFieldButtonTableViewCellDidBeginEditing:self
                                                                textFieldTag:textFieldButtonView.textField.tag];
    } while (0);
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldButtonViewDidChanged:(PPTextFieldButtonView *)textFieldButtonView
{
    do
    {
        if([self.delegate respondsToSelector:@selector(ppMultipleTextFieldButtonTableViewCellDidChanged:textFieldTag:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate ppMultipleTextFieldButtonTableViewCellDidChanged:self
                                                           textFieldTag:textFieldButtonView.textField.tag];
    } while (0);
}


//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonViewShouldBeginEditing:(PPTextFieldButtonView *)textFieldButtonView
{
    BOOL result = NO;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:textFieldTag:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [self.delegate ppMultipleTextFieldButtonTableViewCellShouldBeginEditing:self
                                                                            textFieldTag:textFieldButtonView.textField.tag];
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonViewShouldReturn:(PPTextFieldButtonView *)textFieldButtonView
{
    BOOL result = YES;
    
    do
    {
        if([self.delegate respondsToSelector:@selector(ppMultipleTextFieldButtonTableViewCellShouldReturn:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        result = [self.delegate ppMultipleTextFieldButtonTableViewCellShouldReturn:self];
        
    } while (0);
    
    return result;
}


//================================================================================
//
//================================================================================
- (void)ppTextFieldButtonViewDidEndEditing:(PPTextFieldButtonView *)textFieldButtonView
{
    do
    {
        if([self.delegate respondsToSelector:@selector(ppMultipleTextFieldButtonTableViewCellDidEndEditing:textFieldTag:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.delegate ppMultipleTextFieldButtonTableViewCellDidEndEditing:self
                                                              textFieldTag:textFieldButtonView.textField.tag];
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (BOOL)ppTextFieldButtonView:(PPTextFieldButtonView *)textFieldButtonView shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string
{
    BOOL shouldChange = YES;
    
    if([self.delegate respondsToSelector:@selector(ppMultipleTextFieldButtonTableViewCell:shouldChangeCharactersInRange:replacementString:textFieldTag:)]==YES)
    {
        shouldChange = [self.delegate ppMultipleTextFieldButtonTableViewCell:self
                                               shouldChangeCharactersInRange:range
                                                           replacementString:string
                                                                textFieldTag:textFieldButtonView.textField.tag];
    }
    else if(textFieldButtonView.textField.text.length+string.length>textFieldButtonView.maxLength)
    {
        // 新增文字，或取代文字
        if(range.length<=string.length &&
           [string length]>0)
        {
            shouldChange = NO;
        }
    }
    
    return shouldChange;
}


//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent withPPTextFieldButtonView:(PPTextFieldButtonView *)textFieldButtonView
{
    do
    {
        if([self.delegate respondsToSelector:@selector(ppMultipleTextFieldButtonTableViewCellTouchDetail:textFieldTag:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        [self.delegate ppMultipleTextFieldButtonTableViewCellTouchDetail:self textFieldTag:textFieldButtonView.textField.tag];
        
    } while (0);
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)customTextFieldsWithPlacehoders:(NSArray *)placeholders
{
    NSUInteger totalPlaceholderCount = placeholders.count;
    
    for(NSUInteger textFieldIndex = 0 ; textFieldIndex < totalPlaceholderCount ; textFieldIndex++)
    {
        PPTextFieldButtonView *textFieldButtonView = nil;
        
        if(textFieldIndex<self.textFieldButtonViews.count)
        {
            textFieldButtonView = [self.textFieldButtonViews objectAtIndex:textFieldIndex];
        }
        else
        {
            textFieldButtonView = [[PPTextFieldButtonView alloc] init];
        }
       
        if(textFieldButtonView!=nil)
        {
            textFieldButtonView.delegate                           = self;
            textFieldButtonView.maxLength                          = self.maxLength;
            textFieldButtonView.textField.autocapitalizationType   = UITextAutocapitalizationTypeWords;
            textFieldButtonView.textField.autocorrectionType       = UITextAutocorrectionTypeNo;
            textFieldButtonView.textField.backgroundColor          = [UIColor clearColor];
            textFieldButtonView.textField.borderStyle              = UITextBorderStyleNone;
            textFieldButtonView.textField.clearButtonMode          = UITextFieldViewModeWhileEditing;
            textFieldButtonView.textField.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
            
            textFieldButtonView.textField.returnKeyType            = UIReturnKeyDone;
        
            textFieldButtonView.textField.placeholder              = [placeholders objectAtIndex:textFieldIndex];
         
            //////////////////////////////////////////////////
            
            if(self.detailTextLabel!=nil)
            {
                textFieldButtonView.textField.textColor = self.detailTextLabel.textColor;
            }
            
            if([self.textFieldButtonViews indexOfObject:textFieldButtonView]==NSNotFound)
            {
                [self.contentView addSubview:textFieldButtonView];
                [self.textFieldButtonViews addObject:textFieldButtonView];
                
                [textFieldButtonView release];
            }
            
            //////////////////////////////////////////////////

            textFieldButtonView.textField.tag                      = textFieldIndex;
        }
    }
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - subclass

//==============================================================================
//
//==============================================================================
- (void)setEnable:(BOOL)enable
{
    [super setEnable:enable];
    
    for (PPTextFieldButtonView *ppTextFieldButtonView in self.textFieldButtonViews)
    {
        ppTextFieldButtonView.userInteractionEnabled = enable;
    }
}
@end
