//
//  CustomRectTextField.m
//  
//
//  Created by Howard.Lin on 2014/10/1.
//
//

#import "CustomRectTextField.h"

@implementation CustomRectTextField

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    _dataSource = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (CGRect)borderRectForBounds:(CGRect)bounds
{
    CGRect borderRectForBounds = [super borderRectForBounds:bounds];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(borderRectForBounds:withCustomRectTextField:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        borderRectForBounds = [self.dataSource borderRectForBounds:bounds withCustomRectTextField:self];
        
    } while (0);
    
    return borderRectForBounds;
}


//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds
{
    CGRect textRectForBounds = [super textRectForBounds:bounds];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(textRectForBounds:withCustomRectTextField:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        textRectForBounds = [self.dataSource textRectForBounds:bounds withCustomRectTextField:self];
        
    } while (0);
    
    return textRectForBounds;
}


//================================================================================
//
//================================================================================
- (CGRect)placeholderRectForBounds:(CGRect)bounds
{
    CGRect placeholderRectForBounds = [super placeholderRectForBounds:bounds];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(placeholderRectForBounds:withCustomRectTextField:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        placeholderRectForBounds = [self.dataSource placeholderRectForBounds:bounds withCustomRectTextField:self];
        
    } while (0);
    
    return placeholderRectForBounds;
}


//================================================================================
//
//================================================================================
- (CGRect)editingRectForBounds:(CGRect)bounds
{
    CGRect editingRectForBounds = [super editingRectForBounds:bounds];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(editingRectForBounds:withCustomRectTextField:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        editingRectForBounds = [self.dataSource editingRectForBounds:bounds withCustomRectTextField:self];
        
    } while (0);
    
    return editingRectForBounds;
}


//================================================================================
//
//================================================================================
- (CGRect)clearButtonRectForBounds:(CGRect)bounds
{
    CGRect clearButtonRectForBounds = [super clearButtonRectForBounds:bounds];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(clearButtonRectForBounds:withCustomRectTextField:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        clearButtonRectForBounds = [self.dataSource clearButtonRectForBounds:bounds withCustomRectTextField:self];
        
    } while (0);
    
    return clearButtonRectForBounds;
}


//================================================================================
//
//================================================================================
- (CGRect)leftViewRectForBounds:(CGRect)bounds
{
    CGRect leftViewRectForBounds = [super leftViewRectForBounds:bounds];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(leftViewRectForBounds:withCustomRectTextField:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        leftViewRectForBounds = [self.dataSource leftViewRectForBounds:bounds withCustomRectTextField:self];
        
    } while (0);
    
    return leftViewRectForBounds;
}


//================================================================================
//
//================================================================================
- (CGRect)rightViewRectForBounds:(CGRect)bounds
{
    CGRect rightViewRectForBounds = [super rightViewRectForBounds:bounds];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(rightViewRectForBounds:withCustomRectTextField:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rightViewRectForBounds = [self.dataSource rightViewRectForBounds:bounds withCustomRectTextField:self];
        
    } while (0);
    
    return rightViewRectForBounds;
}
@end
