//
//  CustomRectTextField.h
//  
//
//  Created by Howard.Lin on 2014/10/1.
//
//

#import <UIKit/UIKit.h>

@class CustomRectTextField;

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol  CustomRectTextFieldDataSource<NSObject>

@optional

- (CGRect)borderRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
- (CGRect)textRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
- (CGRect)placeholderRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
- (CGRect)editingRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
- (CGRect)clearButtonRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
- (CGRect)leftViewRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;
- (CGRect)rightViewRectForBounds:(CGRect)bounds withCustomRectTextField:(CustomRectTextField *)customRectTextField;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface CustomRectTextField : UITextField

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<CustomRectTextFieldDataSource> dataSource;

@end
