//
//  CustomRectLabel.m
//  
//
//  Created by Howard.Lin on 2014/10/1.
//
//

#import "CustomRectLabel.h"

@implementation CustomRectLabel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    _dataSource = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (CGRect)textRectForBounds:(CGRect)bounds limitedToNumberOfLines:(NSInteger)numberOfLines
{
    CGRect textRectForBounds = [super textRectForBounds:bounds limitedToNumberOfLines:numberOfLines];
    
    //////////////////////////////////////////////////
    
    do
    {
        if(self.dataSource==nil ||
           [self.dataSource respondsToSelector:@selector(textRectForBounds:limitedToNumberOfLines:withCustomRectLabel:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        textRectForBounds = [self.dataSource textRectForBounds:bounds limitedToNumberOfLines:numberOfLines withCustomRectLabel:self];
        
    } while (0);
    
    return textRectForBounds;

}

@end
