//
//  PPTableView.m
//  
//
//  Created by Mike on 13/5/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTableView.h"

@implementation PPTableView


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (instancetype)init
{
    if(self=[super init])
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        // !! ios9 以上ipad介面會把table的內容左右內縮，造成cell的layout異常，
        // 設定這個可以讓介面看起來跟ios9以前一樣
        
        if(@available(iOS 9.0, *))
        {
            [self setCellLayoutMarginsFollowReadableWidth:NO];
        }
        
        // !ios 15之後section header上會預設有一個高度，設定後可以與之前一樣
        if(@available(iOS 15.0,*))
        {
            [self setSectionHeaderTopPadding:0.0];
        }
    }
    
    return self;
}


//==============================================================================
//
//==============================================================================
- (instancetype)initWithFrame:(CGRect)frame
{
    if(self=[super initWithFrame:frame])
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        // !! ios9 以上ipad介面會把table的內容左右內縮，造成cell的layout異常，
        // 設定這個可以讓介面看起來跟ios9以前一樣
        
        if(@available(iOS 9.0, *))
        {
            [self setCellLayoutMarginsFollowReadableWidth:NO];
        }
        
        // !ios 15之後section header上會預設有一個高度，設定後可以與之前一樣
        if(@available(iOS 15.0,*))
        {
            [self setSectionHeaderTopPadding:0.0];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame style:(UITableViewStyle)style
{
    if((self = [super initWithFrame:frame style:style]))
    {
        if([self respondsToSelector:@selector(setSectionIndexBackgroundColor:)]==YES)
        {
            [self performSelector:@selector(setSectionIndexBackgroundColor:) withObject:[UIColor clearColor]];
        }
        
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        // !! ios9 以上ipad介面會把table的內容左右內縮，造成cell的layout異常，
        // 設定這個可以讓介面看起來跟ios9以前一樣
        
        if(@available(iOS 9.0, *))
        {
            [self setCellLayoutMarginsFollowReadableWidth:NO];
        }
        
        // !ios 15之後section header上會預設有一個高度，設定後可以與之前一樣
        if(@available(iOS 15.0,*))
        {
            [self setSectionHeaderTopPadding:0.0];
        }
    }
    
    return self;
}



////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overriding Methods

//================================================================================
//
//================================================================================
- (void)setBackgroundColor:(UIColor *)backgroundColor
{
    [super setBackgroundColor:backgroundColor];
    
    //////////////////////////////////////////////////
    
    if(@available(iOS 5.0, *))
    {
        BOOL hidden = NO;
        
        if(backgroundColor!=nil)
        {
            CGFloat alpha = 0;
            
            [self.backgroundColor getWhite:NULL alpha:&alpha];
            
            if(alpha!=0)
            {
                hidden = YES;
            }
        }
        
        self.backgroundView.hidden = hidden;
    }
}


//================================================================================
//
//================================================================================
- (void)setRowHeight:(CGFloat)rowHeight
{
    [super setRowHeight:rowHeight];
    
    if(@available(iOS 7.0, *))
    {
        // 客製化高度時要把estimatedRowHeight一並調整，避免contentSize計算錯誤。
        self.estimatedRowHeight = rowHeight;
    }
}

@end
