//
//  PPSystemInfoController.m
//  
//
//  Created by Mike on 13/5/13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPSystemInfoController.h"
#import <sys/sysctl.h>

@implementation PPSystemInfoController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (PPSystemInfoLanguage)language
{
    PPSystemInfoLanguage language = PPSystemInfoLanguage_English;
    
    do
    {
        NSString *appLanguage = nil;
        
#ifdef __IPHONE_OS_VERSION_MIN_REQUIRED
        //8.0以後->有ScriptCode，可以用它來分繁簡體
        //7.0以前->無ScriptCode，需要用[NSLocale prferredLanguages]的做法來分繁簡體
        if ([[UIDevice currentDevice].systemVersion floatValue] >= 8.0)
        {
            NSString *languageCode = [[NSLocale currentLocale] objectForKey:NSLocaleLanguageCode];
            NSString *scriptCode = [[NSLocale currentLocale] objectForKey:NSLocaleScriptCode];
            
            if (scriptCode != nil && [languageCode isEqualToString:@"zh"])
            {
                appLanguage = [languageCode stringByAppendingString:[NSString stringWithFormat:@"-%@",scriptCode]];
            }
            else
            {
                appLanguage = languageCode;
            }
        }
        else
        {
            appLanguage = [[NSLocale preferredLanguages] objectAtIndex:0];
        }
#else
        
        // 10.12以後舊的做法不適用了，需要用新的簡/繁體分辨方式，故和iOS一樣分版本進行。
        // 1404是NSAppKitVersionNumber10_11, 為了相容性所以用數字而不用Define去記。
        if (NSAppKitVersionNumber >= 1404)
        {
            NSString *languageCode = [[NSLocale currentLocale] objectForKey:NSLocaleLanguageCode];
            NSString *scriptCode = [[NSLocale currentLocale] objectForKey:NSLocaleScriptCode];
         
            if (scriptCode != nil && [languageCode isEqualToString:@"zh"])
            {
                appLanguage = [languageCode stringByAppendingString:[NSString stringWithFormat:@"-%@",scriptCode]];
            }
            else
            {
                if([scriptCode length]<=0)
                {
                    appLanguage = [[[NSBundle mainBundle] preferredLocalizations] firstObject];
                }
                else
                {
                    appLanguage = languageCode;
                }
            }
        }
        else
        {
            appLanguage = [[NSLocale preferredLanguages] objectAtIndex:0];
        }
        
#endif
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if([appLanguage isEqualToString:@"en"])                 language = PPSystemInfoLanguage_English;
        else if([appLanguage isEqualToString:@"zh"])
        {
            //8.0以後的繁簡體Script規則：
            //地區是台灣->zh視為繁體中文，簡體中文會是zh-Hans
            //地區是中國->zh視為簡體中文，繁體中文會是zh-Hant
            NSString *countryCode = [[NSLocale currentLocale] objectForKey:NSLocaleCountryCode];
            
            if ([countryCode isEqualToString:@"TW"] || [countryCode isEqualToString:@"HK"])
            {
                language = PPSystemInfoLanguage_ChineseTraditional;
            }
            else if([countryCode isEqualToString:@"CN"])
            {
                language = PPSystemInfoLanguage_ChineseSimplified;
            }
            else
            {
                language = PPSystemInfoLanguage_ChineseTraditional;
            }
        }
        else if([appLanguage isEqualToString:@"ko"])			language = PPSystemInfoLanguage_Korean;
        else if([appLanguage isEqualToString:@"ja"])			language = PPSystemInfoLanguage_Japanese;
        else if([appLanguage isEqualToString:@"es"])			language = PPSystemInfoLanguage_Spanish;
        else if([appLanguage isEqualToString:@"de"])			language = PPSystemInfoLanguage_German;
        else if([appLanguage isEqualToString:@"pt"])			language = PPSystemInfoLanguage_Portuguese;
        else if([appLanguage isEqualToString:@"it"])			language = PPSystemInfoLanguage_Italian;
        else if([appLanguage isEqualToString:@"zh-Hant"])       language = PPSystemInfoLanguage_ChineseTraditional;
        else if([appLanguage isEqualToString:@"zh-Hans"])       language = PPSystemInfoLanguage_ChineseSimplified;
        else if([appLanguage isEqualToString:@"nl"])			language = PPSystemInfoLanguage_Dutch;
        else if([appLanguage isEqualToString:@"fr"])			language = PPSystemInfoLanguage_French;
        else if([appLanguage isEqualToString:@"da"])			language = PPSystemInfoLanguage_Danish;
        else if([appLanguage isEqualToString:@"fi"])			language = PPSystemInfoLanguage_Finnish;
        else if([appLanguage isEqualToString:@"nb"])			language = PPSystemInfoLanguage_Norwegian;
        else if([appLanguage isEqualToString:@"sv"])			language = PPSystemInfoLanguage_Swedish;
        else if([appLanguage isEqualToString:@"ru"])			language = PPSystemInfoLanguage_Russian;
        else if([appLanguage isEqualToString:@"pl"])			language = PPSystemInfoLanguage_Polish;
        else if([appLanguage isEqualToString:@"tr"])			language = PPSystemInfoLanguage_Turkish;
        else if([appLanguage isEqualToString:@"uk"])			language = PPSystemInfoLanguage_Ukrainian;
        else if([appLanguage isEqualToString:@"ar"])			language = PPSystemInfoLanguage_Arabic;
        else if([appLanguage isEqualToString:@"hr"])			language = PPSystemInfoLanguage_Croatian;
        else if([appLanguage isEqualToString:@"cs"])			language = PPSystemInfoLanguage_Czech;
        else if([appLanguage isEqualToString:@"el"])			language = PPSystemInfoLanguage_Greek;
        else if([appLanguage isEqualToString:@"he"])			language = PPSystemInfoLanguage_Hebrew;
        else if([appLanguage isEqualToString:@"ro"])			language = PPSystemInfoLanguage_Romanian;
        else if([appLanguage isEqualToString:@"sk"])			language = PPSystemInfoLanguage_Slovak;
        else if([appLanguage isEqualToString:@"th"])			language = PPSystemInfoLanguage_Thai;
        else if([appLanguage isEqualToString:@"id"])			language = PPSystemInfoLanguage_Indonesian;
        else if([appLanguage isEqualToString:@"ms"])			language = PPSystemInfoLanguage_Malay;
        else if([appLanguage isEqualToString:@"ca"])			language = PPSystemInfoLanguage_Catalan;
        else if([appLanguage isEqualToString:@"hu"])			language = PPSystemInfoLanguage_Hungarian;
        else if([appLanguage isEqualToString:@"vi"])			language = PPSystemInfoLanguage_Vietnamese;
        else if([appLanguage isEqualToString:@"hi"])			language = PPSystemInfoLanguage_Hindi;
        
    }while(0);
    
    return language;
}

+ (NSString *)stringWithLanguage:(PPSystemInfoLanguage)language
{
    NSString *string = nil;
    
    switch(language)
    {
		case PPSystemInfoLanguage_English:              {string = @"en";        break;}
		case PPSystemInfoLanguage_ChineseTraditional:	{string = @"zh-Hant";   break;}
		case PPSystemInfoLanguage_Korean:				{string = @"ko";        break;}
		case PPSystemInfoLanguage_Japanese:				{string = @"ja";        break;}
		case PPSystemInfoLanguage_Spanish:				{string = @"es";        break;}
		case PPSystemInfoLanguage_German:				{string = @"de";        break;}
		case PPSystemInfoLanguage_Portuguese:			{string = @"pt";        break;}
        case PPSystemInfoLanguage_Italian:              {string = @"it";        break;}
		case PPSystemInfoLanguage_ChineseSimplified:	{string = @"zh-Hans";   break;}
		case PPSystemInfoLanguage_Dutch:				{string = @"nl";        break;}
		case PPSystemInfoLanguage_French:				{string = @"fr";        break;}
		case PPSystemInfoLanguage_Danish:				{string = @"da";        break;}
		case PPSystemInfoLanguage_Finnish:				{string = @"fi";        break;}
		case PPSystemInfoLanguage_Norwegian:			{string = @"nb";        break;}
		case PPSystemInfoLanguage_Swedish:				{string = @"sv";        break;}
		case PPSystemInfoLanguage_Russian:				{string = @"ru";        break;}
		case PPSystemInfoLanguage_Polish:				{string = @"pl";        break;}
		case PPSystemInfoLanguage_Turkish:				{string = @"tr";        break;}
		case PPSystemInfoLanguage_Ukrainian:			{string = @"uk";        break;}
		case PPSystemInfoLanguage_Arabic:				{string = @"ar";        break;}
		case PPSystemInfoLanguage_Croatian:				{string = @"hr";        break;}
		case PPSystemInfoLanguage_Czech:				{string = @"cs";        break;}
		case PPSystemInfoLanguage_Greek:				{string = @"el";        break;}
		case PPSystemInfoLanguage_Hebrew:				{string = @"he";        break;}
		case PPSystemInfoLanguage_Romanian:				{string = @"ro";        break;}
		case PPSystemInfoLanguage_Slovak:				{string = @"sk";        break;}
		case PPSystemInfoLanguage_Thai:					{string = @"th";        break;}
		case PPSystemInfoLanguage_Indonesian:			{string = @"id";        break;}
		case PPSystemInfoLanguage_Malay:				{string = @"ms";        break;}
		case PPSystemInfoLanguage_Catalan:				{string = @"ca";        break;}
		case PPSystemInfoLanguage_Hungarian:			{string = @"hu";        break;}
		case PPSystemInfoLanguage_Vietnamese:			{string = @"vi";        break;}
        case PPSystemInfoLanguage_Hindi:                {string = @"hi";        break;}
		default:                                        {                       break;}
	}
    
    return string;
}

+ (PPSystemInfoLocale)locale
{
    PPSystemInfoLocale locale = PPSystemInfoLocale_UnitedStates;
    
    do
    {
        NSString *appLocale = [[NSLocale currentLocale] objectForKey:NSLocaleCountryCode];
        
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if([appLocale isEqualToString:@"BA"])   locale = PPSystemInfoLocale_BosniaHerzegovina;
        else if([appLocale isEqualToString:@"CM"])   locale = PPSystemInfoLocale_Cameroon;
        else if([appLocale isEqualToString:@"RW"])   locale = PPSystemInfoLocale_Rwanda;
        else if([appLocale isEqualToString:@"SZ"])   locale = PPSystemInfoLocale_Swaziland;
        else if([appLocale isEqualToString:@"IL"])   locale = PPSystemInfoLocale_Israel;
        else if([appLocale isEqualToString:@"PN"])   locale = PPSystemInfoLocale_PitcairnIslands;
        else if([appLocale isEqualToString:@"NF"])   locale = PPSystemInfoLocale_NorfolkIsland;
        else if([appLocale isEqualToString:@"TZ"])   locale = PPSystemInfoLocale_Tanzania;
        else if([appLocale isEqualToString:@"TW"])   locale = PPSystemInfoLocale_Taiwan;
        else if([appLocale isEqualToString:@"LI"])   locale = PPSystemInfoLocale_Liechtenstein;
        else if([appLocale isEqualToString:@"TH"])   locale = PPSystemInfoLocale_Thailand;
        else if([appLocale isEqualToString:@"IN"])   locale = PPSystemInfoLocale_India;
        else if([appLocale isEqualToString:@"EA"])   locale = PPSystemInfoLocale_CeutaMelilla;
        else if([appLocale isEqualToString:@"GF"])   locale = PPSystemInfoLocale_FrenchGuiana;
        else if([appLocale isEqualToString:@"001"])   locale = PPSystemInfoLocale_World;
        else if([appLocale isEqualToString:@"TR"])   locale = PPSystemInfoLocale_Turkey;
        else if([appLocale isEqualToString:@"CH"])   locale = PPSystemInfoLocale_Switzerland;
        else if([appLocale isEqualToString:@"TG"])   locale = PPSystemInfoLocale_Togo;
        else if([appLocale isEqualToString:@"NG"])   locale = PPSystemInfoLocale_Nigeria;
        else if([appLocale isEqualToString:@"SC"])   locale = PPSystemInfoLocale_Seychelles;
        else if([appLocale isEqualToString:@"HN"])   locale = PPSystemInfoLocale_Honduras;
        else if([appLocale isEqualToString:@"AG"])   locale = PPSystemInfoLocale_AntiguaBarbuda;
        else if([appLocale isEqualToString:@"KZ"])   locale = PPSystemInfoLocale_Kazakhstan;
        else if([appLocale isEqualToString:@"ET"])   locale = PPSystemInfoLocale_Ethiopia;
        else if([appLocale isEqualToString:@"MO"])   locale = PPSystemInfoLocale_MacauSARChina;
        else if([appLocale isEqualToString:@"BE"])   locale = PPSystemInfoLocale_Belgium;
        else if([appLocale isEqualToString:@"KH"])   locale = PPSystemInfoLocale_Cambodia;
        else if([appLocale isEqualToString:@"MM"])   locale = PPSystemInfoLocale_MyanmarBurma;
        else if([appLocale isEqualToString:@"MZ"])   locale = PPSystemInfoLocale_Mozambique;
        else if([appLocale isEqualToString:@"GH"])   locale = PPSystemInfoLocale_Ghana;
        else if([appLocale isEqualToString:@"EC"])   locale = PPSystemInfoLocale_Ecuador;
        else if([appLocale isEqualToString:@"GB"])   locale = PPSystemInfoLocale_UnitedKingdom;
        else if([appLocale isEqualToString:@"ME"])   locale = PPSystemInfoLocale_Montenegro;
        else if([appLocale isEqualToString:@"MK"])   locale = PPSystemInfoLocale_Macedonia;
        else if([appLocale isEqualToString:@"MR"])   locale = PPSystemInfoLocale_Mauritania;
        else if([appLocale isEqualToString:@"BM"])   locale = PPSystemInfoLocale_Bermuda;
        else if([appLocale isEqualToString:@"AI"])   locale = PPSystemInfoLocale_Anguilla;
        else if([appLocale isEqualToString:@"ES"])   locale = PPSystemInfoLocale_Spain;
        else if([appLocale isEqualToString:@"PR"])   locale = PPSystemInfoLocale_PuertoRico;
        else if([appLocale isEqualToString:@"ML"])   locale = PPSystemInfoLocale_Mali;
        else if([appLocale isEqualToString:@"MG"])   locale = PPSystemInfoLocale_Madagascar;
        else if([appLocale isEqualToString:@"TL"])   locale = PPSystemInfoLocale_TimorLeste;
        else if([appLocale isEqualToString:@"LC"])   locale = PPSystemInfoLocale_StLucia;
        else if([appLocale isEqualToString:@"SG"])   locale = PPSystemInfoLocale_Singapore;
        else if([appLocale isEqualToString:@"LV"])   locale = PPSystemInfoLocale_Latvia;
        else if([appLocale isEqualToString:@"US"])   locale = PPSystemInfoLocale_UnitedStates;
        else if([appLocale isEqualToString:@"PT"])   locale = PPSystemInfoLocale_Portugal;
        else if([appLocale isEqualToString:@"LR"])   locale = PPSystemInfoLocale_Liberia;
        else if([appLocale isEqualToString:@"NL"])   locale = PPSystemInfoLocale_Netherlands;
        else if([appLocale isEqualToString:@"CA"])   locale = PPSystemInfoLocale_Canada;
        else if([appLocale isEqualToString:@"UG"])   locale = PPSystemInfoLocale_Uganda;
        else if([appLocale isEqualToString:@"MH"])   locale = PPSystemInfoLocale_MarshallIslands;
        else if([appLocale isEqualToString:@"TO"])   locale = PPSystemInfoLocale_Tonga;
        else if([appLocale isEqualToString:@"ZA"])   locale = PPSystemInfoLocale_SouthAfrica;
        else if([appLocale isEqualToString:@"MA"])   locale = PPSystemInfoLocale_Morocco;
        else if([appLocale isEqualToString:@"KM"])   locale = PPSystemInfoLocale_Comoros;
        else if([appLocale isEqualToString:@"AL"])   locale = PPSystemInfoLocale_Albania;
        else if([appLocale isEqualToString:@"BJ"])   locale = PPSystemInfoLocale_Benin;
        else if([appLocale isEqualToString:@"VU"])   locale = PPSystemInfoLocale_Vanuatu;
        else if([appLocale isEqualToString:@"DE"])   locale = PPSystemInfoLocale_Germany;
        else if([appLocale isEqualToString:@"CD"])   locale = PPSystemInfoLocale_CongoKinshasa;
        else if([appLocale isEqualToString:@"RE"])   locale = PPSystemInfoLocale_Reunion;
        else if([appLocale isEqualToString:@"KE"])   locale = PPSystemInfoLocale_Kenya;
        else if([appLocale isEqualToString:@"GL"])   locale = PPSystemInfoLocale_Greenland;
        else if([appLocale isEqualToString:@"TN"])   locale = PPSystemInfoLocale_Tunisia;
        else if([appLocale isEqualToString:@"PA"])   locale = PPSystemInfoLocale_Panama;
        else if([appLocale isEqualToString:@"PL"])   locale = PPSystemInfoLocale_Poland;
        else if([appLocale isEqualToString:@"NE"])   locale = PPSystemInfoLocale_Niger;
        else if([appLocale isEqualToString:@"GQ"])   locale = PPSystemInfoLocale_EquatorialGuinea;
        else if([appLocale isEqualToString:@"GN"])   locale = PPSystemInfoLocale_Guinea;
        else if([appLocale isEqualToString:@"PW"])   locale = PPSystemInfoLocale_Palau;
        else if([appLocale isEqualToString:@"NO"])   locale = PPSystemInfoLocale_Norway;
        else if([appLocale isEqualToString:@"RS"])   locale = PPSystemInfoLocale_Serbia;
        else if([appLocale isEqualToString:@"FR"])   locale = PPSystemInfoLocale_France;
        else if([appLocale isEqualToString:@"ZW"])   locale = PPSystemInfoLocale_Zimbabwe;
        else if([appLocale isEqualToString:@"BO"])   locale = PPSystemInfoLocale_Bolivia;
        else if([appLocale isEqualToString:@"AF"])   locale = PPSystemInfoLocale_Afghanistan;
        else if([appLocale isEqualToString:@"BS"])   locale = PPSystemInfoLocale_Bahamas;
        else if([appLocale isEqualToString:@"CX"])   locale = PPSystemInfoLocale_ChristmasIsland;
        else if([appLocale isEqualToString:@"ZM"])   locale = PPSystemInfoLocale_Zambia;
        else if([appLocale isEqualToString:@"HT"])   locale = PPSystemInfoLocale_Haiti;
        else if([appLocale isEqualToString:@"GP"])   locale = PPSystemInfoLocale_Guadeloupe;
        else if([appLocale isEqualToString:@"GR"])   locale = PPSystemInfoLocale_Greece;
        else if([appLocale isEqualToString:@"CY"])   locale = PPSystemInfoLocale_Cyprus;
        else if([appLocale isEqualToString:@"GT"])   locale = PPSystemInfoLocale_Guatemala;
        else if([appLocale isEqualToString:@"HK"])   locale = PPSystemInfoLocale_HongKongSARChina;
        else if([appLocale isEqualToString:@"UY"])   locale = PPSystemInfoLocale_Uruguay;
        else if([appLocale isEqualToString:@"NR"])   locale = PPSystemInfoLocale_Nauru;
        else if([appLocale isEqualToString:@"PE"])   locale = PPSystemInfoLocale_Peru;
        else if([appLocale isEqualToString:@"SN"])   locale = PPSystemInfoLocale_Senegal;
        else if([appLocale isEqualToString:@"CZ"])   locale = PPSystemInfoLocale_CzechRepublic;
        else if([appLocale isEqualToString:@"BT"])   locale = PPSystemInfoLocale_Bhutan;
        else if([appLocale isEqualToString:@"JO"])   locale = PPSystemInfoLocale_Jordan;
        else if([appLocale isEqualToString:@"CF"])   locale = PPSystemInfoLocale_CentralAfricanRepublic;
        else if([appLocale isEqualToString:@"TD"])   locale = PPSystemInfoLocale_Chad;
        else if([appLocale isEqualToString:@"BW"])   locale = PPSystemInfoLocale_Botswana;
        else if([appLocale isEqualToString:@"AS"])   locale = PPSystemInfoLocale_AmericanSamoa;
        else if([appLocale isEqualToString:@"BN"])   locale = PPSystemInfoLocale_Brunei;
        else if([appLocale isEqualToString:@"CN"])   locale = PPSystemInfoLocale_China;
        else if([appLocale isEqualToString:@"AM"])   locale = PPSystemInfoLocale_Armenia;
        else if([appLocale isEqualToString:@"CG"])   locale = PPSystemInfoLocale_CongoBrazzaville;
        else if([appLocale isEqualToString:@"MP"])   locale = PPSystemInfoLocale_NorthernMarianaIslands;
        else if([appLocale isEqualToString:@"SA"])   locale = PPSystemInfoLocale_SaudiArabia;
        else if([appLocale isEqualToString:@"FI"])   locale = PPSystemInfoLocale_Finland;
        else if([appLocale isEqualToString:@"LY"])   locale = PPSystemInfoLocale_Libya;
        else if([appLocale isEqualToString:@"AT"])   locale = PPSystemInfoLocale_Austria;
        else if([appLocale isEqualToString:@"NA"])   locale = PPSystemInfoLocale_Namibia;
        else if([appLocale isEqualToString:@"NU"])   locale = PPSystemInfoLocale_Niue;
        else if([appLocale isEqualToString:@"PH"])   locale = PPSystemInfoLocale_Philippines;
        else if([appLocale isEqualToString:@"KI"])   locale = PPSystemInfoLocale_Kiribati;
        else if([appLocale isEqualToString:@"JE"])   locale = PPSystemInfoLocale_Jersey;
        else if([appLocale isEqualToString:@"AU"])   locale = PPSystemInfoLocale_Australia;
        else if([appLocale isEqualToString:@"IR"])   locale = PPSystemInfoLocale_Iran;
        else if([appLocale isEqualToString:@"UZ"])   locale = PPSystemInfoLocale_Uzbekistan;
        else if([appLocale isEqualToString:@"PF"])   locale = PPSystemInfoLocale_FrenchPolynesia;
        else if([appLocale isEqualToString:@"IT"])   locale = PPSystemInfoLocale_Italy;
        else if([appLocale isEqualToString:@"BZ"])   locale = PPSystemInfoLocale_Belize;
        else if([appLocale isEqualToString:@"KW"])   locale = PPSystemInfoLocale_Kuwait;
        else if([appLocale isEqualToString:@"GW"])   locale = PPSystemInfoLocale_GuineaBissau;
        else if([appLocale isEqualToString:@"VC"])   locale = PPSystemInfoLocale_StVincentGrenadines;
        else if([appLocale isEqualToString:@"DJ"])   locale = PPSystemInfoLocale_Djibouti;
        else if([appLocale isEqualToString:@"SV"])   locale = PPSystemInfoLocale_ElSalvador;
        else if([appLocale isEqualToString:@"MS"])   locale = PPSystemInfoLocale_Montserrat;
        else if([appLocale isEqualToString:@"ST"])   locale = PPSystemInfoLocale_SaoTomePrincipe;
        else if([appLocale isEqualToString:@"SD"])   locale = PPSystemInfoLocale_Sudan;
        else if([appLocale isEqualToString:@"IQ"])   locale = PPSystemInfoLocale_Iraq;
        else if([appLocale isEqualToString:@"MT"])   locale = PPSystemInfoLocale_Malta;
        else if([appLocale isEqualToString:@"GE"])   locale = PPSystemInfoLocale_Georgia;
        else if([appLocale isEqualToString:@"SR"])   locale = PPSystemInfoLocale_Suriname;
        else if([appLocale isEqualToString:@"DO"])   locale = PPSystemInfoLocale_DominicanRepublic;
        else if([appLocale isEqualToString:@"419"])   locale = PPSystemInfoLocale_LatinAmerica;
        else if([appLocale isEqualToString:@"MU"])   locale = PPSystemInfoLocale_Mauritius;
        else if([appLocale isEqualToString:@"EE"])   locale = PPSystemInfoLocale_Estonia;
        else if([appLocale isEqualToString:@"IE"])   locale = PPSystemInfoLocale_Ireland;
        else if([appLocale isEqualToString:@"CL"])   locale = PPSystemInfoLocale_Chile;
        else if([appLocale isEqualToString:@"CV"])   locale = PPSystemInfoLocale_CapeVerde;
        else if([appLocale isEqualToString:@"CI"])   locale = PPSystemInfoLocale_CotedIvoire;
        else if([appLocale isEqualToString:@"NZ"])   locale = PPSystemInfoLocale_NewZealand;
        else if([appLocale isEqualToString:@"KG"])   locale = PPSystemInfoLocale_Kyrgyzstan;
        else if([appLocale isEqualToString:@"KN"])   locale = PPSystemInfoLocale_StKittsNevis;
        else if([appLocale isEqualToString:@"SJ"])   locale = PPSystemInfoLocale_SvalbardJanMayen;
        else if([appLocale isEqualToString:@"RU"])   locale = PPSystemInfoLocale_Russia;
        else if([appLocale isEqualToString:@"AX"])   locale = PPSystemInfoLocale_AlandIslands;
        else if([appLocale isEqualToString:@"VG"])   locale = PPSystemInfoLocale_BritishVirginIslands;
        else if([appLocale isEqualToString:@"BF"])   locale = PPSystemInfoLocale_BurkinaFaso;
        else if([appLocale isEqualToString:@"MW"])   locale = PPSystemInfoLocale_Malawi;
        else if([appLocale isEqualToString:@"LS"])   locale = PPSystemInfoLocale_Lesotho;
        else if([appLocale isEqualToString:@"NC"])   locale = PPSystemInfoLocale_NewCaledonia;
        else if([appLocale isEqualToString:@"IS"])   locale = PPSystemInfoLocale_Iceland;
        else if([appLocale isEqualToString:@"FO"])   locale = PPSystemInfoLocale_FaroeIslands;
        else if([appLocale isEqualToString:@"LT"])   locale = PPSystemInfoLocale_Lithuania;
        else if([appLocale isEqualToString:@"QA"])   locale = PPSystemInfoLocale_Qatar;
        else if([appLocale isEqualToString:@"CO"])   locale = PPSystemInfoLocale_Colombia;
        else if([appLocale isEqualToString:@"AZ"])   locale = PPSystemInfoLocale_Azerbaijan;
        else if([appLocale isEqualToString:@"BI"])   locale = PPSystemInfoLocale_Burundi;
        else if([appLocale isEqualToString:@"VI"])   locale = PPSystemInfoLocale_USVirginIslands;
        else if([appLocale isEqualToString:@"MY"])   locale = PPSystemInfoLocale_Malaysia;
        else if([appLocale isEqualToString:@"LU"])   locale = PPSystemInfoLocale_Luxembourg;
        else if([appLocale isEqualToString:@"SY"])   locale = PPSystemInfoLocale_Syria;
        else if([appLocale isEqualToString:@"JM"])   locale = PPSystemInfoLocale_Jamaica;
        else if([appLocale isEqualToString:@"PM"])   locale = PPSystemInfoLocale_StPierreMiquelon;
        else if([appLocale isEqualToString:@"MD"])   locale = PPSystemInfoLocale_Moldova;
        else if([appLocale isEqualToString:@"IM"])   locale = PPSystemInfoLocale_IsleofMan;
        else if([appLocale isEqualToString:@"NI"])   locale = PPSystemInfoLocale_Nicaragua;
        else if([appLocale isEqualToString:@"SX"])   locale = PPSystemInfoLocale_SintMaarten;
        else if([appLocale isEqualToString:@"TC"])   locale = PPSystemInfoLocale_TurksCaicosIslands;
        else if([appLocale isEqualToString:@"EG"])   locale = PPSystemInfoLocale_Egypt;
        else if([appLocale isEqualToString:@"MC"])   locale = PPSystemInfoLocale_Monaco;
        else if([appLocale isEqualToString:@"CR"])   locale = PPSystemInfoLocale_CostaRica;
        else if([appLocale isEqualToString:@"EH"])   locale = PPSystemInfoLocale_WesternSahara;
        else if([appLocale isEqualToString:@"GD"])   locale = PPSystemInfoLocale_Grenada;
        else if([appLocale isEqualToString:@"BL"])   locale = PPSystemInfoLocale_StBarthelemy;
        else if([appLocale isEqualToString:@"SB"])   locale = PPSystemInfoLocale_SolomonIslands;
        else if([appLocale isEqualToString:@"PK"])   locale = PPSystemInfoLocale_Pakistan;
        else if([appLocale isEqualToString:@"SO"])   locale = PPSystemInfoLocale_Somalia;
        else if([appLocale isEqualToString:@"MF"])   locale = PPSystemInfoLocale_StMartin;
        else if([appLocale isEqualToString:@"WS"])   locale = PPSystemInfoLocale_Samoa;
        else if([appLocale isEqualToString:@"CU"])   locale = PPSystemInfoLocale_Cuba;
        else if([appLocale isEqualToString:@"JP"])   locale = PPSystemInfoLocale_Japan;
        else if([appLocale isEqualToString:@"IO"])   locale = PPSystemInfoLocale_BritishIndianOceanTerritory;
        else if([appLocale isEqualToString:@"GG"])   locale = PPSystemInfoLocale_Guernsey;
        else if([appLocale isEqualToString:@"AO"])   locale = PPSystemInfoLocale_Angola;
        else if([appLocale isEqualToString:@"RO"])   locale = PPSystemInfoLocale_Romania;
        else if([appLocale isEqualToString:@"UM"])   locale = PPSystemInfoLocale_USOutlyingIslands;
        else if([appLocale isEqualToString:@"SE"])   locale = PPSystemInfoLocale_Sweden;
        else if([appLocale isEqualToString:@"KY"])   locale = PPSystemInfoLocale_CaymanIslands;
        else if([appLocale isEqualToString:@"GI"])   locale = PPSystemInfoLocale_Gibraltar;
        else if([appLocale isEqualToString:@"BR"])   locale = PPSystemInfoLocale_Brazil;
        else if([appLocale isEqualToString:@"TJ"])   locale = PPSystemInfoLocale_Tajikistan;
        else if([appLocale isEqualToString:@"PY"])   locale = PPSystemInfoLocale_Paraguay;
        else if([appLocale isEqualToString:@"SS"])   locale = PPSystemInfoLocale_SouthSudan;
        else if([appLocale isEqualToString:@"TK"])   locale = PPSystemInfoLocale_Tokelau;
        else if([appLocale isEqualToString:@"LK"])   locale = PPSystemInfoLocale_SriLanka;
        else if([appLocale isEqualToString:@"DZ"])   locale = PPSystemInfoLocale_Algeria;
        else if([appLocale isEqualToString:@"AD"])   locale = PPSystemInfoLocale_Andorra;
        else if([appLocale isEqualToString:@"AR"])   locale = PPSystemInfoLocale_Argentina;
        else if([appLocale isEqualToString:@"SK"])   locale = PPSystemInfoLocale_Slovakia;
        else if([appLocale isEqualToString:@"SH"])   locale = PPSystemInfoLocale_StHelena;
        else if([appLocale isEqualToString:@"ER"])   locale = PPSystemInfoLocale_Eritrea;
        else if([appLocale isEqualToString:@"BQ"])   locale = PPSystemInfoLocale_CaribbeanNetherlands;
        else if([appLocale isEqualToString:@"SI"])   locale = PPSystemInfoLocale_Slovenia;
        else if([appLocale isEqualToString:@"GM"])   locale = PPSystemInfoLocale_Gambia;
        else if([appLocale isEqualToString:@"CW"])   locale = PPSystemInfoLocale_Curacao;
        else if([appLocale isEqualToString:@"HR"])   locale = PPSystemInfoLocale_Croatia;
        else if([appLocale isEqualToString:@"FJ"])   locale = PPSystemInfoLocale_Fiji;
        else if([appLocale isEqualToString:@"BY"])   locale = PPSystemInfoLocale_Belarus;
        else if([appLocale isEqualToString:@"FK"])   locale = PPSystemInfoLocale_FalklandIslands;
        else if([appLocale isEqualToString:@"SL"])   locale = PPSystemInfoLocale_SierraLeone;
        else if([appLocale isEqualToString:@"BH"])   locale = PPSystemInfoLocale_Bahrain;
        else if([appLocale isEqualToString:@"LA"])   locale = PPSystemInfoLocale_Laos;
        else if([appLocale isEqualToString:@"NP"])   locale = PPSystemInfoLocale_Nepal;
        else if([appLocale isEqualToString:@"IC"])   locale = PPSystemInfoLocale_CanaryIslands;
        else if([appLocale isEqualToString:@"XK"])   locale = PPSystemInfoLocale_Kosovo;
        else if([appLocale isEqualToString:@"HU"])   locale = PPSystemInfoLocale_Hungary;
        else if([appLocale isEqualToString:@"AE"])   locale = PPSystemInfoLocale_UnitedArabEmirates;
        else if([appLocale isEqualToString:@"FM"])   locale = PPSystemInfoLocale_Micronesia;
        else if([appLocale isEqualToString:@"KP"])   locale = PPSystemInfoLocale_NorthKorea;
        else if([appLocale isEqualToString:@"150"])   locale = PPSystemInfoLocale_Europe;
        else if([appLocale isEqualToString:@"MQ"])   locale = PPSystemInfoLocale_Martinique;
        else if([appLocale isEqualToString:@"VE"])   locale = PPSystemInfoLocale_Venezuela;
        else if([appLocale isEqualToString:@"WF"])   locale = PPSystemInfoLocale_WallisFutuna;
        else if([appLocale isEqualToString:@"UA"])   locale = PPSystemInfoLocale_Ukraine;
        else if([appLocale isEqualToString:@"TM"])   locale = PPSystemInfoLocale_Turkmenistan;
        else if([appLocale isEqualToString:@"MN"])   locale = PPSystemInfoLocale_Mongolia;
        else if([appLocale isEqualToString:@"KR"])   locale = PPSystemInfoLocale_SouthKorea;
        else if([appLocale isEqualToString:@"DG"])   locale = PPSystemInfoLocale_DiegoGarcia;
        else if([appLocale isEqualToString:@"CC"])   locale = PPSystemInfoLocale_CocosKeelingIslands;
        else if([appLocale isEqualToString:@"SM"])   locale = PPSystemInfoLocale_SanMarino;
        else if([appLocale isEqualToString:@"TT"])   locale = PPSystemInfoLocale_TrinidadTobago; 
        else if([appLocale isEqualToString:@"OM"])   locale = PPSystemInfoLocale_Oman; 
        else if([appLocale isEqualToString:@"MX"])   locale = PPSystemInfoLocale_Mexico; 
        else if([appLocale isEqualToString:@"GU"])   locale = PPSystemInfoLocale_Guam; 
        else if([appLocale isEqualToString:@"LB"])   locale = PPSystemInfoLocale_Lebanon; 
        else if([appLocale isEqualToString:@"TV"])   locale = PPSystemInfoLocale_Tuvalu; 
        else if([appLocale isEqualToString:@"AW"])   locale = PPSystemInfoLocale_Aruba; 
        else if([appLocale isEqualToString:@"PS"])   locale = PPSystemInfoLocale_PalestinianTerritories; 
        else if([appLocale isEqualToString:@"BB"])   locale = PPSystemInfoLocale_Barbados; 
        else if([appLocale isEqualToString:@"PG"])   locale = PPSystemInfoLocale_PapuaNewGuinea; 
        else if([appLocale isEqualToString:@"BD"])   locale = PPSystemInfoLocale_Bangladesh; 
        else if([appLocale isEqualToString:@"DK"])   locale = PPSystemInfoLocale_Denmark; 
        else if([appLocale isEqualToString:@"YT"])   locale = PPSystemInfoLocale_Mayotte; 
        else if([appLocale isEqualToString:@"YE"])   locale = PPSystemInfoLocale_Yemen; 
        else if([appLocale isEqualToString:@"ID"])   locale = PPSystemInfoLocale_Indonesia; 
        else if([appLocale isEqualToString:@"GY"])   locale = PPSystemInfoLocale_Guyana; 
        else if([appLocale isEqualToString:@"DM"])   locale = PPSystemInfoLocale_Dominica; 
        else if([appLocale isEqualToString:@"GA"])   locale = PPSystemInfoLocale_Gabon; 
        else if([appLocale isEqualToString:@"VN"])   locale = PPSystemInfoLocale_Vietnam; 
        else if([appLocale isEqualToString:@"CK"])   locale = PPSystemInfoLocale_CookIslands; 
        else if([appLocale isEqualToString:@"BG"])   locale = PPSystemInfoLocale_Bulgaria;

    }while(0);

    return locale;
}


//================================================================================
//
//================================================================================
+ (NSString *)cpuArchitectureName
{
    size_t size;
    sysctlbyname("hw.machine", NULL, &size, NULL, 0);
    char *machine = malloc(size);
    sysctlbyname("hw.machine", machine, &size, NULL, 0);
    NSString *platform = [NSString stringWithCString:machine encoding:NSUTF8StringEncoding];
    free(machine);
    
    return platform;

}
@end
