//
//  PPSyncRecordModel.m
//  
//
//  Created by Mike Shih on 11/11/22.
//  Copyright (c) 2011年 Penpower. All rights reserved.
//

#import "PPSyncRecordModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSyncRecordModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
version                 = version_,
localSyncCompareModel   = localSyncCompareModel_,
remoteSyncCompareModel  = remoteSyncCompareModel_;

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [localSyncCompareModel_     release];
	[remoteSyncCompareModel_    release];
    
	//////////////////////////////////////////////////
	
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Override Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
	return [NSString stringWithFormat:@"%@{version:%lu localSyncCompareModel:%@ remoteSyncCompareModel:%@}",
			[super description],
            (unsigned long)self.version,
			self.localSyncCompareModel, 
			self.remoteSyncCompareModel];
}

//===============================================================================
//
//===============================================================================
- (BOOL)isEqual:(id)object
{
    if(object == nil || [object isKindOfClass:[self class]] == NO)
    {
        return NO;
    }
    
    //////////////////////////////////////////////////

    PPSyncRecordModel *target = (PPSyncRecordModel *)object;

    return (self.version == target.version &&
            [self.localSyncCompareModel isEqual:target.localSyncCompareModel] == YES &&
            [self.remoteSyncCompareModel isEqual:target.remoteSyncCompareModel] == YES);
}

@end
