//
//  PPSyncFieldModel.m
//  
//
//  Created by  Eddie on 2011/3/16.
//  Copyright 2011 Penpower. All rights reserved.
//

#import "PPSyncFieldModel.h"
#import "NSMutableDictionary+NSInteger.h"

@implementation PPSyncFieldModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
type    = type_,
subType = subType_,
value   = value_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//===============================================================================
//
//===============================================================================
- (void)dealloc
{
    [value_ release];

    //////////////////////////////////////////////////
    
    [super dealloc];
}


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(NSZone *)zone
{
    PPSyncFieldModel *syncFieldModel = [[PPSyncFieldModel alloc] init];
    syncFieldModel.value = [[self.value copyWithZone:zone] autorelease];
    syncFieldModel.type = self.type;
    syncFieldModel.subType = self.subType;
    
    return syncFieldModel;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//===============================================================================
// only for dictionary value
//===============================================================================
- (void)setCombinedValueString:(NSString *)valueString withType:(NSInteger)combineType
{
	if([valueString length]==0)
		return;
    
	if(!self.value)
	{
		NSMutableDictionary *dict = [[NSMutableDictionary alloc] init];
		[dict setObject:valueString forIntegerKey:combineType];
        self.value = dict;
        [dict release];
	}
	else if([self.value isKindOfClass:[NSMutableDictionary class]]) 
	{
		NSMutableDictionary *dict = self.value;	
		[dict setObject:valueString forIntegerKey:combineType];
	}	
}


//===============================================================================
// only for dictionary value
//===============================================================================
- (NSString *)combinedValueStringWithType:(NSInteger)combineType
{
    if([self.value isKindOfClass:[NSMutableDictionary class]]) 
    {
        NSMutableDictionary *valueDict = (NSMutableDictionary *)self.value;
        NSString *valueString = [valueDict objectForIntegerKey:combineType];
        
        if(!valueString)
            valueString = @"";
        
        return valueString;
    }
    
    return nil;
}



//===============================================================================
// only for dictionary value
//===============================================================================
- (BOOL)hasCombinedValueWithType:(NSInteger)combineType
{
    if([self.value isKindOfClass:[NSMutableDictionary class]]) 
    {
        NSMutableDictionary *valueDict = (NSMutableDictionary *)self.value;
        NSString *valueString = [valueDict objectForIntegerKey:combineType];
        return (valueString != nil);
    }
    
    return NO;
}


@end
