//
//  PPSyncCardModel.h
//  
//
//  Created by Mike Shih on 13/10/28.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PPSyncCardImageType.h"
#import "PPSyncCompareModel.h"
#import "PPSyncFieldModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSyncCardModel : PPSyncCompareModel


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic, retain, readonly)  NSMutableDictionary *fieldArrayDict;
@property(nonatomic, retain, readonly)  NSMutableDictionary *imageDict;
@property(nonatomic, retain)            NSMutableDictionary *extendedPropertyDict;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithSyncCardModel:(PPSyncCardModel *)syncCardModel;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

// check if having field data
- (BOOL)hasSyncFieldModels;

// get field array by specified type
- (NSMutableArray *)syncFieldArrayWithFieldType:(NSInteger)fieldType;

// get field count by specified type
- (NSInteger)syncFieldCountWithFieldType:(NSInteger)fieldType subType:(NSInteger)subType;

// add field
- (void)addSyncFieldModel:(PPSyncFieldModel *)fieldModel;

// delete field
- (void)removeSyncFieldModel:(PPSyncFieldModel *)fieldModel;

// get field at index
- (PPSyncFieldModel *)syncFieldModelWithFieldType:(NSInteger)fieldType atIndex:(NSInteger)index;

// append fields from other dataModel
- (void)appendFieldsFromSyncCardModel:(PPSyncCardModel *)syncCardModel;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - image Methods

// append image dict from other dataModel
- (void)updateImageDictFromSyncCardModel:(PPSyncCardModel *)syncCardModel;

// set indentify at index
- (void)setImageIdentify:(NSString *)identfiy forIndex:(NSInteger)index;

// get identify at index
- (NSString *)imageIdentifyForIndex:(NSInteger)index;

// has front photo
- (BOOL)hasFrontPhoto;

// has back photo
- (BOOL)hasBackPhoto;

// has card photo
- (BOOL)hasCardPhoto;


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - debug Methods

// dump data
- (void)dumpSyncFieldModels;

@end
