//
//  PPSyncActionModel.m
//  
//
//  Created by Mike Shih on 11/11/22.
//  Copyright (c) 2011年 Penpower. All rights reserved.
//

#import "PPSyncActionModel.h"

@implementation PPSyncActionModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize action                  = action_;
@synthesize localSyncCompareModel   = localSyncCompareModel_;
@synthesize remoteSyncCompareModel  = remoteSyncCompareModel_;
@synthesize target                  = target_;
@synthesize type                    = type_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [localSyncCompareModel_ release];
    localSyncCompareModel_ = nil;
    
    [remoteSyncCompareModel_ release];
    remoteSyncCompareModel_ = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

//================================================================================
//
//================================================================================
- (NSString *)description
{
	return [NSString stringWithFormat:@"%@{action:%lu localSyncCompareModel:%@ remoteSyncCompareModel:%@ target:%lu type:%lu}",
			[super description],
			(unsigned long)self.action,
            self.localSyncCompareModel,
			self.remoteSyncCompareModel,
            (unsigned long)self.target,
            (unsigned long)self.type];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (NSComparisonResult)compare:(PPSyncActionModel *)ppSyncActionModel
{
    NSComparisonResult result = NSOrderedSame;
    
    //(Group<Card,本地<遠端,刪除<新增<更新)
    
    if(self.type==PPSyncType_Group && ppSyncActionModel.type==PPSyncType_Card)
    {
        result = NSOrderedAscending;
    }
    else if(self.type==PPSyncType_Card && ppSyncActionModel.type==PPSyncType_Group)
    {
        result = NSOrderedDescending;
    }
    else
    {
        if(self.target==PPSyncTarget_Local && ppSyncActionModel.target==PPSyncTarget_Remote)
        {
            result = NSOrderedAscending;
        }
        else if(self.target==PPSyncTarget_Remote && ppSyncActionModel.target==PPSyncTarget_Local)
        {
            result = NSOrderedDescending;
        }
        else
        {
            if(self.action<ppSyncActionModel.action)
            {
                result = NSOrderedAscending;
            }
            else if(self.action>ppSyncActionModel.action)
            {
                result = NSOrderedDescending;
            }
        }
    }
	
	return result;
}

@end
