//
//  PPSupportController.h
//  
//
//  Created by Mike on 13/5/9.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#if TARGET_OS_IPHONE
#import "PPMailComposeViewController.h"
#import "UIDevice+DeviceModel.h"
#elif TARGET_OS_OSX
#import "PPMailComposeWindowController.h"
#endif

#import "NSDate+Format.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

// info.plist key
#define PPSupportControllerKey_AppLang          @"PPAppLang"        // 請在info.plist中加入此KEY, type為string，(目前有en，ch，jp，ko，若app沒分版本就用all)
#define PPSupportControllerKey_SupportEMails    @"PPSupportEMails"  // 請在info.plist中加入此KEY, type為array, 目前只放一個email，如果之要後加多個也可以
#define PPSupportControllerKey_OldAppVersion    @"PPOldAppVersion"  // 請在 |NSUserDefaults| 中寫入此key，type為string，用來儲存升級前的app版本
#define PPSupportControllerKey_EmailTitle       @"PPSupportEmailTitle"
#define PPSupportControllerKey_ProductName      @"PPSupportProductName"

// additionalInfo key
extern NSString * const PPSupportControllerAdditionalInfoKey_PrevMessage;   /**< 在手機資訊之前顯示的訊息，type為dictionary，(key，value都為NSString)，顯示格式為 key: value\n*/
extern NSString * const PPSupportControllerAdditionalInfoKey_PostMessage;   /**< 在手機資訊之前顯示的訊息，type為dictionary，(key，value都為NSString)，顯示格式為 key: value\n*/

// LicenseString
extern NSString * const LicenseString_Active;
extern NSString * const LicenseString_NonActive;
extern NSString * const LicenseString_Lite;
extern NSString * const LicenseString_Paid;
extern NSString * const LicenseString_Free;

// default zip password
extern NSString * const PPSupportController_ZipPassword;


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSupportController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class Methods (mail content)

+ (NSString *)osType;
+ (NSString *)deviceModel;
+ (NSString *)systemVersion;
+ (NSString *)mailTitle;
+ (NSString *)mailBodyWithLicense:(NSString *)license additionalInfos:(NSDictionary*)additionalInfos;

#pragma mark - Class Methods

#if TARGET_OS_IPHONE

/**
 * @brief present report mail
 *
 * 用在問題回報，或其他提供使用者與我的聯絡時的email內容
 * 
 * @param viewController reportMail要從哪一個View controller present
 * @param license 輸入目前的app是什麼版，可用字串請參考 LicenseString
 * @param recipients 輸入收件者資料，沒有傳的話會參考 info.plist |PPSupportControllerKey_SupportEMails|中的值
 * @param filePaths 如果有附加檔，在此輸入要附加的檔案路徑，附加後的檔案會刪除
 * @param additionalInfos 附加資訊，mail的前後各加一段app額外附加的資訊，請使用 |additionalInfosDictionaryWithPrevDictionary| 產生的結果來輸入
 * @param delegate 如果要自已收delegate的話，在這邊做
 * @param presetedComplition 在present 完成後會呼叫的block
 *
 * @return 回傳是否成功 present report mail
 *
 */
+ (BOOL)reportMailWithViewController:(UIViewController*)viewController
                             license:(NSString *)license
                          recipients:(NSArray *)recipients
                 attachmentFilePaths:(NSArray *)filePaths
                     additionalInfos:(NSDictionary*)additionalInfos
                            delegate:(id<MFMailComposeViewControllerDelegate>)delegate
                  presetedComplition:(void (^)(void))presetedComplition;

/**
 *
 * 請參考 |reportMailWithViewController:license:recipients:attachmentFilePaths:additionalInfos:delegate:presetedComplition:|
 */
+ (BOOL)reportMailWithViewController:(UIViewController*)viewController
                             license:(NSString *)license
                 attachmentFilePaths:(NSArray *)filePaths
                     additionalInfos:(NSDictionary*)additionalInfos
                            delegate:(id<MFMailComposeViewControllerDelegate>)delegate;

/**
 *
 * 請參考 |reportMailWithViewController:license:recipients:attachmentFilePaths:additionalInfos:delegate:presetedComplition:|
 */
+ (BOOL)reportMailWithViewController:(UIViewController*)viewController
                             license:(NSString *)license
                 attachmentFilePaths:(NSArray *)filePaths
                     additionalInfos:(NSDictionary*)additionalInfos;

/**
 *
 * 請參考 |reportMailWithViewController:license:recipients:attachmentFilePaths:additionalInfos:delegate:presetedComplition:|
 */
+ (BOOL)reportMailWithViewController:(UIViewController *)viewController
                             license:(NSString *)license
                 attachmentFilePaths:(NSArray *)filePaths;
/**
 *
 * 請參考 |reportMailWithViewController:license:recipients:attachmentFilePaths:additionalInfos:delegate:presetedComplition:|
 */
+ (BOOL)reportMailWithViewController:(UIViewController *)viewController
                             license:(NSString *)license
                          recipients:(NSArray *)recipients;

/**
 *
 * 請參考 |reportMailWithViewController:license:attachmentFilePaths:additionalInfos:delegate:presetedComplition:|
 */
+ (BOOL)reportMailWithViewController:(UIViewController *)viewController
                             license:(NSString *)license;


#elif TARGET_OS_OSX

/**
 * @brief present report mail
 *
 * 用在問題回報，或其他提供使用者與我的聯絡時的email內容
 *
 * @param license 輸入目前的app是什麼版，可用字串請參考 LicenseString
 * @param recipients 輸入收件者資料，沒有傳的話會參考 info.plist |PPSupportControllerKey_SupportEMails|中的值
 * @param filePaths 如果有附加檔，在此輸入要附加的檔案路徑，附加後的檔案會刪除
 * @param additionalInfos 附加資訊，mail的前後各加一段app額外附加的資訊，請使用 |additionalInfosDictionaryWithPrevDictionary| 產生的結果來輸入
 *
 * @return 回傳是否成功 present report mail
 *
 */
+ (BOOL)reportMailWithLicense:(NSString *)license
                   recipients:(NSArray *)recipients
          attachmentFilePaths:(NSArray *)filePaths
              additionalInfos:(NSDictionary*)additionalInfos;

/**
 *
 * 請參考 |reportMailWithLicense:attachmentFilePaths:additionalInfos:|
 */
+ (BOOL)reportMailWithLicense:(NSString *)license
                   recipients:(NSArray *)recipients
          attachmentFilePaths:(NSArray *)filePaths;


/**
 *
 * 請參考 |reportMailWithLicense:attachmentFilePaths:additionalInfos:|
 */
+ (BOOL)reportMailWithLicense:(NSString *)license
                   recipients:(NSArray *)recipients;

/**
 *
 * 請參考 |reportMailWithLicense:attachmentFilePaths:additionalInfos:|
 */
+ (BOOL)reportMailWithLicense:(NSString *)license;


#endif

/**
 *
 *  產生一個共用的參數，用在promotion ad的link或more app的link
 */
+ (NSString *)moreAppsURLParamsWithProductName:(NSString *)productName license:(NSString *)license;

/**
 *
 *  產生一個共用的參數，用在promotion ad的link或more app的link
 */
+ (NSString *)moreAppsURLParamsWithLicense:(NSString *)license;


/**
 *
 * 產生一個dictionary，用來做additionalInfos
 * prevDictionary的內容會放在mail 前面，(key，value都為NSString)，顯示格式為 key: value
 * postDictionary的內容會放在mail 後面，(key，value都為NSString)，顯示格式為 key: value
 */
+ (NSDictionary *)additionalInfosDictionaryWithPrevDictionary:(NSDictionary*)prevDictionary andPostDictionary:(NSDictionary*)postDictionary;



/// 檢查版本是否要更新
/// @param updateHandler 回傳 in bg thread
+ (void)checkForUpdateWithHandler:(void(^)(BOOL isUpdateAvailable))updateHandler;






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance System Method

/**
 取得系統ID

 @return 系統ID
 */
+ (NSString *)systemUUID;


/**
 初始化crashlytics
 */
+ (void)initializeCrashlytics;


/**
 模擬crash狀況
 */
+ (void)simulateCrash;

@end
