//
//  PPStorageSpaceSelectViewController.h
//  Pods
//
//  Created by Howard on 2015/8/3.
//
//

#import <UIKit/UIKit.h>

// Define
#import "PPStorageSpaceSelectViewControllerDelegate.h"
#import "PPStorageSpaceSelectViewController+PublicParameterDefine.h"

// Controller
#import "PPViewController.h"
#import "PPCloud_Dropbox.h"
#import "PPCloud_GoogleDrive.h"
#import "PPCloud_iCloud.h"
#import "PPCloud_OneDrive.h"

@interface PPStorageSpaceSelectViewController : PPViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign) id<PPStorageSpaceSelectViewControllerDelegate> delegate;

//設定是否刷新空間資訊 (預設 ViewWillAppear時，會刷新一次就不在刷新)
@property (nonatomic,assign) BOOL                                           needFetchSpaceInformation;

//請使用 PPCloudKey 設定 app_key, app_secretKey
@property (nonatomic,retain) NSDictionary *cloudKeyDictionary;

//空間選擇 The array of @(PPStorageSpaceSelectControllerSpaceType) , 預設全空間 see PPStorageSpaceSelectViewController.PublicParameterDefine;
@property (nonatomic,retain) NSArray *spaceTypeSelectArray;

//欄位高度 (PPStorageSpaceSelectSectionControllerCellHeight=56)
@property (nonatomic,assign) CGFloat tableViewcellHeight;

//視圖標題
@property (nonatomic,copy) NSString *controllerTitle;

//exchange server name
@property (nonatomic,copy) NSString *exchangeServerName;

// 列表 cell 文字 Normal state 顏色
@property (nonatomic,retain) UIColor *tableViewCellNormalTextColor;

// 列表 cell detail 文字 Normal state 顏色
@property (nonatomic,retain) UIColor *tableViewCellNormalDetailTextColor;

// 列表 cell 分隔線顏色
@property (nonatomic,retain) UIColor *tableViewSeperatorColor;

// 列表 cell highlighted state 背景色
@property (nonatomic,retain) UIColor *tableViewCellHighlightedBackgroundColor;

//上方標題列，按鈕 highlighted狀態
@property (nonatomic,retain) UIColor *navigationViewButtonHighlightedBackgroundColor;

//上方標標列，按鈕 image insets
@property (nonatomic,assign) UIEdgeInsets navigationBarButtonImageInsets;






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 清空帳號名稱

 @param spaceType 空間種類
 
 處理方式: 外部進行登入or登出時，帳號名稱要清除，防止顯示錯誤
 */
- (void)cleanAccountNameForSpaceType:(PPStorageSpaceSelectControllerSpaceType)spaceType;

@end
