//
//  PPStorageFileSelectNavigationBarView.m
//
//
//  Created by Howard.Lin on 2014/3/18.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPStorageFileSelectNavigationBarView.h"

// Define
#import "PPStorageFileSelectViewController+ResourceDefine.h"

// Category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPStorageFileSelectNavigationBarView


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    return [self initWithFrame:CGRectZero];
}


//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self  = [super initWithFrame:frame])
    {
        self.style = PPBarViewStyle_CenteredRelative;
        
#ifdef FOR_GIGACARD_VERSION
        self.titleLabel.text = NSLocalizedString(@"MLS_ImportExchangeFile", nil);
#else
        self.titleLabel.text = NSLocalizedString(@"MLS_ImportWorldCardExchangeFile", nil);
#endif
        
        //////////////////////////////////////////////////
        
        _backorDoneButton =  [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                              tag:PPStorageFileSelectNavigationBarViewButtonTag_Back
                                                         delegate:self
                                            normalBackgroundColor:nil
                                       highlightedBackgroundColor:nil
                                                  imageEdgeInsets:UIEdgeInsetsZero] retain];
        
        
        if(_backorDoneButton!=nil)
        {
            [_backorDoneButton addControlEvents:UIControlEventTouchUpInside];
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_backorDoneButton];
            
            if(itemModel!=nil)
            {
                itemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
                itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                [self setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
            }
        }
        
        //////////////////////////////////////////////////
        
        _editButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_editButton!=nil)
        {
            [_editButton setDelegate:self];
            [_editButton setTag:PPStorageFileSelectNavigationBarViewButtonTag_Edit];
            [_editButton addControlEvents:UIControlEventTouchUpInside];
            [_editButton setImageWithName:ImageNamePSFSV_ButtonEdit];
        }
        
        //////////////////////////////////////////////////
        
        _importButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_importButton!=nil)
        {
            [_importButton setDelegate:self];
            [_importButton setTag:PPStorageFileSelectNavigationBarViewButtonTag_Import];
            [_importButton addControlEvents:UIControlEventTouchUpInside];
            [_importButton setImageWithName:ImageNamePSFSV_ButtonImport];
        }
        
        //////////////////////////////////////////////////
        
        if(_editButton!=nil &&
           _importButton!=nil)
        {
            PPBarViewItemModel *editItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_editButton];
            
            if(editItemModel!=nil)
            {
                editItemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
                editItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *importItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_importButton];
            
            if(importItemModel!=nil)
            {
                importItemModel.edgeInsetsForMiniBar = UIEdgeInsetsZero;
                importItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            if(editItemModel!=nil &&
               importItemModel!=nil)
            {
                [self setItemModels:@[editItemModel,importItemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_backorDoneButton removeControlEvents:UIControlEventTouchUpInside];
    [_backorDoneButton removeFromSuperview];
    [_backorDoneButton release];
    _backorDoneButton = nil;
    
    [_editButton removeControlEvents:UIControlEventTouchUpInside];
    [_editButton removeFromSuperview];
    [_editButton release];
    _editButton = nil;
    
    [_importButton removeControlEvents:UIControlEventTouchUpInside];
    [_importButton removeFromSuperview];
    [_importButton release];
    _importButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)setMode:(PPStorageFileSelectNavigationBarViewMode)mode
{
    _mode = mode;
    
    if(self.mode==PPStorageFileSelectNavigationBarViewMode_Edit)
    {
        [self.backorDoneButton setImageWithName:ImageNamePSFSV_ButtonDone];
        
        [self.backorDoneButton setTag:PPStorageFileSelectNavigationBarViewButtonTag_Done];
        
        //////////////////////////////////////////////////
        
        self.importButton.hidden = YES;
        self.editButton.hidden = YES;
    }
    else
    {
        [self.backorDoneButton setImageWithName:ImageNamePPButtonIconForSystemBackImitation];
        
        [self.backorDoneButton setImageWithName:ImageNamePPButtonIconForSystemBackImitation];
        
        [self.backorDoneButton setTag:PPStorageFileSelectNavigationBarViewButtonTag_Back];
        
        //////////////////////////////////////////////////
        
        if(self.mode==PPStorageFileSelectNavigationBarViewMode_SingleChoiceBrowse)
        {
            PPBarViewItemModel * editItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.editButton];
            
            if(editItemModel!=nil)
            {
                editItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                
                //////////////////////////////////////////////////
                
                [self setItemModels:@[editItemModel] forBlockType:PPBarViewBlockType_Right];
            }
        }
        else
        {
            self.editButton.hidden = NO;
            self.importButton.hidden = NO;
        }
    }
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(storageFileSelectNavigationBarView:responderView:controlEvent:)]==YES)
    {
        [self.delegate storageFileSelectNavigationBarView:self
                                            responderView:ppButton
                                             controlEvent:controlEvent];
    }
}


@end

