//
//  PPStorageFileSelectViewController.h
// 
//
//  Created by Howard.Lin on 2014/3/18.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPViewController.h"

// Define
#import "PPStorageFileSelectViewController+PublicParameterDefine.h"
#import "PPStorageFielSelectViewControllerDatasource.h"
#import "PPStorageFileSelectViewControllerDelegate.h"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPStorageFileSelectViewController : PPViewController

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,assign)   id<PPStorageFielSelectViewControllerDatasource> datasource;
@property (nonatomic,assign)   id<PPStorageFileSelectViewControllerDelegate>   delegate;
@property (nonatomic,retain)   id                                              userInfo;

//解析第三方空間
@property (nonatomic,assign)   PPStorageFileSelectViewControllerSpaceType      storageFileSelectViewControllerSpaceType;

//解析檔案副檔名. The array of extensionFile, ex @[@"wcxf",@"vcf"], 順序即顯示順序
@property (nonatomic,retain)   NSArray                                         *extensionFileNameArray;

//section title. The dictionary of @{ @"wcxf": @"DisplayName" };
@property (nonatomic,retain)   NSDictionary                                    *sectionTitleDictionary;

//預設檔案路徑. 不給即為該空間 root folder
@property (nonatomic,copy)     NSString                                        *defaultRootFilePath;

//視圖標題
@property (nonatomic,copy)     NSString                                        *controllerTitle;

//tableView tableheader 文字
@property (nonatomic,copy)     NSString                                        *headerTitleLabelText;

//多選
@property (nonatomic,assign)   BOOL                                            multiSelection;

//隱藏back鍵
@property (nonatomic,assign)   BOOL                                            hidenBackButton;

//自動下載
@property (nonatomic,assign)   BOOL                                            autoDownload;

//cell欄位高度
@property (nonatomic,assign)   CGFloat                                         tableViewCellHeight;

//上方列標題高度
@property (nonatomic,assign)   CGFloat                                         headerTitleLabelHeight;

//上方按鈕 Normal state 按鈕文字顏色 (default whiteColor)
@property (nonatomic,retain)   UIColor                                         *navigationViewButtonNormalTitleColor;

//上方按鈕 Highlighted state 按鈕文字顏色 (default whiteColor)
@property (nonatomic,retain)   UIColor                                         *navigationViewButtonHighlightedTitleColor;

//上方工具列按鈕，highlighted狀態下的背景顏色
@property (nonatomic,retain)   UIColor                                         *navigationViewButtonHighlightedBackgroundColor;

//上方工具列按鈕，圖像的edgeInsets
@property (nonatomic,assign)   UIEdgeInsets                                    navigationViewButtonImageEdgeInsets;

// 列表 cell 文字 Normal state 顏色
@property (nonatomic,retain) UIColor *tableViewCellNormalTextColor;

// 列表 cell detail 文字 Normal state 顏色
@property (nonatomic,retain) UIColor *tableViewCellNormalDetailTextColor;

// 列表 cell 分隔線顏色
@property (nonatomic,retain) UIColor *tableViewSeperatorColor;

// 列表 cell highlighted state 背景色
@property (nonatomic,retain) UIColor *tableViewCellHighlightedBackgroundColor;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)showCancelBusyView:(BOOL)show withSuperView:(UIView *)superView showButton:(BOOL)showButton;

/**
 *  更新檔案列表，刷新表單
 */
- (void)fetchSpaceFileListAndReloadTable;


/**
 * 刪除所有本機端選擇檔案
 */
- (void)deleteAllLocalSelectFile;

@end
