//
//  PPStorageFileFetch_iCloud.m
//  Pods
//
//  Created by Howard on 2015/8/17.
//
//

#import "PPStorageFileFetch_iCloud.h"
#import "PPCloud_iCloud.h"

@implementation PPStorageFileFetch_iCloud

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance method

//================================================================================
//
//================================================================================
- (BOOL)fetchSectinoModels
{
    return [PPCloudController loadMetadata:self.defaultFilePath
                                  delegate:self
                                  userInfo:nil
                                cloudClass:[PPCloud_iCloud class]];
}


//================================================================================
//
//================================================================================
- (void)downloadFileWithPath:(NSString *)path fileID:(NSString *)fileID useinfo:(id)userinfo
{
    NSString *intoPath = [[PPPathController tempDirectory] stringByAppendingString:[NSString stringWithFormat:@"%@",[path lastPathComponent]]];
    
    [PPCloudController loadFileFromPath:path
                               orFileID:nil
                               intoPath:intoPath
                               delegate:self
                               userInfo:userinfo
                             cloudClass:[PPCloud_iCloud class]];
}


//================================================================================
//
//================================================================================
- (void)deleteFileFromPath:(NSString *)path userInfo:(id)userInfo
{
    [PPCloudController deletePath:path
                         delegate:self
                         userInfo:userInfo
                       cloudClass:[PPCloud_iCloud class]];
}

@end
