//
//  ContentClickView.m
//  Pods
//
//  Created by Andrew on 2015/5/4.
//  Copyright (c) 2015年 eddie. All rights reserved.
//

#import "ContentClickView.h"
#import "UIView+Appearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Constant

static CGFloat    ContentClickView_ContentClickViewAlpha    = 0.5;
static NSUInteger ContentClickView_ContentTableCornerRadius = 5.0;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ContentClickView Implementation

@implementation ContentClickView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame])
    {
        do
        {
            self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:ContentClickView_ContentClickViewAlpha];
            
            //////////////////////////////////////////////////
            // 創建呈現內容清單的tableView
            
            _contentTableView = [[UITableView alloc] init];
            if (self.contentTableView==nil)
            {
                [self dealloc];
                self = nil;
                break;
            }
            
            if ([[[UIDevice currentDevice] systemVersion] floatValue]>=9.0)
            {
                //!! 取消內縮，使iPad顯示正常
                self.contentTableView.cellLayoutMarginsFollowReadableWidth = NO;
            }
            
            [self.contentTableView setCornerRadius:ContentClickView_ContentTableCornerRadius];
            [self addSubview:self.contentTableView];
            
            //////////////////////////////////////////////////
            // 創建呈現內容TableView上方的Title Label
            
            _tableTitleLabel = [[UILabel alloc] init];
            if (self.tableTitleLabel==nil)
            {
                [self dealloc];
                self = nil;
                break;
            }
            
            self.tableTitleLabel.textAlignment = NSTextAlignmentCenter;
            [self addSubview:self.tableTitleLabel];
            
        } while (0);
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [self.contentTableView removeFromSuperview];
    self.contentTableView.dataSource = nil;
    self.contentTableView.delegate = nil;
    self.contentTableView = nil;
    
    [self.tableTitleLabel removeFromSuperview];
    self.tableTitleLabel = nil;
    
    self.delegate = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}

@end
