//
//  PPSectionModel.m
//  
//
//  Created by Mike on 13/5/28.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPSectionModel.h"

@implementation PPSectionModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
rowModels   = rowModels_,
section     = section_,
title       = title_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
	if((self = [super init]))
	{
        rowModels_  = [[NSMutableArray alloc] init];
	}
	
	return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [rowModels_ release];
    rowModels_ = nil;
    
    [title_ release];
	title_ = nil;
    
    //////////////////////////////////////////////////

	[super dealloc];
}


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(NSZone *)zone
{
    PPSectionModel *sectionModel = [[PPSectionModel alloc] init];
    
    sectionModel.section = self.section;
    sectionModel.title = [[self.title copyWithZone:zone] autorelease];
    
    [rowModels_ release];
    rowModels_ = [self.rowModels copyWithZone:zone];
    
    return sectionModel;
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (NSComparisonResult)compare:(PPSectionModel *)sectionModel
{
    NSComparisonResult result = NSOrderedSame;
    
	if(self.section<sectionModel.section)
	{
		result =  NSOrderedAscending;
	}
	else if(self.section>sectionModel.section)
	{
		result =  NSOrderedDescending;
	}
	
	return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (PPSectionModel *)sectionModelWithSection:(NSInteger)section title:(NSString *)title rowModels:(NSArray *)rowModels
{
    PPSectionModel *sectionModel = [[[PPSectionModel alloc] init] autorelease];
    
    if(sectionModel!=nil)
    {
        sectionModel.section    = section;
        sectionModel.title      = title;

        if(rowModels!=nil)
        {
            [sectionModel.rowModels addObjectsFromArray:rowModels];
        }
    }
    
    return sectionModel;
}

@end
