//
//  PPRowModel.m
//  
//
//  Created by Mike on 13/5/28.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPRowModel.h"

@implementation PPRowModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
row         = row_,
text        = text_,
detailText  = detailText_,
object      = object_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [text_ release];
    text_ = nil;

    [detailText_ release];
    detailText_ = nil;
    
    [object_ release];
    object_ = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}


//==============================================================================
//
//==============================================================================
- (id)copyWithZone:(nullable NSZone *)zone;
{
    PPRowModel *rowModel = [[PPRowModel alloc] init];
    
    rowModel.row = self.row;
    rowModel.text = [[self.text copyWithZone:zone] autorelease];
    rowModel.detailText = [[self.detailText copyWithZone:zone] autorelease];
    rowModel.object = [[self.object copyWithZone:zone] autorelease];
    
    return rowModel;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (NSComparisonResult)compare:(PPRowModel *)rowModel
{
    NSComparisonResult result = NSOrderedSame;
    
	if(self.row<rowModel.row)
	{
		result =  NSOrderedAscending;
	}
	else if(self.row>rowModel.row)
	{
		result =  NSOrderedDescending;
	}
	
	return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (PPRowModel *)rowModelWithRow:(NSInteger)row text:(NSString *)text detailText:(NSString *)detailText object:(id)object
{
    PPRowModel *rowModel = [[[PPRowModel alloc] init] autorelease];
    
    if(rowModel!=nil)
    {
        rowModel.row        = row;
        rowModel.text       = text;
        rowModel.detailText = detailText;
        rowModel.object     = object;
    }
    
    return rowModel;
}

@end
