//
//  PPSectionController.m
//  
//
//  Created by Mike on 13/5/29.
//  Copyright (c) 2013年 Mike.Shih. All rights reserved.
//

#import "PPSectionController.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPSectionController ()
@property(nonatomic, retain) NSMutableArray  *sectionModelsForDefault;
@property(nonatomic, retain) NSMutableArray  *sectionModelsForSearching;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPSectionController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
	if((self = [super init]))
	{
        _sectionModelsForDefault = [[NSMutableArray alloc] init];
        _sectionModelsForSearching = [[NSMutableArray alloc] init];
	}
	
	return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [self.sectionModelsForDefault removeAllObjects];
    self.sectionModelsForDefault = nil;
    
    [self.sectionModelsForSearching removeAllObjects];
    self.sectionModelsForSearching = nil;
    
    //////////////////////////////////////////////////

	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (NSMutableArray *)sectionModelsForSearching:(BOOL)searching
{
    return ((searching==YES)?self.sectionModelsForSearching:self.sectionModelsForDefault);
}

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsForSearching:(BOOL)searching
{
    NSInteger numberOfSections = 0;
    
    do
    {
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        numberOfSections = [sectionModels count];
        
    }while(0);
    
    return numberOfSections;
}

//================================================================================
//
//================================================================================
- (NSInteger)sectionForSectionIndexTitle:(NSString *)title forSearching:(BOOL)searching
{
    NSInteger section = PPSectionNULL;
    
    do
    {
        if(title==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(PPSectionModel *sectionModel in sectionModels)
        {
            if([sectionModel.title isEqualToString:title]==YES)
            {
                section = [sectionModels indexOfObject:sectionModel];
                
                break;
            }
        }
        
    }while(0);
	
	return section;
}

//================================================================================
//
//================================================================================
- (NSString *)titleForHeaderInSection:(NSInteger)section forSearching:(BOOL)searching
{
    NSString *title = nil;
    
    do
    {
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil || [sectionModels count]<=section)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPSectionModel *sectionModel = [sectionModels objectAtIndex:section];
		if(sectionModel==nil)
		{
            break;
		}
        
        //////////////////////////////////////////////////
        
        title = sectionModel.title;
        
    }while(0);
    
    return title;
}

//================================================================================
//
//================================================================================
- (PPSectionHeaderView *)viewForHeaderInSection:(NSInteger)section forSearching:(BOOL)searching
{
    PPSectionHeaderView *sectionHeaderView = [[[PPSectionHeaderView alloc] init] autorelease];
    if(sectionHeaderView!=nil)
    {
        sectionHeaderView.textLabel.text = [self titleForHeaderInSection:section forSearching:searching];
    }
    
    return sectionHeaderView;
}

//================================================================================
//
//================================================================================
- (NSInteger)numberOfRowsInSection:(NSInteger)section forSearching:(BOOL)searching
{
    NSInteger numberOfRowsInSection = 0;
    
    do
    {
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil || [sectionModels count]<=section)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPSectionModel *sectionModel = [sectionModels objectAtIndex:section];
		if(sectionModel==nil || sectionModel.rowModels==nil)
		{
            break;
		}
        
        //////////////////////////////////////////////////
        
        numberOfRowsInSection = [sectionModel.rowModels count];
        
    }while(0);
    
    return numberOfRowsInSection;
}

//================================================================================
//
//================================================================================
- (NSUInteger)rowObjectsCountForSearching:(BOOL)searching
{
    NSUInteger rowObjectsCount = 0;
    
    do
    {
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(PPSectionModel *sectionModel in sectionModels)
        {
            rowObjectsCount += [sectionModel.rowModels count];
        }
        
    }while(0);
    
    return rowObjectsCount;
}

//================================================================================
//
//================================================================================
- (PPRowModel *)rowModelAtIndex:(NSUInteger)index forSearching:(BOOL)searching
{
    PPRowModel *rowModel = nil;
    
    do
    {
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(PPSectionModel *sectionModel in sectionModels)
        {
            if([sectionModel.rowModels count]>index)
            {
                rowModel = [sectionModel.rowModels objectAtIndex:index];
                break;
            }
            else
            {
                index -= [sectionModel.rowModels count];
            }
        }
        
    }while(0);
    
    return rowModel;
}

//================================================================================
//
//================================================================================
- (PPRowModel *)rowModelAtIndexPath:(NSIndexPath *)indexPath forSearching:(BOOL)searching
{
    PPRowModel *rowModel = nil;
    
    do
    {
        if(indexPath==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSMutableArray *sectionModels = [self sectionModelsForSearching:searching];
        if(sectionModels==nil || [sectionModels count]<=indexPath.section)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        PPSectionModel *sectionModel = [sectionModels objectAtIndex:indexPath.section];
        if(sectionModel==nil || sectionModel.rowModels==nil || [sectionModel.rowModels count]<=indexPath.row)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        rowModel = [sectionModel.rowModels objectAtIndex:indexPath.row];
        
    }while(0);
    
    return rowModel;
}


//================================================================================
//
//================================================================================
- (NSIndexPath *)indexPathForRowModel:(PPRowModel *)rowModel forSearching:(BOOL)searching
{
    NSIndexPath *indexPath = nil;
    
    do
    {
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(PPSectionModel *sectionModel in [self sectionModelsForSearching:searching])
        {
            for(PPRowModel *existRowModel in sectionModel.rowModels)
            {
                if(existRowModel==rowModel)
                {
                    NSUInteger section = [[self sectionModelsForSearching:searching] indexOfObject:sectionModel];
                    NSUInteger row     = [sectionModel.rowModels indexOfObject:rowModel];
                    
                    indexPath = [NSIndexPath indexPathForRow:row inSection:section];
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(indexPath!=nil)
            {
                break;
            }
        }
    } while (0);
    
    return indexPath;
}


//================================================================================
//
//================================================================================
- (void)replaceSectionModels:(NSArray *)sectionModels forSearching:(BOOL)searching
{
    if(searching == YES)
    {
        self.sectionModelsForSearching = nil;
        
        if([sectionModels count])
        {
            self.sectionModelsForSearching = [NSMutableArray arrayWithArray:sectionModels];
        }
    }
    else
    {
        self.sectionModelsForDefault = nil;
        
        if([sectionModels count])
        {
            self.sectionModelsForDefault = [NSMutableArray arrayWithArray:sectionModels];
        }
    }
}


//================================================================================
//
//================================================================================
- (PPRowModel *)copyRowModelAtIndexPath:(NSIndexPath *)indexPath forSearching:(BOOL)searching
{
    return [[self rowModelAtIndexPath:indexPath forSearching:searching] retain];
}


@end
