//
//  PPQRCodeCaptureOperation.m
//  
//
//  Created by Howard.Lin on 2014/2/27.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

//#define PPLogMacro

#import "PPQRCodeCaptureOperation.h"
#import "PPLogController.h"
#import "UIImage+BITMAPPTR.h"
#import "libqrcode.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPQRCodeCaptureOperation()

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPQRCodeCaptureOperation

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creaing, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.sourceQRCodeImage = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)main
{
    PPLog(PPLogControllerMask_Custom,@"%s Start QRCode Recognition",__FUNCTION__);

    NSString* resultStr = nil;
    
    if(self.sourceQRCodeImage!=nil)
    {
        char szOutputBuffer[2048] = {0};
        
        BITMAPPTR oneBitmapPtr;
        memset(&oneBitmapPtr, 0, sizeof(BITMAPPTR));
        
        //////////////////////////////////////////////////
        
        //看QR辨識的圖對不對
#ifdef PPLogMacro
        
        NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
        
        // Save image.
        [UIImagePNGRepresentation(self.sourceQRCodeImage) writeToFile:[[paths objectAtIndex:0] stringByAppendingPathComponent:@"clip.png"] atomically:YES];
    
#endif
        
        //////////////////////////////////////////////////
        
        BOOL result = [UIImage createBitmapPTR:&oneBitmapPtr image:self.sourceQRCodeImage];
        
        PPLog(PPLogControllerMask_Custom,@"%s createBitmapPTR result:%d",__FUNCTION__,result);
        
        //////////////////////////////////////////////////
        
        if(result ==YES)
        {
#ifdef PPLogMacro
            NSTimeInterval beforeTime = [NSDate timeIntervalSinceReferenceDate];
#endif
            PPQRError qrError = deqrcode(oneBitmapPtr, szOutputBuffer, YES,0);
            
            PPLog(PPLogControllerMask_Custom,@"%s spentTime:(%.6f sec)",__FUNCTION__,[NSDate timeIntervalSinceReferenceDate]-beforeTime);
            
            PPLog(PPLogControllerMask_Custom,@"%s qrError:%d",__FUNCTION__,qrError);
            
            if(qrError == PPQRError_Success)
            {
                resultStr = [[NSString alloc] initWithCString:szOutputBuffer encoding:NSUTF8StringEncoding];
                
                //////////////////////////////////////////////////
                
#ifdef PPLogMacro
                
                NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
                
                // Save image.
                [UIImagePNGRepresentation(self.sourceQRCodeImage) writeToFile:[[paths objectAtIndex:0] stringByAppendingPathComponent:@"successful.png"] atomically:YES];
                
#endif

            }
            
            if([UIImage releaseBitmapPTR:&oneBitmapPtr]==NO)
            {
                PPLog(PPLogControllerMask_Custom,@"BITMAPPTR release fail");
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    PPLog(PPLogControllerMask_Custom,@"%s Finish QRCode Recognition",__FUNCTION__);
    
    if (self.isCancelled == NO)
    {
        // !! eddie: 不要用performSelector，有發生過operationQueue結束後selector才被呼叫導致當機的問題。
//        [self performSelectorOnMainThread:@selector(mainThreadSendQRCodeString:) withObject:resultStr waitUntilDone:NO];
        
        if([self.delegate respondsToSelector:@selector(ppQRCodeCaptureOperation:withQRCodeString:)]==YES)
        {
            [self.delegate ppQRCodeCaptureOperation:self
                                   withQRCodeString:resultStr];
        }
    }
    
    //////////////////////////////////////////////////

    if(resultStr!=nil)
    {
        [resultStr release];
    }
}

@end
