//
//  PPPopoverController.m
//  
//
//  Created by Mike on 13/5/13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPPopoverController.h"

static NSMutableArray *popoverControllers = nil;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPPopoverController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithContentViewController:(UIViewController *)viewController
{
	if((self = [super initWithContentViewController:viewController]))
	{
        if(popoverControllers==nil) 
        {
            popoverControllers = [[NSMutableArray alloc] init];
        }
        else 
        {
            [popoverControllers retain];
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        [popoverControllers addObject:self];
	}
	
	return self;
}

- (void)dealloc 
{
    [popoverControllers removeObject:self];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if([popoverControllers retainCount]==1) 
	{
		[popoverControllers release];
		popoverControllers = nil;
	}
	else 
	{
		[popoverControllers release];
	}
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (BOOL)isVisible
{
    BOOL isVisible = NO;
    
    if(popoverControllers!=nil) 
    {
        for(PPPopoverController *ppPopoverController in popoverControllers) 
        {
            if(ppPopoverController.isPopoverVisible==YES) 
            {
                isVisible = YES;
                break;
            }
        }
    }
    
    return isVisible;
}

@end
