//
//  PPPathController.m
//  
//
//  Created by Mike on 13/5/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPPathController.h"

@implementation PPPathController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (NSString *)cachesDirectory
{
    NSString *cachesDirectory = nil;
    
    do
    {
        NSArray *paths = NSSearchPathForDirectoriesInDomains(NSCachesDirectory, NSUserDomainMask, YES);
        if(paths==nil || [paths count]==0)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        cachesDirectory = [paths objectAtIndex:0];
        
    }while(0);
    
    return cachesDirectory;
}

+ (NSString *)documentsDirectory
{
    NSString *documentsDirectory = nil;
    
    do
    {
        NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
        if(paths==nil || [paths count]==0)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        documentsDirectory = [paths objectAtIndex:0];
        
    }while(0);
    
    return documentsDirectory;
}

+ (NSString *)homeDirectory
{
    return NSHomeDirectory();
}

+ (NSString *)libraryDirectory
{
    NSString *libraryDirectory = nil;
    
    do
    {
        NSArray *paths = NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES);
        if(paths==nil || [paths count]==0)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        libraryDirectory = [paths objectAtIndex:0];
        
    }while(0);
    
    return libraryDirectory;
}

+ (NSString *)tempDirectory
{
    return NSTemporaryDirectory();
}

@end
