//
//  PPMessageComposeViewController.m
//  
//
//  Created by Mike on 13/5/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPMessageComposeViewController.h"



static NSMutableDictionary *staticMessageComposeStyleDictionary = nil;


NSString * const PPMessageComposeStyle_NavigationBarTitleColor       = @"PPMessageComposeStyle_NavigationBarTitleColor";
NSString * const PPMessageComposeStyle_NavigationBarButtonTitleColor = @"PPMessageComposeStyle_NavigationBarButtonTitleColor";


//////////////////////////////////////////////////

@implementation PPMessageComposeViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize ppInterfaceOrientationController = ppInterfaceOrientationController_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//==============================================================================
//
//==============================================================================
- (id)init
{
	if((self=[super init]))
	{	
        self.messageComposeDelegate = self;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
		ppInterfaceOrientationController_ = [[PPInterfaceOrientationController alloc] init];
        
        //////////////////////////////////////////////////
        //  設定style
        UIColor *titleColor = [staticMessageComposeStyleDictionary objectForKey:PPMessageComposeStyle_NavigationBarTitleColor];
        if(titleColor)
        {
            [[self navigationBar] setTitleTextAttributes:@{NSForegroundColorAttributeName:titleColor}];
        }
        
        
        UIColor *buttonTitleColor = [staticMessageComposeStyleDictionary objectForKey:PPMessageComposeStyle_NavigationBarButtonTitleColor];
        if(buttonTitleColor)
        {
            [[self navigationBar] setTintColor:buttonTitleColor];
            [[self navigationBar] setTranslucent:NO];
        }
	}
	
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
	[ppInterfaceOrientationController_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events


//==============================================================================
//
//==============================================================================
- (UIInterfaceOrientationMask)supportedInterfaceOrientations
{
    return [self.ppInterfaceOrientationController supportedInterfaceOrientations];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - MFMessageComposeViewController


//==============================================================================
//
//==============================================================================
- (void)messageComposeViewController:(MFMessageComposeViewController *)controller didFinishWithResult:(MessageComposeResult)result
{
    [controller dismissViewControllerAnimated:YES completion:nil];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - styling methods


//==============================================================================
//
//==============================================================================
+ (void)setNavigationBarTitleColor:(UIColor *)titleColor
                  buttonTitleColor:(UIColor *)buttonTitleColor
{
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        staticMessageComposeStyleDictionary = [[NSMutableDictionary alloc] init];
    });
    
    if (titleColor)
    {
        [staticMessageComposeStyleDictionary setObject:titleColor forKey:PPMessageComposeStyle_NavigationBarTitleColor];
    }
    
    if (buttonTitleColor)
    {
        [staticMessageComposeStyleDictionary setObject:buttonTitleColor forKey:PPMessageComposeStyle_NavigationBarButtonTitleColor];
    }
}

@end
