//
//  WCTMatomoController.h
//

#import <Foundation/Foundation.h>
#import "PPMatomoController.h"


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Enum

/// 主要功能
typedef NS_ENUM(NSUInteger, WCTMatomoController_Feature)
{
    WCTMatomoController_Feature_None = 0,
    WCTMatomoController_Feature_Add,          // 新增名片 (張數)
    WCTMatomoController_Feature_ManualShare,  // 手動分享給同事 (次數)
    WCTMatomoController_Feature_Download,     // 下載 (次數)
    WCTMatomoController_Feature_Import,       // 匯入 (張數)
    WCTMatomoController_Feature_Export,       // 匯出 (次數)
    WCTMatomoController_Feature_Email,
    WCTMatomoController_Feature_Skype,
    WCTMatomoController_Feature_Map,
    WCTMatomoController_Feature_Settings,
};

/// 下載來源
typedef NS_ENUM(NSUInteger, WCTMatomoController_DownloadSource)
{
    WCTMatomoController_DownloadSource_None = 0,
    WCTMatomoController_DownloadSource_Notification,
    WCTMatomoController_DownloadSource_SharedList,
};

/// 匯出對象
typedef NS_ENUM(NSUInteger, WCTMatomoController_ExportTarget)
{
    WCTMatomoController_ExportTarget_None = 0,
    WCTMatomoController_ExportTarget_Outlook,
    WCTMatomoController_ExportTarget_CSV,
    WCTMatomoController_ExportTarget_VCF,
    WCTMatomoController_ExportTarget_SalesforceContact,
    WCTMatomoController_ExportTarget_SalesforceLead,
};

/// 設定項目
typedef NS_ENUM(NSUInteger, WCTMatomoController_SettingsItem)
{
    WCTMatomoController_SettingsItem_None = 0,
    WCTMatomoController_SettingsItem_AutoShare,
    WCTMatomoController_SettingsItem_ManualShare,
    WCTMatomoController_SettingsItem_SalesforceAutoSync,
    WCTMatomoController_SettingsItem_SalesforceManualExport,
};


////////////////////////////////////////////////////////////////////////////////////////////////////

@interface WCTMatomoController : NSObject

/**
 Send common feature log

 @param feature One of WCTMatomoController_Feature, except following items:
    WCTMatomoController_Feature_Export
    WCTMatomoController_Feature_Salesforce
 */
+ (void)sendLogWithFeature:(WCTMatomoController_Feature)feature;


/**
 Send download log

 @param downloadSource One of WCTMatomoController_DownloadSource items
 */
+ (void)sendLogWithDownloadSource:(WCTMatomoController_DownloadSource)downloadSource;


/**
 Send export log

 @param exportTarget One of WCTMatomoController_ExportTarget item
 */
+ (void)sendLogWithExportTarget:(WCTMatomoController_ExportTarget)exportTarget;


/**
 Send settings log

 @param settingsItem One of WCTMatomoController_SettingsItem item
 */
+ (void)sendLogWithSettingsItem:(WCTMatomoController_SettingsItem)settingsItem;

@end
