//
//  PPMatomoController.m
//
//  Created by duke.kuo on 2018/9/11.
//

#import "PPMatomoController.h"
#import "PPLogControllerExtension.h"
#import <sys/sysctl.h>


NSString *g_testServerAddress = nil;
NSInteger g_testServerIDSite = 0;

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *const PPMatomoController_DefaultServerAddress = @"matomo.penpower.net";
NSString *const PPMatomoController_URLTemplate = @"http://%@/piwik.php?%@";
NSString *const PPMatomoController_QueryTemplate = @"idsite=%ld&rec=%ld&apiv=%ld&uid=%@&res=%@&lang=%@&url=%@";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPMatomoController

//================================================================================
//
//================================================================================
+ (void)setTestServerWithAddress:(NSString *)address idSite:(NSInteger)idSite
{
    g_testServerIDSite = idSite;
    
    if(g_testServerAddress != nil)
    {
        [g_testServerAddress release];
        g_testServerAddress = nil;
    }
    
    if([address length] > 0)
    {
        g_testServerAddress = [[NSString alloc] initWithString:address];
    }
}


//================================================================================
//
//================================================================================
+ (void)sendMatomoRequestWithIDSite:(NSInteger)idSite
                             record:(NSInteger)record
                          apiverion:(NSInteger)apiversion
                                uid:(NSString *)uid
                   screenResolution:(CGSize)resolution
                           language:(NSString *)language
                                url:(NSString *)url
{
    if(g_testServerIDSite != 0)
    {
        idSite = g_testServerIDSite;
    }
    
    language = [language stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLUserAllowedCharacterSet]];
    uid = [uid stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLUserAllowedCharacterSet]];
    url = [url stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLUserAllowedCharacterSet]];
    
    NSString *resolutionString = [NSString stringWithFormat:@"%ldx%ld", (long)resolution.width, (long)resolution.height];
    resolutionString = [resolutionString stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLUserAllowedCharacterSet]];
    
    NSString *queryURLString = [NSString stringWithFormat:PPMatomoController_QueryTemplate,
                                (long)idSite,
                                (long)record,
                                (long)apiversion,
                                uid,
                                resolutionString,
                                language,
                                url];
    
    NSString *address = nil;
    
    if([g_testServerAddress length] > 0)
    {
        // 有指定測試server位址
        address = g_testServerAddress;
    }
    else
    {
        // 正式server位址
        address = PPMatomoController_DefaultServerAddress;
    }
    
    NSString *urlString = [NSString stringWithFormat:PPMatomoController_URLTemplate, address, queryURLString];
    NSURL *requestURL = [NSURL URLWithString:urlString];

    
    //////////////////////////////////////////////////
    // 填入顯示裝置型號和作業系統所需資料

#if TARGET_OS_IPHONE
    
    NSString *platform = @"IOS";
    NSArray *infos = [[self systemInfoString:"hw.machine"] componentsSeparatedByString:@"."];
    NSString *hardware = infos[0];

#elif TARGET_OS_OSX
    
    NSString *platform = @"MAC";
    
    // !! mac的hardware版本是無效的，顯示的裝置型號都是通用桌上型電腦。
//    NSArray *infos = [[self systemInfoString:"hw.model"] componentsSeparatedByString:@"."];
    NSString *hardware  = @"macintosh";
    
#endif

    NSOperatingSystemVersion ver = [[NSProcessInfo processInfo] operatingSystemVersion];
    NSString *os = [NSString stringWithFormat:@"%td.%td.%td", ver.majorVersion, ver.minorVersion, ver.patchVersion];
    NSString *userAgentContent = [NSString stringWithFormat:@"Mozilla/5.0 (%@; %@ %@)", hardware, platform, os];
    
    //test
//    userAgentContent = @"Mozilla/5.0 (iPhone; CPU iPhone OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1";
    
    
    //////////////////////////////////////////////////
    // 發送 (舊方法sendSynchronousRequest已經deprecated)
    
//    NSMutableURLRequest* request = [[[NSMutableURLRequest alloc] initWithURL:requestURL] autorelease];
//
//    [request setValue:userAgentContent forHTTPHeaderField:@"User-Agent"];
//
//    NSURLResponse* response = nil;
//    NSError* error = nil;
//
//    [NSURLConnection sendSynchronousRequest:request returningResponse:&response error:&error];
    
    
    //////////////////////////////////////////////////
    // 發送

    NSURLSessionConfiguration *config = [NSURLSessionConfiguration defaultSessionConfiguration];
    config.HTTPAdditionalHeaders = @{@"User-Agent":userAgentContent};

    NSURLSession *session = [NSURLSession sessionWithConfiguration:config];
    NSURLSessionDataTask *task = [session dataTaskWithURL:requestURL completionHandler:^(NSData * _Nullable data, NSURLResponse * _Nullable response, NSError * _Nullable error) {
#ifdef DEBUG
        NSLog(@"task complete: response:%@, error:%@", response, error);
#endif
    }];
    
    [task resume];
}


//================================================================================
//
//================================================================================
+ (void)sendMatomoRequestWithUrl:(NSString *)URL
{
    // MARK: idSite從podspec中的定義值取得
#if defined(ID_SITE)
    NSInteger idSite = ID_SITE;
#else
    NSInteger idSite = 0;
#endif
    
    NSInteger record = 1;
    NSInteger apiversion = 1;
    NSString *uid = [self systemUUID];
    NSString *language = [[NSLocale preferredLanguages] objectAtIndex:0];

    
#ifdef __IPHONE_OS_VERSION_MIN_REQUIRED
    CGSize resolution = [[UIScreen mainScreen] bounds].size;
#else
    CGSize resolution = [[NSScreen mainScreen] frame].size;
#endif
    
    [self sendMatomoRequestWithIDSite:idSite
                               record:record
                            apiverion:apiversion
                                  uid:uid
                     screenResolution:resolution
                             language:language
                                  url:URL];
}


//==============================================================================
//
//==============================================================================
+ (NSString *)systemUUID
{
#if TARGET_OS_IPHONE
    
    UIDevice *currentDevice      = [UIDevice currentDevice];
    if([currentDevice respondsToSelector:@selector(identifierForVendor)])
    {
        return [[[UIDevice currentDevice] identifierForVendor] UUIDString];
    }
    
    return nil;
    
#elif TARGET_OS_OSX
    
    io_service_t platformExpert = IOServiceGetMatchingService(kIOMasterPortDefault,IOServiceMatching("IOPlatformExpertDevice"));
    if (!platformExpert)
        return nil;
    
    CFTypeRef serialNumberAsCFString = IORegistryEntryCreateCFProperty(platformExpert,CFSTR(kIOPlatformUUIDKey),kCFAllocatorDefault, 0);
    IOObjectRelease(platformExpert);
    
    if (!serialNumberAsCFString)
        return nil;
    
    NSString *uuid = [NSString stringWithString:(__bridge NSString *)(serialNumberAsCFString)];
    CFRelease(serialNumberAsCFString);
    return uuid;
    
#endif
    
}


//================================================================================
//
//================================================================================
+ (NSString *)systemInfoString:(const char *)attributeName
{
    size_t size;
    sysctlbyname(attributeName, NULL, &size, NULL, 0);
    char* attributeValue = (char*)malloc(size);
    int err = sysctlbyname(attributeName, attributeValue, &size, NULL, 0);
    if(err != 0)
    {
        free(attributeValue);
        return nil;
    }
    NSString* vs = [NSString stringWithUTF8String:attributeValue];
    free(attributeValue);
    return vs;
}

@end
