//
//  PPMakeVirtualCardController.m
//
//  Created by Howard.Lin on 14/1/17.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPMakeVirtualCardController.h"
#import <CoreText/CoreText.h>
#import "NSString+Additions.h"
#import "NSString+UTF32.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
#if TARGET_OS_IPHONE

#import "UIImage+Additions.h"
#define CPFontDescriptor UIFontDescriptor
#define CPFontDescriptorTraitBold UIFontDescriptorTraitBold
#elif TARGET_OS_MAC

#import "NSImage+Additions.h"
#define CPFontDescriptor NSFontDescriptor
#define CPFontDescriptorTraitBold NSFontDescriptorTraitBold

#endif

////////////////////////////////////////////////////////////////////////////////////////////////////

static NSString *const ppMakeVirtualCardControllerHeadImage = @"PPMakeVirtualCardControllerHeadImage";

static const CGRect HeadImageRect   = {36, 41, 135, 135};
static const CGRect UnderBarRect    = {0, 361, 720, 79};
static const CGRect NameRect        = {216, 56, 720-216,100-56};
static const CGRect CompanyRect     = {0, 380, 720, 50};
static const CGRect OtherRect       = {216, 213, 720-216, 361-213};
static const CGRect DepartmentRect  = {216, 100, 720-216, 213-100};
static const CGSize VirtualCardSize = {720, 440};

static const CGFloat UnderBarColorRed   = 88/255.0f;
static const CGFloat UnderBarColorGreen = 67/255.0f;
static const CGFloat UnderBarColorBlue  = 67/255.0f;

static const NSUInteger CompanyFontSize    = 29;
static const NSUInteger DepartmentFontSize = 25;
static const NSUInteger NameFontSize       = 39;
static const NSUInteger OtherFontSize      = 24;

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPMakeVirtualCardController()
{
@private
    id<PPMakeVirtualCardControllerDataSource> dataSource_;
    
    CPImage                                   *headImage_;
    CPImage                                   *defaultHeadImage_;
    CGFloat                                   red_;
    CGFloat                                   green_;
    CGFloat                                   blue_;
    CGFloat                                   companyFontSize_;
    CGFloat                                   departmentFontSize_;
    CGFloat                                   nameFontSize_;
    CGFloat                                   otherFontSize_;
    
    CGFloat                                   originYFix_;
    CGRect                                    companyRect_;
    CGRect                                    departmentRect_;
    CGRect                                    headImageRect_;
    CGRect                                    nameRect_;
    CGRect                                    otherRect_;
    
    CGRect                                    underBarRect_;
    CGSize                                    virtualCardSize_;
    
}

@property (nonatomic,assign) CGFloat originYFix;
@property (nonatomic,retain) CPImage *defaultHeadImage;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPMakeVirtualCardController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
dataSource         = dataSource_,
headImage          = headImage_,
defaultHeadImage   = defaultHeadImage_,
red                = red_,
green              = green_,
blue               = blue_,
companyFontSize    = companyFontSize_,
departmentFontSize = departmentFontSize_,
nameFontSize       = nameFontSize_,
otherFontSize      = otherFontSize_,
originYFix         = originYFix_,
companyRect        = companyRect_,
departmentRect     = departmentRect_,
headImageRect      = headImageRect_,
nameRect           = nameRect_,
otherRect          = otherRect_,
underBarRect       = underBarRect_,
virtualCardSize    = virtualCardSize_;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
        defaultHeadImage_ = [[CPImage alloc] initWithContentsOfFile:[[NSBundle mainBundle] pathForResource:ppMakeVirtualCardControllerHeadImage ofType:@"png"]];
        
        red_   = UnderBarColorRed;
        green_ = UnderBarColorGreen;
        blue_  = UnderBarColorBlue;
        
        virtualCardSize_    = VirtualCardSize;
        companyFontSize_    = CompanyFontSize;
        departmentFontSize_ = DepartmentFontSize;
        nameFontSize_       = NameFontSize;
        otherFontSize_      = OtherFontSize;
        companyRect_        = CompanyRect;
        departmentRect_     = DepartmentRect;
        headImageRect_      = HeadImageRect;
        nameRect_           = NameRect;
        otherRect_          = OtherRect;
        underBarRect_       = UnderBarRect;
        virtualCardSize_    = VirtualCardSize;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    dataSource_ = nil;
    
    [defaultHeadImage_ release];
    defaultHeadImage_ = nil;
    
    [headImage_ release];
    headImage_ = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (NSString *)mobileString
{
    NSString *mobileString = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(ppMakeVirtualCardController:textForPPMakeVirtualCardControllerSubType:)]==YES)
        {
            NSArray *searchFileds = @[[NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_Mobile],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_iPhone]];
            
            for(NSUInteger index=0 ; index<searchFileds.count ; index++)
            {
                mobileString = [self.dataSource ppMakeVirtualCardController:self
                                  textForPPMakeVirtualCardControllerSubType:[searchFileds[index]unsignedIntegerValue]];
                
                if(mobileString!=nil)
                {
                    break;
                }
            }
        }
    } while (0);
    

    return mobileString;
}


//================================================================================
//
//================================================================================
- (NSString *)telephoneString
{
    NSString *telephoneString = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(ppMakeVirtualCardController:textForPPMakeVirtualCardControllerSubType:)]==YES)
        {
            NSArray *searchFileds = @[[NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_Work],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_Main],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_Home],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_Other]];
            
            for(NSUInteger index=0 ; index<searchFileds.count ; index++)
            {
                telephoneString = [self.dataSource ppMakeVirtualCardController:self
                                     textForPPMakeVirtualCardControllerSubType:[searchFileds[index]unsignedIntegerValue]];
                
                if(telephoneString!=nil)
                {
                    break;
                }
            }
        }
    } while (0);
    
    
    return telephoneString;
}


//================================================================================
//
//================================================================================
- (NSString *)faxString
{
    NSString *faxString = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(ppMakeVirtualCardController:textForPPMakeVirtualCardControllerSubType:)]==YES)
        {
            NSArray *searchFileds = @[[NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_WorkFax],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Phone_HomeFax]];
            
            for(NSUInteger index=0 ; index<searchFileds.count ; index++)
            {
                faxString = [self.dataSource ppMakeVirtualCardController:self
                               textForPPMakeVirtualCardControllerSubType:[searchFileds[index]unsignedIntegerValue]];
                
                if(faxString!=nil)
                {
                    break;
                }
            }
        }
    } while (0);
    
    return faxString;
}


//================================================================================
//
//================================================================================
- (NSString *)addressString
{
    NSString *addressString = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(ppMakeVirtualCardController:textForPPMakeVirtualCardControllerSubType:)]==YES)
        {
            NSArray *searchFileds = @[[NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Address_Work],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Address_Home],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Address_Other]];
            
            for(NSUInteger index=0 ; index<searchFileds.count ; index++)
            {
                addressString = [self.dataSource ppMakeVirtualCardController:self
                                   textForPPMakeVirtualCardControllerSubType:[searchFileds[index]unsignedIntegerValue]];
                
                if(addressString!=nil)
                {
                    break;
                }
            }
        }
    } while (0);
    
    return addressString;
}


//================================================================================
//
//================================================================================
- (NSString *)webString
{
    NSString *webString = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(ppMakeVirtualCardController:textForPPMakeVirtualCardControllerSubType:)]==YES)
        {
            NSArray *searchFileds = @[[NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_URL_HomePage],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_URL_Work],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_URL_Home],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_URL_Other]];
            
            for(NSUInteger index=0 ; index<searchFileds.count ; index++)
            {
                webString = [self.dataSource ppMakeVirtualCardController:self
                                   textForPPMakeVirtualCardControllerSubType:[searchFileds[index]unsignedIntegerValue]];
                
                if(webString!=nil)
                {
                    break;
                }
            }
        }
    } while (0);
    
    return webString;
}


//================================================================================
//
//================================================================================
- (NSString *)emailString
{
    NSString *emailString = nil;
    
    do
    {
        if([self.dataSource respondsToSelector:@selector(ppMakeVirtualCardController:textForPPMakeVirtualCardControllerSubType:)]==YES)
        {
            NSArray *searchFileds = @[[NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Email_Work],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Email_Home],
                                      [NSNumber numberWithUnsignedInteger:PPMakeVirtualCardControllerSubType_Email_Other]];
            
            for(NSUInteger index=0 ; index<searchFileds.count ; index++)
            {
                emailString = [self.dataSource ppMakeVirtualCardController:self
                               textForPPMakeVirtualCardControllerSubType:[searchFileds[index]unsignedIntegerValue]];
                
                if(emailString!=nil)
                {
                    break;
                }
            }
        }
    } while (0);
    
    return emailString;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - font methods

//==============================================================================
//
//==============================================================================
+ (NSString *)systemVersion
{
#if TARGET_OS_IPHONE
    
    return [UIDevice currentDevice].systemVersion;
    
#elif TARGET_OS_OSX
    
    NSOperatingSystemVersion systemVersion = [[NSProcessInfo processInfo] operatingSystemVersion];
    return [NSString stringWithFormat:@"%ld.%ld.%ld", systemVersion.majorVersion, systemVersion.minorVersion, systemVersion.patchVersion];
    
#endif
}


//==============================================================================
//
//==============================================================================
- (CPFont *)defaultFontWithSize:(CGFloat)size
{
    NSString *fontName = nil;
    
#if TARGET_OS_IPHONE
    if([[PPMakeVirtualCardController systemVersion] floatValue]<9.0)
#elif TARGET_OS_OSX
    if([[PPMakeVirtualCardController systemVersion] floatValue]<10.11)
#endif
    {
        fontName = @"STHeitiTC-Light";
    }
    else
    {
        fontName = @"PingFangTC-Light";
    }
    
    //////////////////////////////////////////////////

    CPFont *font = [CPFont fontWithName:fontName size:size];
    
    if(font == nil)
    {
        font = [CPFont systemFontOfSize:size];
    }

    return font;
}


//==============================================================================
//
//==============================================================================
- (CPFont *)defaultJapaneseFontWithSize:(CGFloat)size
{
    NSString *fontName = nil;
    
#if TARGET_OS_IPHONE
    if([[PPMakeVirtualCardController systemVersion] floatValue]<9.0)
#elif TARGET_OS_OSX
    if([[PPMakeVirtualCardController systemVersion] floatValue]<10.11)
#endif
    {
        fontName = @"STHeitiJ-Light";
    }
    else
    {
        fontName = @"PingFangTC-Light";
    }
    
    //////////////////////////////////////////////////
    
    CPFont *font = [CPFont fontWithName:fontName size:size];
    
    if(font == nil)
    {
        font = [CPFont systemFontOfSize:size];
    }
    
    return font;
}


//==============================================================================
//
//==============================================================================
- (CPFont *)defaultKoreanFontWithSize:(CGFloat)size
{
    CPFont *font = [CPFont fontWithName:@"AppleGothic" size:size];
    
    if(font == nil)
    {
        font = [CPFont systemFontOfSize:size];
    }
    
    return font;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - draw methods


//================================================================================
// 畫背景
//================================================================================
-(void)drawBackgroundWithContext:(CGContextRef)context
{
    CGContextSaveGState(context);
    // transfer the origin of context from left-bottom to left-top.
    CGContextTranslateCTM(context, 0, self.virtualCardSize.height);
    
    //  畫底色
    CGContextSetFillColorWithColor(context, [CPColor whiteColor].CGColor);
    CGContextFillRect(context, CGRectMake(0, 0, self.virtualCardSize.width, -self.virtualCardSize.height));
    
    //  draw underbar
    CGContextSetFillColorWithColor(context, [CPColor colorWithRed:self.red green:self.green blue:self.blue alpha:1.0f].CGColor);
    CGContextFillRect(context, CGRectMake(self.underBarRect.origin.x, -self.underBarRect.origin.y, self.underBarRect.size.width, -self.underBarRect.size.height));
    
    CGContextRestoreGState(context);
}

//================================================================================
//
//================================================================================
-(void)drawImage:(CPImage *)image context:(CGContextRef)context rect:(CGRect)rect
{
    if(image==nil)
    {
        return ;
    }
    
    // draw headImage
    // 大頭貼畫成圓型的
    CGContextSaveGState(context);
    CGContextTranslateCTM(context, 0, CGBitmapContextGetHeight(context));

    CGContextAddEllipseInRect(context, CGRectMake(rect.origin.x, -rect.origin.y, rect.size.width, -rect.size.height));
    
    CGContextClip(context);
    // draw IDPhoto
    CGContextDrawImage(context, CGRectMake(rect.origin.x, -rect.origin.y, rect.size.width, -rect.size.height), [image CGImage]);
    
    CGContextRestoreGState(context);
}


//================================================================================
//
//================================================================================
-(void)drawText:(NSString *)str context:(CGContextRef)context rect:(CGRect)rect textSize:(CGFloat)textSize textColor:(CPColor*)textColor
{
    
    if(rect.origin.y > self.underBarRect.origin.y - textSize && textSize != self.companyFontSize)
    {
        return;
    }
    
    if(rect.origin.y > self.companyRect.origin.y - textSize && textSize == self.departmentFontSize)
    {
        return;
    }

    CGContextSaveGState(context);
    CGContextTranslateCTM(context, 0, self.virtualCardSize.height);

    CFIndex count = [str characterCount];
    
    if(textSize == self.companyFontSize)
    {
        // 應該是用來置中
        CGSize *strSize = (CGSize *)malloc(sizeof(CGSize)*count);
        UniChar *tempCharacters = (UniChar *)malloc(sizeof(UniChar)*count);
        CGGlyph *tempGlyphs = (CGGlyph *)malloc(sizeof(CGGlyph)*count);
        
        CPFont *customFont = [self defaultFontWithSize:textSize];
        CTFontRef ctFont = CTFontCreateWithName((__bridge CFStringRef)customFont.fontName, customFont.pointSize, NULL);
        
        CFStringGetCharacters((CFStringRef)str, CFRangeMake(0, count), tempCharacters);
        CTFontGetGlyphsForCharacters(ctFont, tempCharacters, tempGlyphs, count);
        //andy ios6.0 api
        //CTFontGetOpticalBoundsForGlyphs(ctFont,tempGlyphs,strSize,count,0);
        CTFontGetAdvancesForGlyphs(ctFont,kCTFontOrientationDefault,tempGlyphs,strSize,count);
        CFRelease(ctFont);
        
        int width = 0;
        for(int i = 0;i < count;i++)
        {
            width += strSize[i].width;
        }
        
        int originXFix = (self.virtualCardSize.width - width)/2;
        if(originXFix > 0)
        rect.origin.x = originXFix;
        
        free(tempCharacters);
        free(tempGlyphs);
        free(strSize);
    }
    
    //////////////////////////////////////////////////
    // 一個字一個字畫
    NSInteger dotCount = 0;
    CGRect charRect = CGRectMake(rect.origin.x, rect.origin.y, rect.size.width, rect.size.height);
    
    for(int i = 0;i < count;i++)
    {
        NSRange singleCharRange = [str rangeOfStringAtUTF32Index:i];
        NSString *singleChar = [str substringWithRange:singleCharRange];

        // !! 太長要變...
        if((textSize == self.nameFontSize || textSize ==self.companyFontSize|| textSize ==self.departmentFontSize) &&
           charRect.origin.x + 2 * textSize > self.virtualCardSize.width)
        {
            singleChar = @".";
            dotCount++;
            
            // 如果點大於3個就不畫了
            if (dotCount>3)
            {
                continue ;
            }
        }
        
        //////////////////////////////////////////////////
        // 依不同的字集使用不同的字型
        CPFont *customFont = [self defaultFontWithSize:textSize];
        
        if([singleChar hasJapanese])
        {
            customFont = [self defaultKoreanFontWithSize:textSize];
        }
        else if([singleChar hasKorean])
        {
            customFont = [self defaultJapaneseFontWithSize:textSize];
        }
        
        //!! 公司字體加粗
        if(textSize==self.companyFontSize)
        {
            CPFontDescriptor *fontD = [customFont.fontDescriptor
                                       fontDescriptorWithSymbolicTraits:CPFontDescriptorTraitBold];
            if (fontD)
            {
                customFont = [CPFont fontWithDescriptor:fontD size:0];
            }
        }
        
        //////////////////////////////////////////////////
        // 產生attributedString用來繪圖
        NSMutableDictionary *attributes = [NSMutableDictionary dictionary];
        
        if (customFont!=nil)
        {
            [attributes setObject:customFont forKey:NSFontAttributeName];
        }
        
        if (textColor)
        {
            [attributes setObject:textColor forKey:NSForegroundColorAttributeName];
        }
        
        NSAttributedString *attributedString = [[[NSAttributedString alloc] initWithString:singleChar
                                                                                 attributes:attributes] autorelease];

        CTLineRef line = CTLineCreateWithAttributedString((CFAttributedStringRef)attributedString);
        
        // 設定起始點並繪圖
        CGPoint point = CGPointMake(charRect.origin.x, -(charRect.origin.y + textSize));
        CGContextSetTextPosition(context, point.x, point.y);
        CTLineDraw(line, context);
        
        // 取得line的寬度， 當做下次的起始點
        double bounds1 = CTLineGetTypographicBounds(line, 0, 0, 0);
        charRect.origin.x = charRect.origin.x + bounds1;
        
        CFRelease(line);
        
        //////////////////////////////////////////////////
        // 處理超過名片大小
        if(charRect.origin.x + textSize > self.virtualCardSize.width)
        {
            // 姓名，公司只有一行，所以超過就不畫
            if(textSize==self.nameFontSize || textSize==self.companyFontSize ||textSize==self.departmentFontSize)
            {
            }
            else
            {
                // 換行
                charRect.origin.x = rect.origin.x;
                charRect.origin.y += textSize;
                originYFix_++;
            }
        }
    }//for loop end
    
    CGContextRestoreGState(context);
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
// 產生畫的名片圖
//================================================================================
- (CPImage *)virtualCardImage
{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
    CGColorSpaceRef colorspace = CGColorSpaceCreateDeviceRGB();
	size_t bitsPerComponent = 8;
	size_t bytesPerRow = 4 * self.virtualCardSize.width;
	
    //////////////////////////////////////////////////
    
	CGContextRef context = CGBitmapContextCreate(NULL,
												 self.virtualCardSize.width,
												 self.virtualCardSize.height,
												 bitsPerComponent,
												 bytesPerRow,
												 colorspace,
												 (CGBitmapInfo)kCGImageAlphaNoneSkipLast);

    //////////////////////////////////////////////////
    // MARK: 畫底圖
    [self drawBackgroundWithContext:context];

    //////////////////////////////////////////////////
    // MARK: draw IDPhoto
    // 先把圖切裁成正方形
    CPImage *adjustHeadImage = self.headImage?:self.defaultHeadImage;
    if (self.headImage.size.width!=self.headImage.size.height)
    {
        CGFloat headLength = MIN(self.headImage.size.width, self.headImage.size.height);
        CGRect clipRect = CGRectMake((self.headImage.size.width-headLength)/2, (self.headImage.size.height-headLength)/2, headLength, headLength);
        adjustHeadImage = [self.headImage imageCroppedByRect:clipRect];
    }

    [self drawImage:adjustHeadImage context:context rect:self.headImageRect];


    //////////////////////////////////////////////////
    // MARK: draw text

    NSString *str_tmp;
    NSMutableString *str = nil;

    if([self.dataSource respondsToSelector:@selector(ppMakeVirtualCardController:textForPPMakeVirtualCardControllerMainType:)]==YES)
    {
        //----------------------------------
        // draw name with single line.
        //----------------------------------
        str = [NSMutableString string];

        str_tmp = [self.dataSource ppMakeVirtualCardController:self textForPPMakeVirtualCardControllerMainType:PPMakeVirtualCardControllerMainType_Name];

        if ([str_tmp length]) {
            [str appendString:str_tmp];
        }

        if ([str length] == 0) {
            [str appendString:[@"MLS_NoName" localized]];
        }

        [self drawText:str
               context:context
                  rect:self.nameRect
              textSize:self.nameFontSize
             textColor:[CPColor blackColor]];

        //////////////////////////////////////////////////

        //----------------------------------
        // draw Department / JobTitil / Mobile phone
        //----------------------------------
        originYFix_ = 0;

        str_tmp = [self.dataSource ppMakeVirtualCardController:self
                     textForPPMakeVirtualCardControllerSubType:PPMakeVirtualCardControllerSubType_Company_Department];

        if([str_tmp length])
        {
            [self drawText:str_tmp
                   context:context
                      rect:self.departmentRect
                  textSize:self.departmentFontSize
                 textColor:[CPColor blackColor]];
            originYFix_++;
        }

        //////////////////////////////////////////////////

        str_tmp = [self.dataSource ppMakeVirtualCardController:self
                     textForPPMakeVirtualCardControllerSubType:PPMakeVirtualCardControllerSubType_Company_JobTitle];

        if([str_tmp length])
        {
            [self drawText:str_tmp
                   context:context
                      rect:CGRectMake(self.departmentRect.origin.x, self.departmentRect.origin.y + originYFix_ * self.departmentFontSize, self.departmentRect.size.width, self.departmentRect.size.height)
                  textSize:self.departmentFontSize
                 textColor:[CPColor blackColor]];
            originYFix_++;
        }

        //////////////////////////////////////////////////

        str_tmp = [self mobileString];

        if([str_tmp length])
        {
            [self drawText:str_tmp
                   context:context
                      rect:CGRectMake(self.departmentRect.origin.x, self.departmentRect.origin.y + originYFix_ * self.departmentFontSize, self.departmentRect.size.width, self.departmentRect.size.height)
                  textSize:self.departmentFontSize
                 textColor:[CPColor blackColor]];

        }

        //////////////////////////////////////////////////

        //----------------------------------
        // draw Other
        //----------------------------------
        originYFix_ = 0;

        str_tmp = [self addressString];
        if([str_tmp length])
        {
            [self drawText:str_tmp
                   context:context
                      rect:self.otherRect
                  textSize:self.otherFontSize
                 textColor:[CPColor blackColor]];
            originYFix_++;
        }

        NSString *telStr = [self telephoneString];
        if([telStr length])
        {
            [self drawText:telStr
                   context:context
                      rect:CGRectMake(self.otherRect.origin.x, self.otherRect.origin.y + originYFix_ * self.otherFontSize, self.otherRect.size.width, self.otherRect.size.height)
                  textSize:self.otherFontSize
                 textColor:[CPColor blackColor]];
            originYFix_++;
        }
        NSString *faxStr = [self faxString];
        if([faxStr length])
        {
            [self drawText:faxStr
                   context:context
                      rect:CGRectMake(self.otherRect.origin.x, self.otherRect.origin.y + originYFix_ * self.otherFontSize, self.otherRect.size.width, self.otherRect.size.height)
                  textSize:self.otherFontSize
                 textColor:[CPColor blackColor]];
            originYFix_++;
        }

        str_tmp = [self emailString];
        if([str_tmp length])
        {
            [self drawText:str_tmp
                   context:context
                      rect:CGRectMake(self.otherRect.origin.x, self.otherRect.origin.y + originYFix_ * self.otherFontSize, self.otherRect.size.width, self.otherRect.size.height)
                  textSize:self.otherFontSize
                 textColor:[CPColor blackColor]];
            originYFix_++;
        }

        str_tmp = [self webString];
        if([str_tmp length])
        {
            [self drawText:str_tmp
                   context:context
                      rect:CGRectMake(self.otherRect.origin.x, self.otherRect.origin.y + originYFix_ * self.otherFontSize, self.otherRect.size.width, self.otherRect.size.height)
                  textSize:self.otherFontSize
                 textColor:[CPColor blackColor]];
            originYFix_++;
        }

        //////////////////////////////////////////////////

        //----------------------------------
        // draw Company
        //----------------------------------

        str_tmp = [self.dataSource ppMakeVirtualCardController:self
                     textForPPMakeVirtualCardControllerSubType:PPMakeVirtualCardControllerSubType_Company_Name];

        if([str_tmp length])
        {
            [self drawText:str_tmp
                   context:context
                      rect:self.companyRect
                  textSize:self.companyFontSize
                 textColor:[CPColor whiteColor]];
        }
    }
    //////////////////////////////////////////////////
    
	// get return image
	CGImageRef cgImage = CGBitmapContextCreateImage(context);
    CPImage *retImage = nil;
    
    //////////////////////////////////////////////////
#if TARGET_OS_IPHONE
    
    retImage = [[CPImage alloc] initWithCGImage:cgImage];

    
#elif TARGET_OS_MAC
    
    retImage = [[CPImage alloc] initWithCGImage:cgImage
                                           size:NSMakeSize(CGBitmapContextGetWidth(context),
                                                           CGBitmapContextGetHeight(context))];

#endif
	
    //////////////////////////////////////////////////
	// release
	CGImageRelease(cgImage);
	CGColorSpaceRelease(colorspace);
	CGContextRelease(context);
    
    [pool release];
    
    return [retImage autorelease];
}

@end
