//
//  PPShiftView.m
//  Pods
//
//  Created by sanhue on 2015/9/21.
//
//

#import "PPShiftView.h"

@implementation PPShiftView






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self.currentView removeFromSuperview];
    self.currentView = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - layout


//==============================================================================
//
//==============================================================================
- (void)layoutSublayersOfLayer:(CALayer *)layer
{
    // !! 因為在ios7旋轉時不會進入 layoutSubviews，所以改在這邊重設內部的view
    [super layoutSublayersOfLayer:layer];

    self.currentView.frame = self.bounds;
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark
#pragma mark - override property


//==============================================================================
//
//==============================================================================
- (void)setCurrentView:(UIView *)currentView
{
    if (_currentView == currentView) {
        return;
    }
    
    [currentView retain];
    
    [_currentView removeFromSuperview];
    [_currentView release];
    
    _currentView = currentView;
    
    NSLog(@"currentView:%@", currentView);
   if (currentView) {
        [self addSubview:currentView];
    }
    
    [self setNeedsLayout];
}


//==============================================================================
//
//==============================================================================
- (void)showView:(UIView *)view withDirection:(PPShiftDirection)direction
{
    UIView *oldView = self.currentView;
    oldView.userInteractionEnabled = NO;
    
    CGRect nextFrame = self.bounds;
    
    switch (direction) {
        case PPShiftDirection_Forward:
            nextFrame.origin.x = CGRectGetWidth(self.bounds);
            break;
        case PPShiftDirection_Backward:
            nextFrame.origin.x = -CGRectGetWidth(self.bounds);
            break;
    }
    
    view.frame = nextFrame;
    
    [self addSubview:view];

    // start animation
    [UIView animateWithDuration:0.3f delay:0 options:UIViewAnimationOptionCurveEaseInOut animations:^{
        
        switch (direction) {
            case PPShiftDirection_Forward:
                oldView.frame = CGRectOffset(oldView.frame, -CGRectGetWidth(self.bounds), 0);
                view.frame = CGRectOffset(view.frame, -CGRectGetWidth(self.bounds), 0);
                break;
            case PPShiftDirection_Backward:
                oldView.frame = CGRectOffset(oldView.frame, CGRectGetWidth(self.bounds), 0);
                view.frame = CGRectOffset(view.frame, CGRectGetWidth(self.bounds), 0);
                break;
        }
        
    } completion:^(BOOL finished) {
        
       [oldView removeFromSuperview];
        
    }];
    
    self.currentView = view;
}

@end
