//
//  UIView+CustomAnimation.m
//  Pods
//
//  Created by sanhue on 2015/9/21.
//
//

#import "UIView+CustomAnimation.h"
@import AudioToolbox;


////////////////////////////////////////////////////////////////////////////////////////////////////
@implementation UIView (CustomAnimation)


//==============================================================================
//
//==============================================================================
- (void)shakeAndVibrateCompletion:(void (^)(void))completionBlock
{
    AudioServicesPlayAlertSound(kSystemSoundID_Vibrate);
    [CATransaction begin];
    [CATransaction setCompletionBlock:^{
        if (completionBlock) {
            completionBlock();
        }
    }];
    NSString *keyPath = @"position";
    CABasicAnimation *animation =
    [CABasicAnimation animationWithKeyPath:keyPath];
    [animation setDuration:0.04];
    [animation setRepeatCount:4];
    [animation setAutoreverses:YES];
    CGFloat delta = 10.0;
    CGPoint center = self.center;
    [animation setFromValue:[NSValue valueWithCGPoint:
                             CGPointMake(center.x - delta, center.y)]];
    [animation setToValue:[NSValue valueWithCGPoint:
                           CGPointMake(center.x + delta, center.y)]];
    [[self layer] addAnimation:animation forKey:keyPath];
    [CATransaction commit];
}
@end
