//
//  PPLocationManager.h
//
//
//  Created by Howard on 2015/12/29.
//
//

#import <Foundation/Foundation.h>

#import "LocationBlockOperation.h"

// framework
#import <CoreLocation/CoreLocation.h>

// Controller
#import "PPNetworkReachabilityController.h"

@interface PPLocationManager : NSObject


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

/**
 *  開始更新使用者位置
 *  處理方式:非同步方法，上層要自行處理 UI 行為
 */
- (LocationBlockOperation *)startUpdatingCurrentLocationBlockOperationWithSuccess:(void (^)(void))success
                                                                          failure:(void (^)(NSError *error))failure;

/**
 *  停止更新使用者位置
 */
- (void)stopUpdatingCurrentLocation;


/**
 *  獲得一組地址位置資訊
 *
 *  @param addressDictionary 地址字典
 *  @param identity 額外資訊
 *  @param success           成功回傳函式
 *  @param failure           失敗回傳函式
 *
 *  @return blockOperation
 */
- (LocationBlockOperation *)fetchLocationFromAddressDictionary:(NSDictionary *)addressDictionary
                                                      identity:(NSString *)identity
                                                       success:(void (^)(void))success
                                                       failure:(void (^)(NSError *error))failure;


/**
 *  獲得地址位置資訊
 *
 *  @param addressString 地址
 *  @param region 指定區域(通常是用手機位置)，不給系統會用戶的大概位置
 *  @param identity 額外資訊
 *  @param success  成功回傳函式
 *  @param failure  失敗回傳函式
 *
 *  @return blockOperation
 */
- (LocationBlockOperation *)fetchLocationFromAddressString:(NSString *)addressString
                                                    region:(CLCircularRegion *)region
                                                  identity:(NSString *)identity
                                                   success:(void (^)(void))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  Location 反查地址
 *
 *  @param location 位置
 *  @param identity 額外資訊
 *  @param success  成功回傳函式
 *  @param failure  失敗回傳函式
 *
 *  @return blockOperation
 */
- (LocationBlockOperation *)fetchAddressStringFromLocation:(CLLocation *)location
                                                  identity:(NSString *)identity
                                                   success:(void (^)(void))success
                                                   failure:(void (^)(NSError *error))failure;


/**
 *  取消指令
 */
- (void)cancelGeocode;

@end
