//
//  PPImageScrollView.m
//  
//
//  Created by Mike on 13/6/7.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPImageScrollView.h"





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPImageScrollView()

@interface PPImageScrollView()





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,readwrite,retain) UITapGestureRecognizer  *doubleTapGestureRecognizer;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPImageScrollView

@implementation PPImageScrollView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Init & Dealloc


//==============================================================================
//
//==============================================================================
- (instancetype)initWithCoder:(NSCoder *)coder
{
    if((self = [super initWithCoder:coder]))
    {
        [self initialProcess];
    }
    return self;
}

//==============================================================================
//
//==============================================================================
- (id)initWithFrame:(CGRect)frame
{
    if((self = [super initWithFrame:frame])) 
    {
        [self initialProcess];
    }
    
    return self;
}


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.doubleTapGestureEnabled = NO;
    
    //////////////////////////////////////////////////
    
    [_doubleTapGestureRecognizer release];
    _doubleTapGestureRecognizer = nil;
    
    //////////////////////////////////////////////////
    
	[self.imageView removeFromSuperview];
	[_imageView release];
	_imageView = nil;
    
    //////////////////////////////////////////////////
    
    [_image release];
    _image = nil;
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}


//==============================================================================
//
//==============================================================================
- (void)initialProcess
{
    self.canCancelContentTouches        = NO;
    self.clipsToBounds                    = YES;
    self.delegate                        = self;
    self.exclusiveTouch                 = YES;
    self.showsHorizontalScrollIndicator    = NO;
    self.showsVerticalScrollIndicator    = NO;
    
    //////////////////////////////////////////////////
    
    _imageView = [[UIImageView alloc] init];
    if(self.imageView!=nil)
    {
        self.imageView.backgroundColor = [UIColor clearColor];
        [self addSubview:self.imageView];
    }
    
    //////////////////////////////////////////////////
    
    _doubleTapGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(doubleTapNotify:)];
    if(self.doubleTapGestureRecognizer!=nil)
    {
        self.doubleTapGestureRecognizer.numberOfTapsRequired = 2;
    }
    
    //////////////////////////////////////////////////
    
    _imageMode                      = PPImageScrollViewImageMode_ScaleAspectFit;
    _zoomEnabled                    = YES;
    _maximumZoomScaleForImageSize    = PPImageScrollViewDefaultMaximumZoomScaleForImageSize;
    _preferredImageSize             = CGSizeZero;
    
    //////////////////////////////////////////////////
    
    
    self.doubleTapGestureEnabled = YES;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Message Proxy Methods

//==============================================================================
//
//==============================================================================
- (BOOL)respondsToSelector:(SEL)selector
{
    BOOL result = NO;
    
	//檢查自己是否有實作該message
	if([[self class] instancesRespondToSelector:selector])
	{
		result = YES;
	}
    else
    {
        result = (self.proxy!=nil && [self.proxy respondsToSelector:selector]);
    }
	
	return result;
}


//==============================================================================
//
//==============================================================================
- (void)forwardInvocation:(NSInvocation *)invocation
{
	SEL selector = [invocation selector];
	
	//將沒有處理到的message轉送出去
	if(self.proxy!=nil && [self.proxy respondsToSelector:selector]==YES)
	{
		[invocation invokeWithTarget:self.proxy];
	}
	else
	{
		[self doesNotRecognizeSelector:selector];
	}
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override

//==============================================================================
//
//==============================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
    
    CGRect viewFrame = self.imageView.frame;
    
    if(self.frame.size.width>viewFrame.size.width)
    {
        viewFrame.origin.x = floor((self.frame.size.width-viewFrame.size.width)/2);
    }
    else
    {
        viewFrame.origin.x = 0.0;
    }
    
    if(self.frame.size.height>viewFrame.size.height)
    {
        viewFrame.origin.y = floor((self.frame.size.height-viewFrame.size.height)/2);
    }
    else
    {
        viewFrame.origin.y = 0.0;
    }
    
    self.imageView.frame = viewFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

//==============================================================================
//
//==============================================================================
- (void)setDoubleTapGestureEnabled:(BOOL)doubleTapGestureEnabled
{
    _doubleTapGestureEnabled = doubleTapGestureEnabled;
    
    //////////////////////////////////////////////////
    
    if(doubleTapGestureEnabled==YES)
    {
        [self addGestureRecognizer:self.doubleTapGestureRecognizer];
    }
    else
    {
        [self removeGestureRecognizer:self.doubleTapGestureRecognizer];
    }
}


//==============================================================================
//
//==============================================================================
- (void)setProxy:(id<UIScrollViewDelegate>)proxy
{
    self.delegate = nil;
    
    _proxy = proxy;
    
    if (_proxy != nil)
    {
        self.delegate = self;
    }
}


//==============================================================================
//
//==============================================================================
- (void)setPreferredImageSize:(CGSize)preferedImageSize
{
    _preferredImageSize = preferedImageSize;
    
    //////////////////////////////////////////////////
    
    [self layoutImageView];
}


//==============================================================================
//
//==============================================================================
- (void)setImage:(UIImage *)image
{
    [image retain];
    [_image release];
    _image = image;
    
    //////////////////////////////////////////////////
    
    // !!重設圖片時，transform也要重設，不然如果前後兩次的圖的transform一樣，會造成沒有縮放
    [self.imageView setTransform:CGAffineTransformIdentity];
    self.imageView.image = self.image;
    
    //////////////////////////////////////////////////
    
    [self layoutImageView];
}


//==============================================================================
//
//==============================================================================
- (void)setEdgeInsetsForRecessed:(UIEdgeInsets)edgeInsetsForRecessed
{
    if(UIEdgeInsetsEqualToEdgeInsets(self.edgeInsetsForRecessed, edgeInsetsForRecessed)==NO)
    {
        _edgeInsetsForRecessed = edgeInsetsForRecessed;
        
        //////////////////////////////////////////////////
        
        [self layoutImageView];
    }
}


//==============================================================================
//
//==============================================================================
- (void)setImageMode:(PPImageScrollViewImageMode)imageMode
{
    if(self.imageMode!=imageMode)
    {
        _imageMode = imageMode;
        
        //////////////////////////////////////////////////
        
        [self layoutImageView];
    }
}


//==============================================================================
//
//==============================================================================
- (void)setScaleBase:(PPImageScrollViewScaleBase)scaleBase
{
    if(self.scaleBase!=scaleBase)
    {
        _scaleBase = scaleBase;

        //////////////////////////////////////////////////

        [self layoutImageView];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

//==============================================================================
//
//==============================================================================
- (void)doubleTapNotify:(id)sender
{
    CGPoint offset = self.contentOffset;
    
    if(sender!=nil && [sender isKindOfClass:[UIGestureRecognizer class]]==YES)
    {
        CGPoint tapPoint            = [((UIGestureRecognizer *)sender) locationInView:self.imageView];
        CGPoint zoomScaleTapPoint   = CGPointMake(tapPoint.x*self.zoomScale, tapPoint.y*self.zoomScale);
        
        offset = CGPointMake(zoomScaleTapPoint.x-(self.bounds.size.width/2)+self.imageView.frame.origin.x,
                             zoomScaleTapPoint.y-(self.bounds.size.height/2)+self.imageView.frame.origin.y);
    }
    
    //////////////////////////////////////////////////

    CGFloat scale = 0.0;
   
    //////////////////////////////////////////////////
    
    if(self.zoomScale!=self.minimumZoomScale)
	{
        scale = self.minimumZoomScale;
	}
	else
	{
        if(self.doubleTapZoomScale!=0)
        {
            //指定雙擊縮放率
            
            scale = self.doubleTapZoomScale;
        }
        else
        {
            if(self.imageView.image!=nil)
            {
                _preferredImageSize = self.imageView.image.size;
            }
            
            //沒有指定雙擊縮放率,則定為原圖一倍大
            //當影像本身小於View，ScaleBase為Image，且未指定doubleTapZoomScale時，則設為maximumZoomScale
            
            if(self.scaleBase==PPImageScrollViewScaleBase_ViewSize)
            {
                if(self.preferredImageSize.width*self.maximumZoomScaleForImageSize<self.imageView.frame.size.width && self.preferredImageSize.height*self.maximumZoomScaleForImageSize<self.imageView.frame.size.height)
                {
                    //圖真的非常小時,maximumZoomScaleForImageSize還無法滿足填滿ScrollView
                    scale = self.maximumZoomScale;
                }
                else
                {
                    scale = self.maximumZoomScale/self.maximumZoomScaleForImageSize;
                }
            }
            else
            {
                if(self.minimumZoomScale<1)
                {
                    //代表影像大於ScrollView,所以zoomScale:1(就是原始影像大小)
                    scale = 1.0;
                }
                else
                {
                    //代表影像小於ScrollView,所以zoomScale:maximumZoomScale
                    scale = self.maximumZoomScale;
                }
            }
        }
	}
    
    //////////////////////////////////////////////////
    
    if(self.zoomScale!=scale && self.zoomEnabled)
    {
        if (scale < self.minimumZoomScale)
        {
            scale = self.minimumZoomScale;
        }
        
        if(CGPointEqualToPoint(self.contentOffset,offset)==NO && scale != self.minimumZoomScale)
        {
            self.contentOffset = offset;
        }
        
        self.zoomScale = scale;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//==============================================================================
//
//==============================================================================
- (void)layoutImageView
{
    if(CGRectIsEmpty(self.bounds)==NO)
    {
        //////////////////////////////////////////////////
        //回歸初始值
        
        self.minimumZoomScale   = 1.0;
        self.maximumZoomScale   = 1.0;
        self.zoomScale          = 1.0;
        
        //////////////////////////////////////////////////
        
        CGRect imageViewFrame = CGRectZero;
        
        // 如果有圖就用圖的大小計算
        if(self.imageView.image!=nil)
        {
            _preferredImageSize = self.imageView.image.size;
        }
        
        if(CGSizeEqualToSize(_preferredImageSize, CGSizeZero))
        {
            return;
        }
        
        if(self.scaleBase==PPImageScrollViewScaleBase_ViewSize)
        {
            //以ImageView的Size當做zoomScale:1
            
            switch(self.imageMode)
            {
                case PPImageScrollViewImageMode_ScaleAspectRecessed:
                {
                    if((self.preferredImageSize.width/self.preferredImageSize.height)>((self.bounds.size.width-(self.edgeInsetsForRecessed.left+self.edgeInsetsForRecessed.right))/(self.bounds.size.height-(self.edgeInsetsForRecessed.top+self.edgeInsetsForRecessed.bottom))))
                    {
                        //寬度為主
                        
                        imageViewFrame.size.width	= self.bounds.size.width-(self.edgeInsetsForRecessed.left+self.edgeInsetsForRecessed.right);
                        imageViewFrame.size.height	= floor(imageViewFrame.size.width*self.preferredImageSize.height/self.preferredImageSize.width);
                    }
                    else
                    {
                        //高度為主
                        
                        imageViewFrame.size.height	= self.bounds.size.height-(self.edgeInsetsForRecessed.top+self.edgeInsetsForRecessed.bottom);
                        imageViewFrame.size.width	= floor(imageViewFrame.size.height*self.preferredImageSize.width/self.preferredImageSize.height);
                    }
                    
                    imageViewFrame.origin.x	= floor((self.bounds.size.width-imageViewFrame.size.width)/2);
                    imageViewFrame.origin.y	= floor((self.bounds.size.height-imageViewFrame.size.height)/2);
                    
                    break;
                }
                case PPImageScrollViewImageMode_ScaleAspectFill:
                {
                    if((self.preferredImageSize.width/self.preferredImageSize.height)>(self.bounds.size.width/self.bounds.size.height))
                    {
                        //高度為主
                        
                        imageViewFrame.size.height	= self.bounds.size.height;
                        imageViewFrame.size.width	= floor(imageViewFrame.size.height*self.preferredImageSize.width/self.preferredImageSize.height);
                    }
                    else
                    {
                        //寬度為主
                        
                        imageViewFrame.size.width	= self.bounds.size.width;
                        imageViewFrame.size.height	= floor(imageViewFrame.size.width*self.preferredImageSize.height/self.preferredImageSize.width);
                    }
                    
                    break;
                }
                case PPImageScrollViewImageMode_ScaleAspectFit:
                default:
                {
                    if((self.preferredImageSize.width/self.preferredImageSize.height)>(self.bounds.size.width/self.bounds.size.height))
                    {
                        //寬度為主
                        
                        imageViewFrame.size.width	= self.bounds.size.width;
                        imageViewFrame.size.height	= floor(imageViewFrame.size.width*self.preferredImageSize.height/self.preferredImageSize.width);
                        imageViewFrame.origin.y		= floor((self.bounds.size.height-imageViewFrame.size.height)/2);
                    }
                    else
                    {
                        //高度為主
                        
                        imageViewFrame.size.height	= self.bounds.size.height;
                        imageViewFrame.size.width	= floor(imageViewFrame.size.height*self.preferredImageSize.width/self.preferredImageSize.height);
                        imageViewFrame.origin.x		= floor((self.bounds.size.width-imageViewFrame.size.width)/2);
                    }
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            if(self.preferredImageSize.width*self.maximumZoomScaleForImageSize<imageViewFrame.size.width && self.preferredImageSize.height*self.maximumZoomScaleForImageSize<imageViewFrame.size.height)
            {
                //圖真的非常小時,maximumZoomScaleForImageSize還無法滿足填滿ScrollView
                
                self.maximumZoomScale = self.minimumZoomScale*self.maximumZoomScaleForImageSize;
            }
            else
            {
                self.maximumZoomScale = MIN(self.preferredImageSize.width/imageViewFrame.size.width, self.preferredImageSize.height/imageViewFrame.size.height)*self.maximumZoomScaleForImageSize;
            }
        }
        else
        {
            //以Image的Size當做zoomScale:1
            
            switch(self.imageMode)
            {
                case PPImageScrollViewImageMode_ScaleAspectRecessed:
                {
                    if((self.preferredImageSize.width/self.preferredImageSize.height)>((self.bounds.size.width-(self.edgeInsetsForRecessed.left+self.edgeInsetsForRecessed.right))/(self.bounds.size.height-(self.edgeInsetsForRecessed.top+self.edgeInsetsForRecessed.bottom))))
                    {
                        //寬度為主
                        
                        self.minimumZoomScale = ((self.bounds.size.width-(self.edgeInsetsForRecessed.left+self.edgeInsetsForRecessed.right))/self.preferredImageSize.width);
                    }
                    else
                    {
                        //高度為主
                        
                        self.minimumZoomScale = ((self.bounds.size.height-(self.edgeInsetsForRecessed.top+self.edgeInsetsForRecessed.bottom))/self.preferredImageSize.height);
                    }
                    
                    break;
                }
                case PPImageScrollViewImageMode_ScaleAspectFill:
                {
                    if((self.preferredImageSize.width/self.preferredImageSize.height)>(self.bounds.size.width/self.bounds.size.height))
                    {
                        //高度為主
                        
                        self.minimumZoomScale = (self.bounds.size.height/self.preferredImageSize.height);
                    }
                    else
                    {
                        //寬度為主
                        
                        self.minimumZoomScale = (self.bounds.size.width/self.preferredImageSize.width);
                    }
                    
                    break;
                }
                case PPImageScrollViewImageMode_ScaleAspectFit:
                default:
                {
                    if((self.preferredImageSize.width/self.preferredImageSize.height)>(self.bounds.size.width/self.bounds.size.height))
                    {
                        //寬度為主
                        
                        self.minimumZoomScale = (self.bounds.size.width/self.preferredImageSize.width);
                    }
                    else
                    {
                        //高度為主
                        
                        self.minimumZoomScale = (self.bounds.size.height/self.preferredImageSize.height);
                    }
                    
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            imageViewFrame.size = self.preferredImageSize;
            
            //////////////////////////////////////////////////
            
            if(self.minimumZoomScale>1)
            {
                //需要放大才能符合ScrollView的大小
        
                self.maximumZoomScale = self.minimumZoomScale*self.maximumZoomScaleForImageSize;
            }
            else
            {
                //需要縮小才能符合ScrollView的大小
                
                self.maximumZoomScale = self.maximumZoomScaleForImageSize;
            }
        }
        
        //////////////////////////////////////////////////
        
        self.imageView.frame = imageViewFrame;
        
        self.contentSize = imageViewFrame.size;
        
        //////////////////////////////////////////////////
        
        self.zoomScale = self.minimumZoomScale;
    }

}


//==============================================================================
//
//==============================================================================
- (void)zoomScaleToSize:(CGSize)size
{
    CGFloat scale = 0.0;
    
    if(self.imageMode==PPImageScrollViewImageMode_ScaleAspectFill)
    {
        scale = MAX(size.width/(self.imageView.bounds.size.width/self.zoomScale),
                    size.height/(self.imageView.bounds.size.height/self.zoomScale));
    }
    else
    {
        scale = MIN(size.width/(self.imageView.bounds.size.width/self.zoomScale),
                    size.height/(self.imageView.bounds.size.height/self.zoomScale));
    }
    
    self.zoomScale = scale;
    
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIScrollViewDelegate

//==============================================================================
//
//==============================================================================
- (UIView *)viewForZoomingInScrollView:(UIScrollView *)scrollView
{
    UIView *view = nil;
    
	if(self.proxy!=nil && [self.proxy respondsToSelector:_cmd]==YES)
	{
		view = [self.proxy viewForZoomingInScrollView:scrollView];
	}
	else if(self.zoomEnabled==YES)
	{
		view = self.imageView;
	}
	
	return view;
}


//==============================================================================
//
//==============================================================================
- (void)scrollViewDidEndZooming:(UIScrollView *)scrollView withView:(UIView *)view atScale:(CGFloat)scale
{
	[self layoutIfNeeded];
	
	//////////////////////////////////////////////////

	if(self.proxy!=nil && [self.proxy respondsToSelector:_cmd]==YES) 
	{
		[self.proxy scrollViewDidEndZooming:scrollView withView:view atScale:scale];
	}
}


//==============================================================================
//
//==============================================================================
- (void)scrollViewDidZoom:(UIScrollView *)scrollView
{
	[self layoutIfNeeded];
	
	//////////////////////////////////////////////////

	if(self.proxy!=nil && [self.proxy respondsToSelector:_cmd]==YES) 
	{
		[self.proxy scrollViewDidZoom:scrollView];
	}
}

@end
