//
//  ImageEnhanceViewController.m
//
//  Created by Mike on 2011/7/4.
//  Copyright 2011年 Penpower. All rights reserved.
//

#import "PPImageEnhanceViewController.h"

// Define
#import "PPImageEnhanceController+ResourceDefine.h"

// Model
#import "PPQuadrilateralModel.h"

// View
#import "PPButton.h"
#import "PPBusyView.h"
#import "PPImageScrollCropView.h"
#import "PPNavigationBarView.h"

// Controller
#import "PPLogController.h"
#import "PPImageEnhanceController.h"

// Category
#import "PPButton+Factory.h"
#import "NSString+Additions.h"
#import "UIImage+Additions.h"
#import "NSThread+Additions.h"
#import "UIColor+PropertyDictionary.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ImageEnhanceViewController()

@interface PPImageEnhanceViewController() <PPButtonDelegate>
{
    PPISCV_CropPoints cropPoints_;
}

@property(nonatomic,retain) PPBusyView              *ppBusyView;
@property(nonatomic,retain) PPButton                *ppButtonBack;
@property(nonatomic,retain) PPButton                *ppButtonCancel;
@property(nonatomic,retain) PPButton                *ppButtonDone;
@property(nonatomic,retain) PPButton                *ppButtonImageLightable;
@property(nonatomic,retain) PPButton                *ppButtonImageRectification;
@property(nonatomic,retain) PPButton                *ppButtonFullRect;
@property(nonatomic,retain) PPNavigationBarView     *ppNavigationBarView;
@property(nonatomic,retain) PPBarView               *ppBottomBarView;
@property(nonatomic,retain) PPImageScrollCropView   *ppImageScrollCropView;
@property(nonatomic,retain) UIImage                 *executeImage;
@property(nonatomic,assign) BOOL					executed;
@property(nonatomic,assign) BOOL                    needUpdateCropViewFrame;
@property(nonatomic,assign) ImageEnhanceViewControllerButtonTag buttonClickTag;
@property(nonatomic,retain) NSMutableArray          *layoutConstraints;
@property(nonatomic,retain) NSOperationQueue        *workingOperationQueue;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPImageEnhanceViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//==============================================================================
//
//==============================================================================
+ (void)initialize
{
    [[PPImageEnhanceViewController appearance] setImageScrollCropViewBakcgroundColor:[UIColor blackColor]];
}


//================================================================================
//
//================================================================================
- (id)init
{
	if((self=[super init]))
	{
        [[PPImageEnhanceViewController appearance] applyInvocationTo:self];
        
        //////////////////////////////////////////////////

        _workingOperationQueue = [[NSOperationQueue alloc] init];
        
        if(_workingOperationQueue!=nil)
        {
            [_workingOperationQueue setMaxConcurrentOperationCount:1];
        }
	}
	
    return self;
}





//================================================================================
//
//================================================================================
- (void)dealloc 
{
    [self removeMainUI];
    
    [self.ppBusyView removeFromSuperview];
    self.ppBusyView = nil;
    
    [_sourceImage release];
    _sourceImage = nil;
    
    [_executeImage release];
    _executeImage = nil;
    
    [_buttonHighlightedBackgroundColor release];
    _buttonHighlightedBackgroundColor = nil;
    
    [_bottomBarViewBackgroundColor release];
    _bottomBarViewBackgroundColor = nil;
    
    [_imageScrollCropViewBakcgroundColor release];
    _imageScrollCropViewBakcgroundColor = nil;
    
    [_workingOperationQueue release];
    _workingOperationQueue = nil;
    
    [_layoutConstraints release];
    _layoutConstraints = nil;
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}








////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    PPLogFunctionIn();
    
	[super viewWillAppear:animated];

    //////////////////////////////////////////////////
    [self prepareMainUI];
    
    //////////////////////////////////////////////////

    self.executed = NO;
    
    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (void)viewDidAppear:(BOOL)animated
{
    PPLogFunctionIn();
    
    [super viewDidAppear:animated];
    
    //////////////////////////////////////////////////

    [self launchThreadInitCrop];
    
    PPLogFunctionOut();
}



//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{	
    PPLogFunctionIn();
    

    [self removeMainUI];
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
    
    PPLogFunctionOut();
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    
    //////////////////////////////////////////////////
    [self.view setNeedsUpdateConstraints];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - prepare ui


//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    self.ppButtonBack = [PPButton ppButtonWithSystemBackImitation];
    
    //////////////////////////////////////////////////
    
    if(self.ppButtonBack!=nil)
    {
        self.ppButtonBack.tag = ImageEnhanceViewControllerButtonTag_Back;
        self.ppButtonBack.delegate = self;
        [self.ppButtonBack setImageEdgeInsets:self.buttonImageEdgeInsets];
        [self.ppButtonBack setBackgroundImage:[UIImage imageWithColor:self.buttonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
        [self.ppButtonBack addControlEvents:UIControlEventTouchUpInside];
    }
    
    //////////////////////////////////////////////////
    
    self.ppButtonCancel = [PPButton ppButtonWithSystemBackImitation];
    
    if(self.ppButtonCancel!=nil)
    {
        self.ppButtonCancel.tag = ImageEnhanceViewControllerButtonTag_Cancel;
        self.ppButtonCancel.delegate = self;
        [self.ppButtonCancel setImageEdgeInsets:self.buttonImageEdgeInsets];
        [self.ppButtonCancel setBackgroundImage:[UIImage imageWithColor:self.buttonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
        [self.ppButtonCancel addControlEvents:UIControlEventTouchUpInside];
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppButtonDone==nil)
    {
        _ppButtonDone = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
    }
    
    if(self.ppButtonDone!=nil)
    {
        self.ppButtonDone.delegate = self;
        self.ppButtonDone.tag      = ImageEnhanceViewControllerButtonTag_Done;
        [self.ppButtonDone addControlEvents:UIControlEventTouchUpInside];
        
        [self.ppButtonDone setImageWithName:ImageNamePPImageEnhanceViewControllerButtonDone];
        [self.ppButtonDone setBackgroundImage:[UIImage imageWithColor:self.buttonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
        [self.ppButtonDone setImageEdgeInsets:self.buttonImageEdgeInsets];
        
        //////////////////////////////////////////////////
        
        self.ppButtonDone.hidden = YES;
    }
    
    //////////////////////////////////////////////////
    
    //使用客製化導航列覆蓋原始整列
    
    if(self.navigationController!=nil)
    {
        if(self.ppNavigationBarView==nil)
        {
            _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        }
        
        if(self.ppNavigationBarView!=nil)
        {
            self.ppNavigationBarView.style      = PPBarViewStyle_CenteredAbsolute;
            self.ppNavigationBarView.tintColor  = self.navigationController.navigationBar.tintColor;
            self.ppNavigationBarView.titleLabel.enabled = NO;
            
            //////////////////////////////////////////////////
            
            UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView];
            
            if(leftBarButtonItem!=nil)
            {
                self.navigationItem.leftBarButtonItem = leftBarButtonItem;
                [leftBarButtonItem release];
            }
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppImageScrollCropView==nil)
    {
        _ppImageScrollCropView = [[PPImageScrollCropView alloc] init];
    }
    
    if(self.ppImageScrollCropView!=nil)
    {
        self.ppImageScrollCropView.maxEdgeLength = MAX(ImageEnhanceControllerImageSize_Large.width, ImageEnhanceControllerImageSize_Large.height);
        self.ppImageScrollCropView.doubleTapGestureEnabled = YES;
        [self.ppImageScrollCropView setTranslatesAutoresizingMaskIntoConstraints:NO];
        self.ppImageScrollCropView.backgroundColor = self.imageScrollCropViewBakcgroundColor;
        
        [self.view addSubview:self.ppImageScrollCropView];
    }
    
    //////////////////////////////////////////////////
    
    if(self.ppBottomBarView==nil)
    {
        self.ppBottomBarView = [[[PPBarView alloc] initWithFrame:CGRectZero] autorelease];
    }
    
    if(self.ppBottomBarView!=nil)
    {
        self.ppBottomBarView.style = PPBarViewStyle_Average;
        [self.ppBottomBarView setTranslatesAutoresizingMaskIntoConstraints:NO];
        [self.ppBottomBarView setBackgroundColor:self.bottomBarViewBackgroundColor];
        [self.view addSubview:self.ppBottomBarView];
        
        //////////////////////////////////////////////////
        
        if(self.ppButtonImageLightable==nil)
        {
            _ppButtonImageLightable = [[PPButton alloc] initWithFrame:CGRectZero];
        }
        
        if(self.ppButtonImageLightable!=nil)
        {
            self.ppButtonImageLightable.delegate = self;
            self.ppButtonImageLightable.tag = ImageEnhanceViewControllerButtonTag_Light;
            [self.ppButtonImageLightable addControlEvents:UIControlEventTouchUpInside];
            
            [self.ppButtonImageLightable setImageEdgeInsets:self.buttonImageEdgeInsets];
            [self.ppButtonImageLightable setBackgroundImage:[UIImage imageWithColor:self.buttonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
            [self.ppButtonImageLightable setImageWithName:ImageNamePPImageEnhancenViewControllerButtonLight];
        }
        
        //////////////////////////////////////////////////
        
        if(self.ppButtonImageRectification==nil)
        {
            _ppButtonImageRectification = [[PPButton alloc] initWithFrame:CGRectZero];
        }
        
        if(self.ppButtonImageRectification!=nil)
        {
            self.ppButtonImageRectification.delegate = self;
            self.ppButtonImageRectification.tag = ImageEnhanceViewControllerButtonTag_ImageRectification;
            [self.ppButtonImageRectification addControlEvents:UIControlEventTouchUpInside];
            
            [self.ppButtonImageRectification setImageEdgeInsets:self.buttonImageEdgeInsets];
            [self.ppButtonImageRectification setBackgroundImage:[UIImage imageWithColor:self.buttonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
            [self.ppButtonImageRectification setImageWithName:ImageNamePPImageEnhanceViewControllerButtonClip];
        }
        
        //////////////////////////////////////////////////
        
        if(self.ppButtonFullRect==nil)
        {
            self.ppButtonFullRect = [[[PPButton alloc] initWithFrame:CGRectZero] autorelease];
        }
        
        if(self.ppButtonFullRect!=nil)
        {
            self.ppButtonFullRect.delegate = self;
            self.ppButtonFullRect.tag = ImageEnhanceViewControllerButtonTag_FullRect;
            [self.ppButtonFullRect addControlEvents:UIControlEventTouchUpInside];
            
            [self.ppButtonFullRect setImageEdgeInsets:self.buttonImageEdgeInsets];
            [self.ppButtonFullRect setBackgroundImage:[UIImage imageWithColor:self.buttonHighlightedBackgroundColor] forState:UIControlStateHighlighted];
            [self.ppButtonFullRect setImageWithName:ImageNamePPImageEnhanceViewControllerButtonFullRect];
        }
        
        //////////////////////////////////////////////////
        
        if(self.ppButtonImageLightable!=nil &&
           self.ppButtonImageRectification!=nil &&
           self.ppButtonFullRect!=nil)
        {
            [self.ppBottomBarView setViews:@[self.ppButtonImageLightable,self.ppButtonFullRect,self.ppButtonImageRectification]
                              forBlockType:PPBarViewBlockType_Center];
        }
    }
    
    //////////////////////////////////////////////////
    
    self.ppImageScrollCropView.imageMode          = PPImageScrollViewImageMode_ScaleAspectRecessed;
    self.ppImageScrollCropView.rectCropMode       = NO;
    self.ppImageScrollCropView.moveCropViewEnable = YES;
    self.ppImageScrollCropView.cropViewHidden     = YES;
    self.ppImageScrollCropView.image              = self.sourceImage;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [self.view setNeedsUpdateConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self.ppImageScrollCropView removeFromSuperview];
    self.ppImageScrollCropView = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.navigationItem!=nil)
    {
        self.navigationItem.leftBarButtonItem = nil;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView        = nil;
    
    [self.ppButtonImageLightable removeFromSuperview];
    self.ppButtonImageLightable     = nil;
    
    [self.ppButtonImageRectification removeFromSuperview];
    self.ppButtonImageRectification = nil;
    
    [self.ppButtonBack removeFromSuperview];
    self.ppButtonBack               = nil;
    
    [self.ppButtonCancel removeFromSuperview];
    self.ppButtonCancel             = nil;
    
    [self.ppButtonDone removeFromSuperview];
    self.ppButtonDone               = nil;
    
    [self.ppBottomBarView removeFromSuperview];
    self.ppBottomBarView = nil;
    
    [self.ppButtonFullRect removeFromSuperview];
    self.ppButtonFullRect = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events

//================================================================================
//
//================================================================================
- (BOOL)shouldAutorotate
{
    if(self.ppBusyView!=nil)
    {
        return NO;
    }
    
    return [super shouldAutorotate];
}


//================================================================================
// after ios 8 
//================================================================================
- (void)viewWillTransitionToSize:(CGSize)size withTransitionCoordinator:(id<UIViewControllerTransitionCoordinator>)coordinator
{
    [super viewWillTransitionToSize:size withTransitionCoordinator:coordinator];
    
    //////////////////////////////////////////////////
    
    [self.ppImageScrollCropView getCropPointsOnOriginalImage:&cropPoints_];
    
    //////////////////////////////////////////////////

    self.needUpdateCropViewFrame = YES;
}


//================================================================================
// ios 7,8
//================================================================================
- (void)willRotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
    [super willRotateToInterfaceOrientation:toInterfaceOrientation duration:duration];
    
    //////////////////////////////////////////////////

    [self.ppImageScrollCropView getCropPointsOnOriginalImage:&cropPoints_];

    //////////////////////////////////////////////////
    
    self.needUpdateCropViewFrame = YES;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overriding Methods

//================================================================================
//
//================================================================================
- (void)viewDidLayoutSubviews
{
    [super viewDidLayoutSubviews];
    
    //////////////////////////////////////////////////

    [self.ppImageScrollCropView layoutImageView];
    
    //////////////////////////////////////////////////

    if(self.needUpdateCropViewFrame==YES)
    {
        self.needUpdateCropViewFrame = NO;
        
        //////////////////////////////////////////////////

        [self.ppImageScrollCropView setInitCropPoints:cropPoints_];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods

//================================================================================
//
//================================================================================
- (void)setExecuted:(BOOL)executed
{
    _executed = executed;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(self.executed==YES)
    {
 
    }
    else
    {
        [self.ppNavigationBarView setViews:[NSArray arrayWithObjects:self.ppButtonBack, nil]
                              forBlockType:PPBarViewBlockType_Left];
        [self.ppNavigationBarView setViews:[NSArray arrayWithObjects:self.ppButtonDone, nil]
                              forBlockType:PPBarViewBlockType_Right];
        
        self.ppBottomBarView.hidden = NO;
        
        //////////////////////////////////////////////////
        
        [self.view setNeedsUpdateConstraints];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [self.ppNavigationBarView layoutSubviews];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIConstraintBasedLayoutCoreMethods

//================================================================================
//
//================================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    
    //////////////////////////////////////////////////

    do
    {
        if(self.ppButtonImageLightable==nil ||
           self.ppButtonImageRectification==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        for(NSLayoutConstraint *layoutConstraint in self.layoutConstraints)
        {
            if([self.view.constraints indexOfObject:layoutConstraint]!=NSNotFound)
            {
                [self.view removeConstraint:layoutConstraint];
            }
        }
        
        //////////////////////////////////////////////////
        
        self.layoutConstraints = [NSMutableArray array];
        
        if(self.layoutConstraints==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        NSDictionary *viewDictionary = @{@"BottomBarView":self.ppBottomBarView,
                                         @"ImageScrollCropView":self.ppImageScrollCropView};
        
        if(viewDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSInteger bottomBarViewHeight = self.navigationController.navigationBar.bounds.size.height;
        
        if (@available(iOS 11, *))
        {
            bottomBarViewHeight += self.view.safeAreaInsets.bottom;
            self.ppBottomBarView.addtionBlockEdgeInsets = UIEdgeInsetsMake(0, 0, self.view.safeAreaInsets.bottom, 0);
        }
        
        NSDictionary *heightDictionary = @{@"BottomBarViewHeight":@(bottomBarViewHeight)};
        
        if(heightDictionary==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        [self.layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[ImageScrollCropView]|"
                                                                                            options:NSLayoutFormatAlignAllBaseline
                                                                                            metrics:nil
                                                                                              views:viewDictionary]];
        
        [self.layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[BottomBarView]|"
                                                                                           options:NSLayoutFormatAlignAllBaseline
                                                                                           metrics:nil
                                                                                             views:viewDictionary]];
        
        [self.layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:[BottomBarView(BottomBarViewHeight)]|"
                                                                                            options:NSLayoutFormatAlignAllBaseline
                                                                                            metrics:heightDictionary
                                                                                              views:viewDictionary]];
        
    
        if(self.ppBottomBarView.hidden==NO)
        {
            [self.layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ImageScrollCropView][BottomBarView]|"
                                                                                                options:NSLayoutFormatAlignAllLeft
                                                                                                metrics:nil
                                                                                                  views:viewDictionary]];
        }
        else
        {
            [self.layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|[ImageScrollCropView]|"
                                                                                                options:NSLayoutFormatAlignAllLeft
                                                                                                metrics:nil
                                                                                                  views:viewDictionary]];
        }

        
        //////////////////////////////////////////////////
        
        [self.view addConstraints:self.layoutConstraints];

    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////


#pragma mark - Thread Methods

//================================================================================
//
//================================================================================
- (void)terminateThreadExecute
{
    [self.ppBusyView removeFromSuperview];
    self.ppBusyView = nil;
}


//================================================================================
//
//================================================================================
- (void)launchThreadExecuteWithObject:(id)object
{
	[self terminateThreadExecute];
	
    //////////////////////////////////////////////////

    self.ppBusyView = [[[PPBusyView alloc] initWithSuperView:[UIApplication sharedApplication].keyWindow] autorelease];

    //////////////////////////////////////////////////
    
    __block typeof(self) blockself = self;
    
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        do
        {
            if(blockOperation.isCancelled==YES)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            @autoreleasepool
            {
                switch([object integerValue])
                {
                    case ImageEnhanceViewControllerAction_Clip:
                    {
                        [blockself.ppImageScrollCropView getCropPointsOnOriginalImage:&cropPoints_];
                        
                        PPQuadrilateralModel *quadrilateralModel = [[PPQuadrilateralModel alloc] init];
                        
                        if(quadrilateralModel!=nil)
                        {
                            quadrilateralModel.topLeft     = cropPoints_.ptLeftTop;
                            quadrilateralModel.topRight    = cropPoints_.ptRightTop;
                            quadrilateralModel.bottomLeft  = cropPoints_.ptLeftBottom;
                            quadrilateralModel.bottomRight = cropPoints_.ptRightBottom;
                        }
                        
                        blockself.executeImage = [PPImageEnhanceController deskewImage:blockself.executeImage withQuadrilateralModel:quadrilateralModel];
                        
                        [quadrilateralModel release];
                        
                        break;
                    }
                    case ImageEnhanceViewControllerAction_Light:
                    {
                        blockself.executeImage = [PPImageEnhanceController lightCorrectImage:blockself.executeImage
                                                                            progressingBlock:^(CGFloat progress){
                                                                                [PPBusyView postMessage:[NSString stringWithFormat:@"%d%%", (int)(progress*100)]];
                                                                            }];
                        
                        break;
                    }
                    default:
                    {
                        break;
                    }
                }
            }
        }
        while (0);
        
        //////////////////////////////////////////////////
        
        [blockself performSelectorOnMainThread:@selector(mainThreadCompleteExecute:) withObject:nil waitUntilDone:NO];
    }];
    
    //////////////////////////////////////////////////
    
    if(blockOperation!=nil)
    {
        @synchronized(self.workingOperationQueue)
        {
            [self.workingOperationQueue cancelAllOperations];
            [self.workingOperationQueue addOperation:blockOperation];
        }
    }
    else
    {
        [self mainThreadCompleteExecute:nil];
    }
}


//================================================================================
//
//================================================================================
- (void)mainThreadCompleteExecute:(id)object
{
    [self terminateThreadExecute];
    
    self.executed                       = YES;
    self.ppImageScrollCropView.image    = self.executeImage;
}


//================================================================================
//
//================================================================================
- (void)terminateThreadInitCrop
{
    [self.ppBusyView removeFromSuperview];
    self.ppBusyView = nil;
}


//================================================================================
//
//================================================================================
- (void)launchThreadInitCrop
{
	[self terminateThreadInitCrop];
	
    //////////////////////////////////////////////////
    
    self.ppBusyView = [[[PPBusyView alloc] initWithSuperView:[UIApplication sharedApplication].keyWindow] autorelease];
    
    //////////////////////////////////////////////////

    __block typeof(self) blockself = self;
    
    __block NSBlockOperation *blockOperation = [NSBlockOperation blockOperationWithBlock:^{
        
        do
        {
            if(blockOperation.isCancelled==YES)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            @autoreleasepool
            {
                CGSize  scaleSize   = ImageEnhanceControllerImageSize_Medium;
                UIImage *scaleImage = nil;
                
                if(MAX(blockself.sourceImage.size.width,blockself.sourceImage.size.height)>MAX(scaleSize.width,scaleSize.height))
                {
                    scaleImage = [self.executeImage imageScalingMaxLength:MAX(scaleSize.width, scaleSize.height)];
                }
                else
                {
                    scaleImage = self.executeImage;
                }
                
                //////////////////////////////////////////////////
                
                PPQuadrilateralModel *quadrilateralModel = [PPImageEnhanceController houghTransformQuadrilateralModelForImage:scaleImage];
                
                if(quadrilateralModel!=nil)
                {
                    CGFloat scaleX = self.executeImage.size.width/scaleImage.size.width;
                    CGFloat scaleY = self.executeImage.size.height/scaleImage.size.height;
                    
                    cropPoints_.ptLeftTop        = CGPointMake(quadrilateralModel.topLeft.x*scaleX, quadrilateralModel.topLeft.y*scaleY);
                    cropPoints_.ptRightTop       = CGPointMake(quadrilateralModel.topRight.x*scaleX, quadrilateralModel.topRight.y*scaleY);
                    cropPoints_.ptLeftBottom     = CGPointMake(quadrilateralModel.bottomLeft.x*scaleX, quadrilateralModel.bottomLeft.y*scaleY);
                    cropPoints_.ptRightBottom    = CGPointMake(quadrilateralModel.bottomRight.x*scaleX, quadrilateralModel.bottomRight.y*scaleY);
                }
                else
                {
                    cropPoints_.ptLeftTop        = CGPointMake(0, 0);
                    cropPoints_.ptRightTop       = CGPointMake(self.executeImage.size.width, 0);
                    cropPoints_.ptLeftBottom     = CGPointMake(0, self.executeImage.size.height);
                    cropPoints_.ptRightBottom    = CGPointMake(self.executeImage.size.width, self.executeImage.size.height);
                }
            }
        }
        while (0);
        
        //////////////////////////////////////////////////

        [blockself performSelectorOnMainThread:@selector(mainThreadCompleteInitCrop:) withObject:nil waitUntilDone:NO];
    }];
    
    //////////////////////////////////////////////////

    if(blockOperation!=nil)
    {
        @synchronized(self.workingOperationQueue)
        {
            [self.workingOperationQueue cancelAllOperations];
            [self.workingOperationQueue addOperation:blockOperation];
        }
    }
    else
    {
        [self mainThreadCompleteInitCrop:nil];
    }
}


//================================================================================
//
//================================================================================
- (void)mainThreadCompleteInitCrop:(id)object
{
    [self terminateThreadInitCrop];
    
    self.ppImageScrollCropView.image            = self.executeImage;
    self.ppImageScrollCropView.cropViewHidden   = NO;
    
    [self.ppImageScrollCropView setInitCropPoints:cropPoints_];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setSourceImage:(UIImage *)sourceImage
{
    [sourceImage retain];
    
    [_sourceImage release];
    
    _sourceImage = sourceImage;
    
    //////////////////////////////////////////////////

    self.executeImage = sourceImage;
}


//================================================================================
//
//================================================================================
- (void)setButtonImageEdgeInsets:(UIEdgeInsets)buttonImageEdgeInsets
{
    _buttonImageEdgeInsets = buttonImageEdgeInsets;
}


//================================================================================
//
//================================================================================
- (void)setButtonHighlightedBackgroundColor:(UIColor *)buttonHighlightedBackgroundColor
{
    [_buttonHighlightedBackgroundColor release];
    _buttonHighlightedBackgroundColor = [buttonHighlightedBackgroundColor retain];
}


//================================================================================
//
//================================================================================
- (void)setBottomBarViewBackgroundColor:(UIColor *)bottomBarViewBackgroundColor
{
    [_bottomBarViewBackgroundColor release];
    _bottomBarViewBackgroundColor = [bottomBarViewBackgroundColor retain];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAppearance protocol methods

//================================================================================
//
//================================================================================
+ (id)appearance
{
    // MARK: 實作+appearance的方式固定如下
    return [PPAppearance appearanceForClass:[self class]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    self.buttonClickTag = ppButton.tag;
    
	switch(ppButton.tag)
	{
		case ImageEnhanceViewControllerButtonTag_Back:
        {
            //放棄此次編輯, 圖檔還原
            self.executeImage = self.sourceImage;
            self.ppImageScrollCropView.image = self.sourceImage;
            
            //////////////////////////////////////////////////

            [self goBackAnimated:YES];
            
            break;
        }
        case ImageEnhanceViewControllerButtonTag_Cancel:
        {
            self.executed                       = NO;
            self.ppImageScrollCropView.image    = self.sourceImage;
            
            [self.ppImageScrollCropView setInitCropPoints:cropPoints_];
            
            break;
        }
		case ImageEnhanceViewControllerButtonTag_Done:
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(imageEnhanceViewController:action:)]==YES) 
            {
                self.sourceImage = self.executeImage;
                
                [self.delegate imageEnhanceViewController:self
                                                   action:ImageEnhanceViewControllerAction_Done];
            }
            
            break;
        }
        case ImageEnhanceViewControllerButtonTag_Light:
        {
            self.ppButtonDone.hidden = NO;
            
            //////////////////////////////////////////////////
            BOOL result = YES;
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(imageEnhanceViewController:action:)]==YES)
            {
                result = [self.delegate imageEnhanceViewController:self
                                                   action:ImageEnhanceViewControllerAction_Light];
            }
            
            
            if (result)
            {
                // Howard 特殊作法，鎖定發亮的圖
                [self.ppButtonImageLightable setImage:[UIImage imageWithName:ImageNamePPImageEnhancenViewControllerButtonLight
                                                                    forState:UIControlStateHighlighted]
                                             forState:UIControlStateNormal];
                
                
                self.ppButtonImageLightable.userInteractionEnabled = NO;
                
                //////////////////////////////////////////////////
                
                [self launchThreadExecuteWithObject:@(ImageEnhanceViewControllerAction_Light)];
            }
            break;
        }
        case ImageEnhanceViewControllerButtonTag_ImageRectification:
        {
            self.ppButtonDone.hidden = NO;
            
            //////////////////////////////////////////////////
            BOOL result = YES;
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(imageEnhanceViewController:action:)]==YES)
            {
                result = [self.delegate imageEnhanceViewController:self
                                                            action:ImageEnhanceViewControllerAction_Clip];
            }
            
            if (result)
            {
                [self launchThreadExecuteWithObject:@(ImageEnhanceViewControllerAction_Clip)];
            }
            
            break;
        }
        case ImageEnhanceViewControllerButtonTag_FullRect:
        {
            cropPoints_.ptLeftTop        = CGPointMake(0, 0);
            cropPoints_.ptRightTop       = CGPointMake(self.executeImage.size.width, 0);
            cropPoints_.ptLeftBottom     = CGPointMake(0, self.executeImage.size.height);
            cropPoints_.ptRightBottom    = CGPointMake(self.executeImage.size.width, self.executeImage.size.height);
            
            //////////////////////////////////////////////////

            [self.ppImageScrollCropView setInitCropPoints:cropPoints_];
            
            break;
        }
		default:
		{
			break;
		}
	}
}




@end
