//
//  PPGuideMaskView.m
//
//  Created by eddie on 2015/4/6.
//  Copyright (c) 2015年 eddie. All rights reserved.
//

#import "PPGuideMaskView.h"
#import "UIColor+BlendColor.h"

@interface PPGuideMaskView ()
@end

@implementation PPGuideMaskView

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame])
    {
//        self.userInteractionEnabled = NO;
    }
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.maskColor = nil;
    self.transparentPath = nil;
    self.focusImage = nil;
    self.focusColor = nil;
    
    [super dealloc];
}


//================================================================================
//
//================================================================================
- (void)drawRect:(CGRect)rect
{
    if(self.hideTarget)
    {
        [self.maskColor setFill];
        UIRectFill(rect);
    }
    else
    {
        CGContextRef context = UIGraphicsGetCurrentContext();
        
        CGContextSaveGState(context);
        
        //////////////////////////////////////////////////
        
        // set clip path
        if(self.transparentPath)
        {
            UIBezierPath *clipPath = [UIBezierPath bezierPathWithRect:CGRectInfinite];
            [clipPath appendPath:self.transparentPath];
            [clipPath setUsesEvenOddFillRule:YES];
            [clipPath addClip];
        }
    
        // set mask color
        [self.maskColor setFill];
        UIRectFill(rect);
        
        //////////////////////////////////////////////////

        switch (self.focusStyle)
        {
            case PPGuideFocusStyle_Image:
            {
                // set focus image
                [self.focusImage drawInRect:self.focusFrame];
                break;
            }
                
            case PPGuideFocusStyle_DoubleRing:
            {
                CGRect innerRect = self.transparentPath.bounds;
                CGFloat effectLength = 100;
                CGFloat blendRatio = 0.6;
                UIColor *mainColor = self.focusColor;
                UIColor *clearColor = [UIColor clearColor];
                CGRect drawRect;
                UIBezierPath *drawPath;
                UIColor *drawColor;
                CGFloat resetLength = 16.0;
                
                
                for(CGFloat i=0.0; i<effectLength; i+=0.5)
                {
                    drawRect = CGRectInset(innerRect, -i, -i);
                    drawPath = [UIBezierPath bezierPathWithOvalInRect:drawRect];

                    if(i<= resetLength)
                    {
                        drawColor = [mainColor colorWithBlendColor:clearColor ratio:(1.0-blendRatio)];
                        
                        if(i < resetLength)
                        {
                            blendRatio *= 0.9;
                        }
                        else
                        {
                            blendRatio = 0.4;
                        }
                    }
                    else
                    {
                        drawColor = [mainColor colorWithBlendColor:clearColor ratio:(1.0-blendRatio)];
                        
                        blendRatio *= 0.92;
                    }
                    
//                        NSLog(@"i:%f blendRatio:%f", i, blendRatio);
                    
                    [drawColor setStroke];
                    [drawPath setLineWidth:0.9]; // 設成小於1.0色差才不會太明顯
                    [drawPath stroke];
                }

                break;
            }
                
            default:
                break;
        }
        
        //////////////////////////////////////////////////
        
        CGContextRestoreGState(context);
    }
    
}

@end
