//
//  PPGuideDataModel.m
//
//  Created by eddie on 2015/4/3.
//  Copyright (c) 2015年 eddie. All rights reserved.
//

#import "PPGuideDataModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPGuideDataModel ()
@property (nonatomic, retain, readwrite) PPGuideFocusModel *guideFocusModel;
@property (nonatomic, retain, readwrite) NSString   *className;
@property (nonatomic, assign, readwrite) NSInteger  guideIndex;
@property (nonatomic, retain, readwrite) NSString   *title;
@property (nonatomic, retain, readwrite) NSString   *message;
@property (nonatomic, assign, readwrite) PPGuideDataModel_LayoutDirection layoutDirection;
@property (nonatomic, assign, readwrite) PPGuideDataModel_SpecialStyle specialStyle;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGuideDataModel


////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Life cycle methods

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.guideFocusModel = nil;
    self.className = nil;
    self.title = nil;
    self.message = nil;
    self.targetView = nil;
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Class methods

//================================================================================
//
//================================================================================
+ (PPGuideDataModel *)modelWithTargetClassName:(NSString *)className
                                    guideIndex:(NSInteger)guideIndex
                                         title:(NSString *)title
                                       message:(NSString *)message
                               layoutDirection:(PPGuideDataModel_LayoutDirection)layoutDirection
{
    //////////////////////////////////////////////////

    NSAssert(!(guideIndex <= PPGuideDataModel_ReservedIndex_Begin && guideIndex >= PPGuideDataModel_ReservedIndex_Begin),
             @"!! Do not use reserved guideIndex !!");
    
    //////////////////////////////////////////////////

    PPGuideDataModel *model = [[PPGuideDataModel alloc] init];
    
    if(model != nil)
    {
        model.className = className;
        model.guideIndex = guideIndex;
        model.title = title;
        model.message = message;
        model.layoutDirection = layoutDirection;
        model.specialStyle = PPGuideDataModel_SpecialStyle_None;
    }
    
    return [model autorelease];
}


//================================================================================
//
//================================================================================
+ (PPGuideDataModel *)modelWithGuideFocusModel:(PPGuideFocusModel *)guideFocusModel
                               targetClassName:(NSString *)className
                                    guideIndex:(NSInteger)guideIndex
                                         title:(NSString *)title
                                       message:(NSString *)message
                               layoutDirection:(PPGuideDataModel_LayoutDirection)layoutDirection
{
    PPGuideDataModel *model = [[PPGuideDataModel alloc] init];
    
    if(model != nil)
    {
        model.guideFocusModel = guideFocusModel;
        model.className = className;
        model.guideIndex = guideIndex;
        model.title = title;
        model.message = message;
        model.layoutDirection = layoutDirection;
        model.specialStyle = PPGuideDataModel_SpecialStyle_None;
    }
    
    return [model autorelease];
}


//================================================================================
//
//================================================================================
+ (PPGuideDataModel *)modelWithGuideFocusModel:(PPGuideFocusModel *)guideFocusModel
                               targetClassName:(NSString *)className
                                    guideIndex:(NSInteger)guideIndex
                                         title:(NSString *)title
                                       message:(NSString *)message
                               layoutDirection:(PPGuideDataModel_LayoutDirection)layoutDirection
                                  specialStyle:(PPGuideDataModel_SpecialStyle)specialStyle
{
    PPGuideDataModel *model = [[PPGuideDataModel alloc] init];
    
    if(model != nil)
    {
        model.guideFocusModel = guideFocusModel;
        model.className = className;
        model.guideIndex = guideIndex;
        model.title = title;
        model.message = message;
        model.layoutDirection = layoutDirection;
        model.specialStyle = specialStyle;
    }
    
    return [model autorelease];
}


@end
