//
//  OIDAuthState+IncrementalAuthorization.h
//
//
//  Created by Howard on 2019/4/23.
//

#import "OIDAuthState.h"

typedef void (^OIDAuthStateIncrementalAuthorizationCallback)(BOOL success,
                                                             NSError *error);


@interface OIDAuthState (IncrementalAuthorization)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (OIDAuthorizationRequest *)incrementalAuthorizationRequestWithScopes:
(NSArray<NSString *> *)scopes
                                                           additionalParameters:(NSDictionary<NSString *, NSString *> *)additionalParameters;


//================================================================================
//
//================================================================================
- (id<OIDExternalUserAgentSession>)
presentIncrementalAuthorizationRequest:(OIDAuthorizationRequest *)incrementalAuthorizationRequest
externalUserAgent:(id<OIDExternalUserAgent>)externalUserAgent
callback:(OIDAuthStateIncrementalAuthorizationCallback)callback;

@end

