//
//  PPEncodeController.h
//
//
//  Created by  Eddie  on 2011/12/22.
//  Fixed   by  Howard on 2013/09/09.
//  Copyright (c) 2011年 Penpower. All rights reserved.
//
//  porting from knight's EasyEncode/PPRc4 C++ class
//


typedef struct _RC4_KEY
{
    Byte bySTab[256];   //256位元組的S表
    Byte byIt,byJt;     //t時刻的兩個指針
} 
RC4_KEY,*PRC4_KEY;

////////////////////////////////////////////////////////////////////////////////////////////////////

#import <Foundation/Foundation.h>

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPEncodeController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

/**
 *
 */
+ (Byte *)allocHexBytesFromHexCharData:(char *)inData 
                               dataLen:(int)dataLen 
                                retLen:(int *)retLen;


/**
 * porting from EasyEncodeEx_Bin
 */
+ (Byte *)allocEncodeDataWithSource:(Byte *)sourceByte 
                          sourceLen:(int)sourceLen 
                            keyByte:(Byte *)keyByte 
                             keyLen:(int)keyLen 
                             retLen:(int *)retLen;


/**
 *  porting from EasyDecodeEx_Bin
 */
+ (Byte *)allocDecodeDataWithSource:(Byte *)sourceByte 
                          sourceLen:(int)sourceLen 
                            keyByte:(Byte *)keyByte 
                             keyLen:(int)keyLen
                             retLen:(int *)retLen;


/**
 *
 */
+ (BOOL)RC4Init:(char *)pszKey keyLen:(int)nKeyLen key:(RC4_KEY *)key;


/**
 *
 */
+ (BOOL)RC4Works:(Byte *)pbyData dataLen:(int)nDataLen key:(RC4_KEY *)key;

@end
