//
//  PPEditableViewController.m
//  
//
//  Created by Mike on 13/5/13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPEditableViewController.h"

@interface PPEditableViewController ()
@property(nonatomic,readwrite,retain) UITapGestureRecognizer *singleTapGestureRecognizer;
@end

@implementation PPEditableViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize singleTapGestureRecognizer          = singleTapGestureRecognizer_;
@synthesize singleTapResignFirstResponderEnable = singleTapResignFirstResponderEnable_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
	self.singleTapResignFirstResponderEnable = NO;
	
    //////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
	
    //////////////////////////////////////////////////
    
    [self setSingleTapResignFirstResponderEnable:self.singleTapResignFirstResponderEnable];
    
    //////////////////////////////////////////////////
    
    if([self privatePopoverController]==nil)
    {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillShowNotification:)    name:UIKeyboardWillShowNotification object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardDidShowNotification:)     name:UIKeyboardDidShowNotification  object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardWillHideNotification:)    name:UIKeyboardWillHideNotification object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(keyboardDidHideNotification:)     name:UIKeyboardDidHideNotification  object:nil];
    }
}

//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    if([self privatePopoverController]==nil)
    {
        [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillShowNotification   object:nil];
        [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardDidShowNotification    object:nil];
        [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardWillHideNotification   object:nil];
        [[NSNotificationCenter defaultCenter] removeObserver:self name:UIKeyboardDidHideNotification    object:nil];
    }
    
    //////////////////////////////////////////////////
    
    self.singleTapResignFirstResponderEnable = NO;
    
    //////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (void)setSingleTapResignFirstResponderEnable:(BOOL)singleTapResignFirstResponderEnable
{
    singleTapResignFirstResponderEnable_ = singleTapResignFirstResponderEnable;
    
    //////////////////////////////////////////////////
    
    if(self.singleTapResignFirstResponderEnable==YES)
    {
        if(self.singleTapGestureRecognizer==nil)
        {
            singleTapGestureRecognizer_ = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(singleTapNotify:)];
            if(singleTapGestureRecognizer_!=nil)
            {
                singleTapGestureRecognizer_.delegate                = self;
                singleTapGestureRecognizer_.numberOfTapsRequired    = 1;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(self.view!=nil && self.singleTapGestureRecognizer!=nil)
        {
            [self.view addGestureRecognizer:self.singleTapGestureRecognizer];
        }
    }
    else
    {
        if(self.singleTapGestureRecognizer!=nil)
        {
            if(self.view!=nil)
            {
                [self.view removeGestureRecognizer:self.singleTapGestureRecognizer];
            }
            
            self.singleTapGestureRecognizer = nil;
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Gesture Methods

//================================================================================
//
//================================================================================
- (void)singleTapNotify:(id)sender
{
    
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Methods

//================================================================================
//
//================================================================================
- (void)keyboardWillShowNotification:(NSNotification *)notification
{

}

//================================================================================
//
//================================================================================
- (void)keyboardDidShowNotification:(NSNotification *)notification
{

}

//================================================================================
//
//================================================================================
- (void)keyboardWillHideNotification:(NSNotification *)notification
{

}

//================================================================================
//
//================================================================================
- (void)keyboardDidHideNotification:(NSNotification *)notification
{

}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIGestureRecognizerDelegate

//================================================================================
//
//================================================================================
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
	return ([touch.view conformsToProtocol:@protocol(UITextInput)]==NO && [touch.view isKindOfClass:[UIControl class]]==NO);
}

@end
