//
//  PPEditableTableViewController.m
//  
//
//  Created by Mike on 13/5/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPEditableTableViewController.h"
#import "UIViewController+ShareApplication.h"


@interface PPEditableTableViewController ()
@property(nonatomic,readwrite,retain) PPTableView *ppTableView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPEditableTableViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize
ppTableView     = ppTableView_,
tableViewStyle  = tableViewStyle_;

////////////////////////////////////////////////////////////////////////////////////////////////////


//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self.ppTableView removeFromSuperview];
    self.ppTableView = nil;
    //////////////////////////////////////////////////
    [super dealloc];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
	[super viewWillAppear:animated];
	
    //////////////////////////////////////////////////
    
	ppTableView_ = [[PPTableView alloc] initWithFrame:self.view.bounds style:self.tableViewStyle];
    if(ppTableView_!=nil)
    {
        [self.view addSubview:ppTableView_];
    }
}

//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self.ppTableView setDataSource:nil];
    [self.ppTableView setDelegate:nil];
    
	[self.ppTableView removeFromSuperview];
    self.ppTableView = nil;
    
    //////////////////////////////////////////////////
    
	[super viewDidDisappear:animated];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overriding Methods

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////
     
	self.ppTableView.frame = [self layoutFrame];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Gesture Methods

//================================================================================
//
//================================================================================
- (void)singleTapNotify:(id)sender
{
    UIView *firstResponderView = [self.ppTableView firstResponderView];
    if(firstResponderView!=nil)
    {
        [firstResponderView resignFirstResponder];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification Methods

//================================================================================
//
//================================================================================
- (void)keyboardWillShowNotification:(NSNotification *)notification
{
    [super keyboardWillShowNotification:notification];
    
    //////////////////////////////////////////////////
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationCurve:[[[notification userInfo] objectForKey:UIKeyboardAnimationCurveUserInfoKey] intValue]];
    [UIView setAnimationDuration:[[[notification userInfo] objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue]];
    
    CGRect keyboardRectBegin    = CGRectZero;
    CGRect keyboardRectEnd      = CGRectZero;
    
    [[[notification userInfo] objectForKey:UIKeyboardFrameBeginUserInfoKey] getValue:&keyboardRectBegin];
    [[[notification userInfo] objectForKey:UIKeyboardFrameEndUserInfoKey] getValue:&keyboardRectEnd];

    //MARK: Howard IOS 7.0，用 Popopver 包進來的會被系統判斷成 UIModalPresentationPageSheet;
    // !! sanhue ios 8以下， self.navigationController.modalPresentationStyle會變 UIModalPresentationFullScreen, 所以 要特殊處理
    // 沒有出現howard說的情況，可能是在其他狀況下，要再注意
    if(self.navigationController.modalPresentationStyle==UIModalPresentationPopover ||
       self.navigationController.modalPresentationStyle==UIModalPresentationFormSheet)
    {
        CGRect dropShadowViewFrame = self.navigationController.view.superview.frame;
        
        switch(self.interfaceOrientation)
        {
            case UIInterfaceOrientationPortrait:
            {
                if(keyboardRectBegin.size.height==keyboardRectEnd.size.height)
                {
                    dropShadowViewFrame.size.height = dropShadowViewFrame.size.height-keyboardRectEnd.size.height;
                }
                else
                {
                    dropShadowViewFrame.size.height = dropShadowViewFrame.size.height-keyboardRectEnd.size.height+keyboardRectBegin.size.height;
                }
                
                dropShadowViewFrame.origin.y = [UIScreen mainScreen].applicationFrame.origin.y+(([UIScreen mainScreen].applicationFrame.size.height-keyboardRectEnd.size.height-dropShadowViewFrame.size.height)/2);
                
                break;
            }
            case UIInterfaceOrientationPortraitUpsideDown:
            {
                if(keyboardRectBegin.size.height==keyboardRectEnd.size.height)
                {
                    dropShadowViewFrame.size.height = dropShadowViewFrame.size.height-keyboardRectEnd.size.height;
                }
                else
                {
                    dropShadowViewFrame.size.height = dropShadowViewFrame.size.height-keyboardRectEnd.size.height+keyboardRectBegin.size.height;
                }
                
                dropShadowViewFrame.origin.y = [UIScreen mainScreen].applicationFrame.origin.y+(([UIScreen mainScreen].applicationFrame.size.height-keyboardRectEnd.size.height-dropShadowViewFrame.size.height)/2)+keyboardRectEnd.size.height;
                
                break;
            }
            case UIInterfaceOrientationLandscapeLeft:
            {
                if(keyboardRectBegin.size.width==keyboardRectEnd.size.width)
                {
                    dropShadowViewFrame.size.width = dropShadowViewFrame.size.width-keyboardRectEnd.size.width;
                }
                else
                {
                    dropShadowViewFrame.size.width = dropShadowViewFrame.size.width-keyboardRectEnd.size.width+keyboardRectBegin.size.width;
                }
                
                dropShadowViewFrame.origin.x = [UIScreen mainScreen].applicationFrame.origin.x+(([UIScreen mainScreen].applicationFrame.size.width-keyboardRectEnd.size.width-dropShadowViewFrame.size.width)/2);
                
                break;
            }
            case UIInterfaceOrientationLandscapeRight:
            {
                if(keyboardRectBegin.size.width==keyboardRectEnd.size.width)
                {
                    dropShadowViewFrame.size.width = dropShadowViewFrame.size.width-keyboardRectEnd.size.width;
                }
                else
                {
                    dropShadowViewFrame.size.width = dropShadowViewFrame.size.width-keyboardRectEnd.size.width+keyboardRectBegin.size.width;
                }
                
                dropShadowViewFrame.origin.x = [UIScreen mainScreen].applicationFrame.origin.x+(([UIScreen mainScreen].applicationFrame.size.width-keyboardRectEnd.size.width-dropShadowViewFrame.size.width)/2)+keyboardRectEnd.size.width;
                
                break;
            }
            default:
            {
                break;
            }
        }
        
        self.navigationController.view.superview.frame = dropShadowViewFrame;
        
        self.ppTableView.frame = [self layoutFrame];
    
    }
    else if(self.navigationController.modalPresentationStyle==UIModalPresentationFullScreen &&
             UI_USER_INTERFACE_IDIOM()==UIUserInterfaceIdiomPad &&
            [[[UIDevice currentDevice] systemVersion] floatValue]>=8.0)
    {
        //Howard IOS8 鍵盤在不同方向,寬高都是不同方向
        CGRect editTableViewFrame = [self layoutFrame];
    
        editTableViewFrame.size.height = editTableViewFrame.size.height-keyboardRectEnd.size.height;

        self.ppTableView.frame = editTableViewFrame;
    }
    else
    {
        CGRect editTableViewFrame = [self layoutFrame];
        
        //Howard IOS7鍵盤在不同方向,寬高都是同方向
        switch(self.interfaceOrientation)
        {
            case UIInterfaceOrientationLandscapeLeft:
            case UIInterfaceOrientationLandscapeRight:
            {
                editTableViewFrame.size.height = editTableViewFrame.size.height-keyboardRectEnd.size.width;

                break;
            }
            case UIInterfaceOrientationPortrait:
            case UIInterfaceOrientationPortraitUpsideDown:
            default:
            {
                editTableViewFrame.size.height = editTableViewFrame.size.height-keyboardRectEnd.size.height;

                break;
            }
        }
        
        self.ppTableView.frame = editTableViewFrame;
    }

    [UIView commitAnimations];
    
    //////////////////////////////////////////////////
    
    if(self.ppTableView.contentSize.height>self.ppTableView.bounds.size.height)
    {
        NSArray *cells = [self.ppTableView visibleCells];
        
        for (UITableViewCell *cell in cells)
        {
            UIView *firstResponderView = [cell firstResponderView];
            if(firstResponderView!=nil)
            {
                [self.ppTableView scrollToRowAtIndexPath:[self.ppTableView indexPathForCell:cell]
                                        atScrollPosition:UITableViewScrollPositionMiddle
                                                animated:YES];
                
                break;
            }
        }
    }
}

//================================================================================
//
//================================================================================
- (void)keyboardWillHideNotification:(NSNotification *)notification
{
    [super keyboardWillHideNotification:notification];
    
    //////////////////////////////////////////////////
    
    [UIView beginAnimations:nil context:NULL];
    [UIView setAnimationCurve:[[[notification userInfo] objectForKey:UIKeyboardAnimationCurveUserInfoKey] intValue]];
    [UIView setAnimationDuration:[[[notification userInfo] objectForKey:UIKeyboardAnimationDurationUserInfoKey] doubleValue]];
    
    CGRect keyboardRectBegin = CGRectZero;
    
    [[[notification userInfo] objectForKey:UIKeyboardFrameBeginUserInfoKey] getValue:&keyboardRectBegin];
 
    //////////////////////////////////////////////////
    
    if(self.navigationController.modalPresentationStyle==UIModalPresentationPopover ||
       self.navigationController.modalPresentationStyle==UIModalPresentationFormSheet)
    {
            CGRect dropShadowViewFrame = self.navigationController.view.superview.frame;
            
            switch(self.interfaceOrientation)
            {
                case UIInterfaceOrientationPortrait:
                case UIInterfaceOrientationPortraitUpsideDown:
                {
                    dropShadowViewFrame.size.height = dropShadowViewFrame.size.height+keyboardRectBegin.size.height;
                    dropShadowViewFrame.origin.y    = [UIScreen mainScreen].applicationFrame.origin.y+(([UIScreen mainScreen].applicationFrame.size.height-dropShadowViewFrame.size.height)/2);
                    
                    break;
                }
                case UIInterfaceOrientationLandscapeLeft:
                case UIInterfaceOrientationLandscapeRight:
                {
                    dropShadowViewFrame.size.width  = dropShadowViewFrame.size.width+keyboardRectBegin.size.width;
                    dropShadowViewFrame.origin.x    = [UIScreen mainScreen].applicationFrame.origin.x+(([UIScreen mainScreen].applicationFrame.size.width-dropShadowViewFrame.size.width)/2);
                    
                    break;
                }
                default:
                {
                    break;
                }
            }
            
            self.navigationController.view.superview.frame = dropShadowViewFrame;
    }

    
    self.ppTableView.frame = [self layoutFrame];
    
    [UIView commitAnimations];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIGestureRecognizerDelegate

//================================================================================
//
//================================================================================
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch
{
    BOOL result = [super gestureRecognizer:gestureRecognizer shouldReceiveTouch:touch];
    
    if(result==YES)
    {
        NSArray *visibleCells = [self.ppTableView visibleCells];
        
        for(UITableViewCell *visibleCell in visibleCells)
        {
            if([touch.view isDescendantOfView:visibleCell]==YES)
            {
                if(visibleCell.selectionStyle!=UITableViewCellSelectionStyleNone)
                {
                    result = NO;
                }
                
                break;
            }
        }
    }
    
	return result;
}

@end
