//
//  PPCutPhoneNumberController.m
//
//  Created by UserDev3 on 2011/8/25
//  Fixed   by Howard   on 2013/10/15
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import "PPCutPhoneNumberController.h"

@implementation PPCutPhoneNumberController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    self = [super init];
    if(self != nil)
    {
        memset(_szInputBuffer, 0, sizeof(unsigned short) * K_CPNU_InputBufferCount);
        memset(_szOutputBuffer, 0, sizeof(unsigned short) * K_CPNU_OutputBufferCount);
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    //add by howard
    [self pp_clearExtBuffer];
    [self pp_clearInputBuffer];
    [self pp_clearOutputBuffer];
    [self pp_clearPhoneBuffer];
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)pp_clearInputBuffer
{
    memset(_szInputBuffer, 0, sizeof(unsigned short) * K_CPNU_InputBufferCount);
}


//================================================================================
//
//================================================================================
- (void)pp_clearOutputBuffer
{
    memset(_szOutputBuffer, 0, sizeof(unsigned short) * K_CPNU_OutputBufferCount);
}


//================================================================================
//
//================================================================================
- (void)pp_clearPhoneBuffer
{
    memset(_szPhoneBuffer, 0, sizeof(unsigned short) * K_CPNU_OutputBufferCount);
}


//================================================================================
//
//================================================================================
- (void)pp_clearExtBuffer
{
    memset(_szExtBuffer, 0, sizeof(unsigned short) * K_CPNU_OutputBufferCount);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (CutPhoneNumberCountryType)getPhoneFormatTypeFromCountryCode:(NSString*)aCountryCode
{
    CutPhoneNumberCountryType oneFormatType = CutPhoneNumberCountryType_NO_COUNTRY;
    
    if(aCountryCode == nil || [aCountryCode length] <= 0) return CutPhoneNumberCountryType_NO_COUNTRY;
    
    NSString* nsLowercaseCountryCode = nil;
    nsLowercaseCountryCode = [aCountryCode lowercaseString];
    if(nsLowercaseCountryCode)
    {    
        if([nsLowercaseCountryCode isEqualToString:@"tw"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_TW;            
        }
        else if([nsLowercaseCountryCode isEqualToString:@"us"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_US;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"cn"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_CN;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"hk"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_HK;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"ca"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_CA;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"uk"] == YES || [nsLowercaseCountryCode isEqualToString:@"gb"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_UK;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"in"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_IND;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"sg"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_SG;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"my"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_MY;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"id"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_INA;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"jp"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_JP;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"kr"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_KR;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"au"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_AU;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"de"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_DE;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"fr"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_FR;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"it"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_IT;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"es"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_ES;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"pt"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_PT;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"nl"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_NL;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"br"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_BR;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"at"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_AT;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"be"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_BE;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"ch"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_CH;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"no"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_NO;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"hu"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_HU;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"pl"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_PL;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"se"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_SE;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"dk"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_DK;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"fi"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_FI;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"tr"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_TR;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"ru"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_RU;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"gr"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_GR;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"mx"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_MX;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"cz"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_CZ;
        }
        else if([nsLowercaseCountryCode isEqualToString:@"sk"] == YES)
        {
            oneFormatType = CutPhoneNumberCountryType_SK;
        }
        else
        {
            oneFormatType = CutPhoneNumberCountryType_NO_COUNTRY;
        }
    }
    
    return oneFormatType;
}


//================================================================================
//
//================================================================================
- (NSString*)copyFormattedPhoneNumber:(NSString*)aOriPhoneNumber withCountryCode:(CutPhoneNumberCountryType)aFormatType
{
    NSString* retFormattedString = nil;
    
    do
    {
        if(aOriPhoneNumber==nil)
        {
            return nil;
        }
        
        //////////////////////////////////////////////////
        
        //  Default result to return
        retFormattedString = [[NSString alloc] initWithString:aOriPhoneNumber];
        
        if(retFormattedString==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //  Start processing
        NSUInteger iOriLen = [aOriPhoneNumber length];
        
        if(iOriLen<K_CPNU_InputBufferCount)
        {
            [self pp_clearInputBuffer];
            [aOriPhoneNumber getCharacters:_szInputBuffer range:NSMakeRange(0, iOriLen)];
            
            [self pp_clearOutputBuffer];
            CutPhoneNumber(_szInputBuffer, _szOutputBuffer, aFormatType);
            
            [self pp_clearPhoneBuffer];
            [self pp_clearExtBuffer];
            CutExtension(_szOutputBuffer, _szPhoneBuffer, _szExtBuffer);
            
            //////////////////////////////////////////////////
            
            int iPhoneLen = K_CPNU_OutputBufferCount;
            int iExtLen = K_CPNU_OutputBufferCount;
            
            for(int i=0; i<K_CPNU_OutputBufferCount; i++)
            {
                if(_szPhoneBuffer[i] == 0)
                {
                    iPhoneLen = i;
                    break;
                }
            }
            for(int i=0; i<K_CPNU_OutputBufferCount; i++)
            {
                if(_szExtBuffer[i] == 0)
                {
                    iExtLen = i;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            NSString* tmpString1 = [[NSString alloc] initWithCharacters:_szPhoneBuffer length:iPhoneLen];
            NSString* tmpString2 = [[NSString alloc] initWithCharacters:_szExtBuffer length:iExtLen];
            
            if(tmpString1==nil && tmpString2==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString* tmpString = nil;
            
            if([tmpString2 length] > 0)
            {
                tmpString = [[NSString alloc] initWithFormat:@"%@,%@",tmpString1,tmpString2];
            }
            else
            {
                if (tmpString1)
                {
                    tmpString = [[NSString alloc] initWithString:tmpString1];
                }
            }
            
            [tmpString1 release];
            [tmpString2 release];
            
            if(tmpString)
            {
                [retFormattedString release];
                retFormattedString = tmpString;
            }
        }

    } while (0);
    
    return retFormattedString;
}


//================================================================================
//
//================================================================================
- (NSString *)copyFormattedPhoneNumberWithoutExtension:(NSString *)aOriPhoneNumber withCountryCode:(CutPhoneNumberCountryType)aFormatType
{
    NSString *retFormattedString = nil;
    
    do
    {
        if(aOriPhoneNumber == nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //  Default result to return
        retFormattedString = [[NSString alloc] initWithString:aOriPhoneNumber];
        
        if(retFormattedString==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //  Start processing
        NSUInteger iOriLen = [aOriPhoneNumber length];
        
        if( iOriLen < K_CPNU_InputBufferCount)
        {
            [self pp_clearInputBuffer];
            [aOriPhoneNumber getCharacters:_szInputBuffer range:NSMakeRange(0, iOriLen)];
            
            [self pp_clearOutputBuffer];
            CutPhoneNumber(_szInputBuffer, _szOutputBuffer, aFormatType);
            
            //////////////////////////////////////////////////
            
            int iPhoneLen = K_CPNU_OutputBufferCount;
            
            for(int i=0; i<K_CPNU_OutputBufferCount; i++)
            {
                if(_szOutputBuffer[i] == 0)
                {
                    iPhoneLen = i;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            NSString* tmpString1 = [[NSString alloc] initWithCharacters:_szOutputBuffer length:iPhoneLen];
            
            if(tmpString1==nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSString* tmpString;
            
            tmpString = [[NSString alloc] initWithString:tmpString1];
            
            [tmpString1 release];
            
            
            if(retFormattedString!=nil)
            {
                [retFormattedString release];
                retFormattedString = nil;
                
            }
            if(tmpString)
            {
                [retFormattedString release];
                retFormattedString = tmpString;
            }
        }
    } while (0);
    
    return retFormattedString;
}


//================================================================================
//
//================================================================================
- (NSString *)copyFormattedPhoneNumber:(NSString*)aOriPhoneNumber withCountryCode:(NSString *)countryCode isFillWithCountryCode:(BOOL)isFillCountryCode
{
    
    CutPhoneNumberCountryType phoneNumberFormatType;
    
    phoneNumberFormatType = [self getPhoneFormatTypeFromCountryCode:countryCode];
    
    NSString* retFormattedString = nil;
    
    do
    {
        if(aOriPhoneNumber==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //  Default result to return
        retFormattedString = [[NSString alloc] initWithString:aOriPhoneNumber];
        
        if(retFormattedString==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //  Start processing
        NSUInteger iOriLen = [aOriPhoneNumber length];
        
        if( iOriLen < K_CPNU_InputBufferCount)
        {
            [self pp_clearInputBuffer];
            [aOriPhoneNumber getCharacters:_szInputBuffer range:NSMakeRange(0, iOriLen)];
            
            [self pp_clearOutputBuffer];
            CutPhoneNumber_Plus(_szInputBuffer, _szOutputBuffer, phoneNumberFormatType, isFillCountryCode);
            [self pp_clearPhoneBuffer];
            [self pp_clearExtBuffer];
            CutExtension(_szOutputBuffer, _szPhoneBuffer, _szExtBuffer);
            
            //////////////////////////////////////////////////
            
            int iPhoneLen = K_CPNU_OutputBufferCount;
            int iExtLen   = K_CPNU_OutputBufferCount;
            
            for(int i=0; i<K_CPNU_OutputBufferCount; i++)
            {
                if(_szPhoneBuffer[i] == 0)
                {
                    iPhoneLen = i;
                    break;
                }
            }
            
            for(int i=0; i<K_CPNU_OutputBufferCount; i++)
            {
                if(_szExtBuffer[i] == 0)
                {
                    iExtLen = i;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            NSString* tmpString1 = [[NSString alloc] initWithCharacters:_szPhoneBuffer length:iPhoneLen];
            if(tmpString1==nil)
            {
                break;
            }
            
            NSString* tmpString2 = [[NSString alloc] initWithCharacters:_szExtBuffer length:iExtLen];
            if(tmpString2==nil)
            {
                [tmpString1 release];
                break;
            }
            //////////////////////////////////////////////////
            
            NSString* tmpString;
            
            if([tmpString2 length] > 0)
            {
                tmpString = [[NSString alloc] initWithFormat:@"%@,%@",tmpString1,tmpString2];
            }
            else
            {
                tmpString = [[NSString alloc] initWithString:tmpString1];
            }
            
            [tmpString1 release];
            [tmpString2 release];
            
            if(tmpString)
            {
                [retFormattedString release];
                retFormattedString = tmpString;
            }
        }

    } while (0);
    
    return retFormattedString;
}


//================================================================================
//
//================================================================================
- (NSString*)copyFormattedPhoneNumber:(NSString*)aOriPhoneNumber
{
    NSString *retFormattedString = nil;
    
    do
    {
        if(aOriPhoneNumber==nil)
        {
            return nil;
        }
        
        //////////////////////////////////////////////////
        
        //  Default result to return
        retFormattedString = [[NSString alloc] initWithString:aOriPhoneNumber];
        
        if(retFormattedString==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        //  Start processing
        NSUInteger iOriLen = [aOriPhoneNumber length];
        
        if(iOriLen<K_CPNU_OutputBufferCount)
        {
            [self pp_clearOutputBuffer];
            [aOriPhoneNumber getCharacters:_szOutputBuffer range:NSMakeRange(0, iOriLen)];
            [self pp_clearPhoneBuffer];
            [self pp_clearExtBuffer];
            CutExtension(_szOutputBuffer, _szPhoneBuffer, _szExtBuffer);
            
            //////////////////////////////////////////////////
            
            int iPhoneLen = K_CPNU_OutputBufferCount;
            int iExtLen   = K_CPNU_OutputBufferCount;
            for(int i=0; i<K_CPNU_OutputBufferCount; i++)
            {
                if(_szPhoneBuffer[i] == 0)
                {
                    iPhoneLen = i;
                    break;
                }
            }
            for(int i=0; i<K_CPNU_OutputBufferCount; i++)
            {
                if(_szExtBuffer[i] == 0)
                {
                    iExtLen = i;
                    break;
                }
            }
            
            //////////////////////////////////////////////////
            
            NSString* tmpString1 = [[NSString alloc] initWithCharacters:_szPhoneBuffer length:iPhoneLen];
            if(tmpString1==nil)
            {
                break;
            }

            NSString* tmpString2 = [[NSString alloc] initWithCharacters:_szExtBuffer length:iExtLen];
            if(tmpString2==nil)
            {
                [tmpString1 release];
                break;
            }
            //////////////////////////////////////////////////
            
            NSString* tmpString;
            
            if([tmpString2 length] > 0)
            {
                tmpString = [[NSString alloc] initWithFormat:@"%@,%@",tmpString1,tmpString2];
            }
            else
            {
                tmpString = [[NSString alloc] initWithString:tmpString1];
            }
            
            [tmpString1 release];
            [tmpString2 release];
            
            if(tmpString)
            {
                [retFormattedString release];
                retFormattedString = tmpString;
            }
        }

    } while (0);
    
    return retFormattedString;
}

@end
