//
//  PPCountrySelectorViewController.h
//
//  Created by Eddie on 2011/6/28.
//  Fixed   by Howard on 2013/10/15.
//  Copyright 2011年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PPButton.h"
#import "PPViewController.h"
////////////////////////////////////////////////////////////////////////////////////////////////////

static NSUInteger const PPCS_RowHeight = 40;

////////////////////////////////////////////////////////////////////////////////////////////////////

@protocol PPCountrySelectorViewControllerDelegate <NSObject>
 - (void)ppCountrySelectorTableViewDidSelectCountry:(NSString *)countryCode countryName:(NSString *)countryName;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCountrySelectorViewController : PPViewController <PPButtonDelegate>

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain) NSString *currentCountryCode;
@property (nonatomic,retain) UIColor  *backButtonHighlightedBackgroundColor;
@property (nonatomic,assign) UIEdgeInsets imageEdgeInsets;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (id)initWithFrame:(CGRect)frame delegate:(id)delegate;
- (void)setDisplayLanguageWithLanguageCode:(NSString *)languageCode;


@end
