//
//  PPiCloudOperation_LoadFile.m
//  
//
//  Created by Mike on 13/4/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPiCloudOperation_LoadFile.h"

static NSInteger staticMetadataQueryCount = 0;
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPiCloudOperation_LoadFile()

@interface PPiCloudOperation_LoadFile()
@property(nonatomic,retain) NSMetadataQuery *metadataQuery;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPiCloudOperation_LoadFile

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadFile        = loadFile_;
@synthesize intoPath        = intoPath_;
@synthesize metadataQuery   = metadataQuery_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{
    if((self=[super init]))
    {
        metadataQuery_ = [[NSMetadataQuery alloc] init];
        
        if(self.metadataQuery!=nil)
        {
            [self.metadataQuery setPredicate:[NSPredicate predicateWithFormat:@"%K like '*'", NSMetadataItemFSNameKey]];
            
            [self.metadataQuery setSearchScopes:[NSArray arrayWithObjects:
                                                 NSMetadataQueryUbiquitousDocumentsScope,
                                                 NSMetadataQueryUbiquitousDataScope,
                                                 nil]];
        }
    }
    
    return self;
}

- (void)dealloc
{
    // !! 因為main裡面有用到 observer, 所以這邊要清掉
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    
    [loadFile_ release];
    [intoPath_ release];
    [metadataQuery_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.loadFile==nil || self.intoPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(self.metadataQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
//mike
            [[NSNotificationCenter defaultCenter] addObserver:self
                                                     selector:@selector(metadataQueryDidStartGatheringNotification:)
                                                         name:NSMetadataQueryDidStartGatheringNotification
                                                       object:self.metadataQuery];

            [[NSNotificationCenter defaultCenter] addObserver:self
                                                     selector:@selector(metadataQueryGatheringProgressNotification:)
                                                         name:NSMetadataQueryGatheringProgressNotification
                                                       object:self.metadataQuery];

            [[NSNotificationCenter defaultCenter] addObserver:self
                                                     selector:@selector(metadataQueryDidUpdateNotification:)
                                                         name:NSMetadataQueryDidUpdateNotification
                                                       object:self.metadataQuery];
            
            [[NSNotificationCenter defaultCenter] addObserver:self
                                                     selector:@selector(metadataQueryDidFinishGatheringNotification:)
                                                         name:NSMetadataQueryDidFinishGatheringNotification
                                                       object:self.metadataQuery];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            [self.metadataQuery startQuery];
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:loadFileFailedWithError:)]==YES)
            {
                [self.delegate ppiCloudOperation:self loadFileFailedWithError:error];
            }
            
            [self completion];
        }
    }
}

- (void)metadataQueryDidStartGatheringNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
}

- (void)metadataQueryGatheringProgressNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
}

- (void)metadataQueryDidUpdateNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
}

- (void)metadataQueryDidFinishGatheringNotification:(NSNotification *)notification
{
    //mike
//    NSLog(@"class(%@) cmd(%@)", [self class], NSStringFromSelector(_cmd));
    
    //這邊只是為了要讓local與server狀態是一致的
    
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            [self.metadataQuery stopQuery];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSURL *loadFileURL = [self URLForCloudPath:self.loadFile];
            if(loadFileURL==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            NSString *downloadingStatus = nil;
            if([loadFileURL getResourceValue:&downloadingStatus forKey:NSURLUbiquitousItemDownloadingStatusKey error:&error]==NO)
            {
                error = [self convertErrorFromSystemError:error];
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([downloadingStatus isEqualToString:NSURLUbiquitousItemDownloadingStatusCurrent]==YES)
            {
                // 先刪除cache中的檔案
                [[NSFileManager defaultManager] removeItemAtPath:self.intoPath error:nil];
                
                //已經下載了可以直接拷貝了
                if([[NSFileManager defaultManager] copyItemAtPath:[loadFileURL path] toPath:self.intoPath error:&error]==NO)
                {
                    error = [self convertErrorFromSystemError:error];
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                if([self.delegate respondsToSelector:@selector(ppiCloudOperation:loadedFile:)]==YES)
                {
                    [self.delegate ppiCloudOperation:self loadedFile:self.intoPath];
                }
                
                staticMetadataQueryCount = 0;
                [self completion];
            }
            else
            {
                NSNumber *isDownloadingNumber = nil;
                if([loadFileURL getResourceValue:&isDownloadingNumber forKey:NSURLUbiquitousItemDownloadRequestedKey error:&error]==NO)
                {
                    error = [self convertErrorFromSystemError:error];
                    break;
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
//                if([isDownloadingNumber boolValue]==YES)
//                {
//                    if([self.delegate respondsToSelector:@selector(ppiCloudOperation:loadProgress:forFile:)]==YES)
//                    {
//                        NSError *error = nil;
//                        NSNumber *percentDownloadedNumber = nil;
//                        if([loadFileURL getResourceValue:&percentDownloadedNumber forKey:NSMetadataUbiquitousItemPercentDownloadedKey error:&error]==YES)
//                        {
//                            [self.delegate ppiCloudOperation:self loadProgress:[percentDownloadedNumber doubleValue] forFile:self.intoPath];
//                        }
//                    }
//                }
//                else
                {
                    //這邊要檢查是否可以下載
                    
                    NSNumber *isUploadedNumber = nil;
                    if([loadFileURL getResourceValue:&isUploadedNumber forKey:NSURLUbiquitousItemIsUploadedKey error:&error]==NO)
                    {
                        error = [self convertErrorFromSystemError:error];
                        break;
                    }
                    
                    ////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    if([isUploadedNumber boolValue]==YES)
                    {
                        //可以下載就要求馬上下載
                        [NSThread sleepForTimeInterval:0.1];
                        if([[NSFileManager defaultManager] startDownloadingUbiquitousItemAtURL:loadFileURL error:&error]==NO)
                        {
                            error = [self convertErrorFromSystemError:error];
                            break;
                        }
                        
                        ////////////////////////////////////////////////////////////////////////////////////////////////////
                        
                        __block typeof(self) bolckSelf = self;
                        
                        if (staticMetadataQueryCount<10)
                        {
                            dispatch_async(dispatch_get_main_queue(), ^{
                                
                                [bolckSelf.metadataQuery startQuery];
                                staticMetadataQueryCount++;
                            });
                        }
                    }
                    else
                    {
                        //根本還沒有上傳到Server無法下載
                        error = PPErrorOperationFailed(@"isUploaded = false");
                        break;
                    }
                }
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:loadFileFailedWithError:)]==YES)
            {
                [self.delegate ppiCloudOperation:self loadFileFailedWithError:error];
            }
            
            staticMetadataQueryCount = 0;
            [self completion];
        }
    }
}

@end
