//
//  PPiCloudOperation_CreateFolder.m
//  
//
//  Created by Mike on 13/4/19.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPiCloudOperation_CreateFolder.h"

@implementation PPiCloudOperation_CreateFolder

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize createFolder = createFolder_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [createFolder_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
	
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.createFolder==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSURL *createFolderURL = [self URLForCloudPath:self.createFolder];
            if(createFolderURL==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSFileManager *fileManager = [NSFileManager defaultManager];
            if(fileManager==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([fileManager createDirectoryAtURL:createFolderURL
                     withIntermediateDirectories:YES
                                      attributes:nil
                                           error:&error]==NO)
            {
                error = [self convertErrorFromSystemError:error];
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:createdFolder:)]==YES)
            {
                PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithiCloudURL:createFolderURL path:self.createFolder error:&error];
                
                if(ppCloudMetadata!=nil)
                {
                    if(error==nil)
                    {
                        [self.delegate ppiCloudOperation:self createdFolder:ppCloudMetadata];
                    }
                    
                    [ppCloudMetadata release];
                }
                else
                {
                    if(error != nil)
                    {
                        error = [self convertErrorFromSystemError:error];
                    }                
                }
            }
             
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppiCloudOperation:createFolderFailedWithError:)]==YES)
            {
                [self.delegate ppiCloudOperation:self createFolderFailedWithError:error];
            }
        }
        
        [self completion];
    }
}

@end
